/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.provider.managed;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.abdera.Abdera;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.provider.managed.FeedConfiguration;
import org.apache.abdera.protocol.server.provider.managed.ServerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionAdapterManager {
    public static Logger logger = Logger.getLogger(CollectionAdapterManager.class.getName());
    protected static Map<String, CollectionAdapter> adapterInstanceMap = new HashMap<String, CollectionAdapter>();
    protected final Abdera abdera;
    protected final ServerConfiguration config;

    public CollectionAdapterManager(Abdera abdera, ServerConfiguration config) {
        this.abdera = abdera;
        this.config = config;
    }

    public CollectionAdapter getAdapter(String feedId) throws Exception {
        FeedConfiguration feedConfiguration = this.config.loadFeedConfiguration(feedId);
        return CollectionAdapterManager.createAdapterInstance(feedConfiguration, this.abdera);
    }

    public Map<String, FeedConfiguration> listAdapters() throws Exception {
        HashMap<String, FeedConfiguration> results = new HashMap<String, FeedConfiguration>();
        Enumeration<URL> e = Thread.currentThread().getContextClassLoader().getResources(this.config.getFeedConfigLocation());
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            File file = new File(url.toURI());
            if (!file.exists()) {
                throw new RuntimeException("Could not convert properties path to a File! \"" + file.getAbsolutePath() + "\" does not exist.");
            }
            File[] files = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return !file.isDirectory();
                }
            });
            if (files == null) continue;
            for (File _file : files) {
                FeedConfiguration feedConfiguration;
                String id;
                String name = _file.getName();
                int i = name.indexOf(this.config.getFeedConfigSuffix());
                String string = id = i > -1 ? name.substring(0, i) : null;
                if (id == null || null == (feedConfiguration = this.loadFeedInfo(id))) continue;
                results.put(id, feedConfiguration);
            }
        }
        return results;
    }

    protected FeedConfiguration loadFeedInfo(String feedId) throws Exception {
        return this.config.loadFeedConfiguration(feedId);
    }

    protected static synchronized CollectionAdapter createAdapterInstance(FeedConfiguration config, Abdera abdera) throws Exception {
        Constructor<?>[] ctors;
        CollectionAdapter basicAdapter = adapterInstanceMap.get(config.getFeedId());
        if (basicAdapter != null) {
            return basicAdapter;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> adapterClass = cl.loadClass(config.getAdapterClassName());
        for (Constructor<?> element : ctors = adapterClass.getConstructors()) {
            logger.finest("Public constructor found: " + element.toString());
        }
        Constructor<?> c = adapterClass.getConstructor(Abdera.class, FeedConfiguration.class);
        c.setAccessible(true);
        CollectionAdapter adapterInstance = (CollectionAdapter)c.newInstance(abdera, config);
        adapterInstanceMap.put(config.getFeedId(), adapterInstance);
        return adapterInstance;
    }
}

