/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.DataHandler;
import org.jamwiki.Environment;
import org.jamwiki.SearchEngine;
import org.jamwiki.WikiBase;
import org.jamwiki.WikiException;
import org.jamwiki.WikiMessage;
import org.jamwiki.WikiVersion;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.Role;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicType;
import org.jamwiki.model.VirtualWiki;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.Pagination;
import org.jamwiki.utils.PseudoTopicHandler;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLink;
import org.jamwiki.utils.WikiLogger;

public class WikiUtil {
    private static final WikiLogger logger = WikiLogger.getLogger(WikiUtil.class.getName());
    public static String WEBAPP_CONTEXT_PATH = null;
    private static final Pattern INVALID_NAMESPACE_NAME_PATTERN = Pattern.compile(Environment.getValue("pattern-namespace-name-invalid"));
    private static final Pattern INVALID_ROLE_NAME_PATTERN = Pattern.compile(Environment.getValue("pattern-role-name-invalid"));
    private static final Pattern INVALID_TOPIC_NAME_PATTERN = Pattern.compile(Environment.getValue("pattern-topic-name-invalid"));
    private static final Pattern VALID_USER_LOGIN_PATTERN = Pattern.compile(Environment.getValue("pattern-login-valid"));
    private static final Pattern VALID_VIRTUAL_WIKI_PATTERN = Pattern.compile(Environment.getValue("pattern-virtualwiki-valid"));
    private static final Pattern XSS_PATTERN = Pattern.compile("[\\\"><]");
    public static final String PARAMETER_TOPIC = "topic";
    public static final String PARAMETER_VIRTUAL_WIKI = "virtualWiki";
    public static final String PARAMETER_WATCHLIST = "watchlist";

    public static Pagination buildPagination(HttpServletRequest request) {
        int num = Environment.getIntValue("recent-changes-days");
        if (request.getParameter("num") != null) {
            try {
                num = Integer.parseInt(request.getParameter("num"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int offset = 0;
        if (request.getParameter("offset") != null) {
            try {
                offset = Integer.parseInt(request.getParameter("offset"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Pagination(num, offset);
    }

    public static DataHandler dataHandlerInstance() throws IOException {
        if (StringUtils.isBlank((String)Environment.getValue("database-type"))) {
            logger.warn("WikiUtil.dataHandlerInstance called without a valid PROP_DB_TYPE value");
        }
        String dataHandlerClass = Environment.getValue("database-type");
        try {
            return (DataHandler)Utilities.instantiateClass(dataHandlerClass);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Data handler specified in jamwiki.properties does not implement org.jamwiki.DataHandler: " + dataHandlerClass);
        }
    }

    public static String encodeForFilename(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("File name not specified in encodeForFilename");
        }
        String result = Utilities.encodeTopicName(name);
        try {
            result = URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupporting encoding UTF-8");
        }
        return result;
    }

    public static String extractCommentsLink(String virtualWiki, String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Topic name must not be empty in extractCommentsLink");
        }
        WikiLink wikiLink = LinkUtil.parseWikiLink(virtualWiki, name);
        Namespace commentsNamespace = null;
        try {
            commentsNamespace = Namespace.findCommentsNamespace(wikiLink.getNamespace());
        }
        catch (DataAccessException e) {
            throw new IllegalStateException("Database error while retrieving comments namespace", e);
        }
        if (commentsNamespace == null) {
            throw new IllegalArgumentException("Topic " + name + " does not have a comments namespace");
        }
        return !StringUtils.isBlank((String)commentsNamespace.getLabel(virtualWiki)) ? commentsNamespace.getLabel(virtualWiki) + ":" + wikiLink.getArticle() : wikiLink.getArticle();
    }

    public static String extractTopicLink(String virtualWiki, String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Topic name must not be empty in extractTopicLink");
        }
        WikiLink wikiLink = LinkUtil.parseWikiLink(virtualWiki, name);
        Namespace mainNamespace = Namespace.findMainNamespace(wikiLink.getNamespace());
        if (mainNamespace == null) {
            throw new IllegalArgumentException("Topic " + name + " does not have a main namespace");
        }
        return !StringUtils.isBlank((String)mainNamespace.getLabel(virtualWiki)) ? mainNamespace.getLabel(virtualWiki) + ":" + wikiLink.getArticle() : wikiLink.getArticle();
    }

    public static String findDefaultVirtualWikiUrl(String virtualWikiName) {
        VirtualWiki virtualWiki = VirtualWiki.defaultVirtualWiki();
        if (!StringUtils.isBlank((String)virtualWikiName)) {
            try {
                virtualWiki = WikiBase.getDataHandler().lookupVirtualWiki(virtualWikiName);
            }
            catch (DataAccessException e) {
                logger.warn("Unable to retrieve default topic for virtual wiki", e);
            }
        }
        return "/" + virtualWiki.getName() + "/" + virtualWiki.getRootTopicName();
    }

    public static Topic findRedirectedTopic(Topic parent, int attempts) throws DataAccessException {
        Topic child;
        int count = attempts;
        String target = parent.getRedirectTo();
        if (parent.getTopicType() != TopicType.REDIRECT || StringUtils.isBlank((String)target)) {
            logger.error("getRedirectTarget() called for non-redirect topic " + parent.getName());
            return parent;
        }
        if (++count > 10) {
            return parent;
        }
        String virtualWiki = parent.getVirtualWiki();
        WikiLink wikiLink = LinkUtil.parseWikiLink(virtualWiki, target);
        if (wikiLink.getVirtualWiki() != null) {
            virtualWiki = wikiLink.getVirtualWiki().getName();
        }
        if ((child = WikiBase.getDataHandler().lookupTopic(virtualWiki, wikiLink.getDestination(), false, null)) == null) {
            return parent;
        }
        if (StringUtils.isBlank((String)child.getRedirectTo())) {
            return child;
        }
        return WikiUtil.findRedirectedTopic(child, count);
    }

    public static TopicType findTopicTypeForNamespace(Namespace namespace) {
        if (namespace != null) {
            if (namespace.getId().equals(14)) {
                return TopicType.CATEGORY;
            }
            if (namespace.getId().equals(10)) {
                return TopicType.TEMPLATE;
            }
            if (namespace.getId().equals(8)) {
                return TopicType.SYSTEM_FILE;
            }
            if (namespace.getId().equals(6)) {
                return TopicType.IMAGE;
            }
        }
        return TopicType.ARTICLE;
    }

    public static String getBaseUrl() throws DataAccessException {
        VirtualWiki virtualWiki = VirtualWiki.defaultVirtualWiki();
        String url = Environment.getValue("server-url");
        url = url + LinkUtil.buildTopicUrl(WEBAPP_CONTEXT_PATH, virtualWiki.getName(), virtualWiki.getRootTopicName(), true);
        return url;
    }

    public static String getParameterFromRequest(HttpServletRequest request, String name, boolean decodeUnderlines) {
        String value = null;
        if (request.getMethod().equalsIgnoreCase("GET")) {
            String query = Utilities.getQueryString(request);
            if (StringUtils.isBlank((String)query)) {
                return null;
            }
            String prefix = name + "=";
            int pos = query.indexOf(prefix);
            if (pos != -1 && pos + prefix.length() < query.length() && (value = query.substring(pos + prefix.length())).indexOf(38) != -1) {
                value = value.substring(0, value.indexOf(38));
            }
            return Utilities.decodeAndEscapeTopicName(value, decodeUnderlines);
        }
        value = request.getParameter(name);
        if (value == null) {
            value = (String)request.getAttribute(name);
        }
        if (value == null) {
            return null;
        }
        return Utilities.decodeTopicName(value, decodeUnderlines);
    }

    public static File getTempDirectory() {
        String subdirectory = "tmp";
        File directory = new File(Environment.getValue("homeDir"), subdirectory);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    public static String getTopicFromRequest(HttpServletRequest request) throws WikiException {
        String topic = WikiUtil.getParameterFromRequest(request, PARAMETER_TOPIC, true);
        if (StringUtils.isBlank((String)topic)) {
            return topic;
        }
        Matcher m = XSS_PATTERN.matcher(topic);
        if (m.find()) {
            throw new WikiException(new WikiMessage("common.exception.name", topic));
        }
        return topic;
    }

    public static String getTopicFromURI(HttpServletRequest request) {
        String topic = WikiUtil.retrieveDirectoriesFromURI(request, 1);
        if (topic == null) {
            logger.info("No topic in URL: " + request.getRequestURI());
            return null;
        }
        int pos = topic.indexOf(35);
        if (pos != -1) {
            if (pos == 0) {
                logger.warn("No topic in URL: " + request.getRequestURI());
                return null;
            }
            topic = topic.substring(0, pos);
        }
        if ((pos = topic.indexOf(63)) != -1) {
            if (pos == 0) {
                logger.warn("No topic in URL: " + request.getRequestURI());
                return null;
            }
            topic = topic.substring(0, pos);
        }
        if ((pos = topic.indexOf(59)) != -1) {
            if (pos == 0) {
                logger.warn("No topic in URL: " + request.getRequestURI());
                return null;
            }
            topic = topic.substring(0, pos);
        }
        if (!StringUtils.isBlank((String)topic)) {
            topic = Utilities.decodeAndEscapeTopicName(topic, true);
        }
        return topic;
    }

    public static String getVirtualWikiFromRequest(HttpServletRequest request) {
        String virtualWiki = request.getParameter(PARAMETER_VIRTUAL_WIKI);
        if (virtualWiki == null) {
            virtualWiki = (String)request.getAttribute(PARAMETER_VIRTUAL_WIKI);
        }
        if (virtualWiki == null) {
            return null;
        }
        return Utilities.decodeTopicName(virtualWiki, true);
    }

    public static String getVirtualWikiFromURI(HttpServletRequest request) {
        String uri = WikiUtil.retrieveDirectoriesFromURI(request, 0);
        if (StringUtils.isBlank((String)uri)) {
            logger.info("No virtual wiki found in URL: " + request.getRequestURI());
            return null;
        }
        String virtualWiki = uri;
        int slashIndex = uri.indexOf(47);
        if (slashIndex != -1) {
            virtualWiki = uri.substring(0, slashIndex);
        }
        return Utilities.decodeAndEscapeTopicName(virtualWiki, true);
    }

    public static boolean isCommentsPage(String virtualWiki, String topicName) {
        WikiLink wikiLink = LinkUtil.parseWikiLink(virtualWiki, topicName);
        if (wikiLink.getNamespace().getId().equals(-1)) {
            return false;
        }
        try {
            return Namespace.findCommentsNamespace(wikiLink.getNamespace()) != null;
        }
        catch (DataAccessException e) {
            throw new IllegalStateException("Database error while retrieving comments namespace", e);
        }
    }

    public static boolean isFirstUse() {
        return !Environment.getBooleanValue("props-initialized");
    }

    public static boolean isUpgrade() {
        if (WikiUtil.isFirstUse()) {
            return false;
        }
        WikiVersion oldVersion = new WikiVersion(Environment.getValue("wiki-version"));
        WikiVersion currentVersion = new WikiVersion("1.0.7");
        return oldVersion.before(currentVersion);
    }

    private static String retrieveDirectoriesFromURI(HttpServletRequest request, int skipCount) {
        String uri = request.getRequestURI().trim();
        uri = Utilities.convertEncoding(uri, "ISO-8859-1", "UTF-8");
        String contextPath = request.getContextPath().trim();
        if (StringUtils.isBlank((String)uri) || contextPath == null) {
            return null;
        }
        if ((uri = uri.replaceAll("(/){2,}", "/")).length() <= contextPath.length()) {
            return null;
        }
        uri = uri.substring(contextPath.length() + 1);
        for (int i = 0; i < skipCount; ++i) {
            int slashIndex = uri.indexOf(47);
            if (slashIndex == -1) {
                return null;
            }
            uri = uri.substring(slashIndex + 1);
        }
        return uri;
    }

    public static List retrieveUploadFileList() {
        ArrayList<String> list = new ArrayList<String>();
        int blacklistType = Environment.getIntValue("file-blacklist-type");
        String listString = "";
        if (blacklistType == 2) {
            listString = Environment.getValue("file-blacklist");
        } else if (blacklistType == 3) {
            listString = Environment.getValue("file-whitelist");
        }
        String[] tokens = listString.split("[\\s,\\.]");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (StringUtils.isBlank((String)token)) continue;
            list.add(token.toLowerCase());
        }
        return list;
    }

    public static SearchEngine searchEngineInstance() {
        String searchEngineClass = Environment.getValue("search-engine");
        try {
            return (SearchEngine)Utilities.instantiateClass(searchEngineClass);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Search engine specified in jamwiki.properties does not implement org.jamwiki.SearchEngine: " + searchEngineClass);
        }
    }

    public static WikiMessage validateDirectory(String name) {
        File directory = new File(name);
        if (!directory.exists() || !directory.isDirectory()) {
            return new WikiMessage("error.directoryinvalid", name);
        }
        String filename = "jamwiki-test-" + System.currentTimeMillis() + ".txt";
        File file = new File(name, filename);
        String text = "Testing";
        String read = null;
        try {
            FileUtils.writeStringToFile((File)file, (String)text, (String)"UTF-8");
        }
        catch (IOException e) {
            return new WikiMessage("error.directorywrite", name, e.getMessage());
        }
        try {
            read = FileUtils.readFileToString((File)file, (String)"UTF-8");
            if (read == null || !text.equals(read)) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            return new WikiMessage("error.directoryread", name, e.getMessage());
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            return new WikiMessage("error.directorydelete", name, e.getMessage());
        }
        return null;
    }

    public static void validateNamespaceName(String name) throws WikiException {
        if (name == null || name.length() != 0 && StringUtils.isBlank((String)name) || name.length() != name.trim().length()) {
            throw new WikiException(new WikiMessage("admin.vwiki.error.namespace.whitespace", name));
        }
        Matcher m = INVALID_NAMESPACE_NAME_PATTERN.matcher(name);
        if (m.find()) {
            throw new WikiException(new WikiMessage("admin.vwiki.error.namespace.characters", name));
        }
        List<Namespace> namespaces = null;
        try {
            namespaces = WikiBase.getDataHandler().lookupNamespaces();
        }
        catch (DataAccessException e) {
            throw new WikiException(new WikiMessage("error.unknown", e.getMessage()));
        }
        for (Namespace namespace : namespaces) {
            if (name.equals(namespace.getDefaultLabel())) {
                throw new WikiException(new WikiMessage("admin.vwiki.error.namespace.unique", name));
            }
            for (String namespaceTranslation : namespace.getNamespaceTranslations().values()) {
                if (!name.equals(namespaceTranslation)) continue;
                throw new WikiException(new WikiMessage("admin.vwiki.error.namespace.unique", name));
            }
        }
    }

    public static void validateRole(Role role) throws WikiException {
        Matcher m = INVALID_ROLE_NAME_PATTERN.matcher(role.getAuthority());
        if (!m.matches()) {
            throw new WikiException(new WikiMessage("roles.error.name", role.getAuthority()));
        }
        if (!StringUtils.isBlank((String)role.getDescription()) && role.getDescription().length() > 200) {
            throw new WikiException(new WikiMessage("roles.error.description"));
        }
    }

    public static void validateTopicName(String virtualWiki, String name) throws WikiException {
        if (StringUtils.isBlank((String)virtualWiki)) {
            throw new WikiException(new WikiMessage("common.exception.novirtualwiki"));
        }
        if (StringUtils.isBlank((String)name)) {
            throw new WikiException(new WikiMessage("common.exception.notopic"));
        }
        if (PseudoTopicHandler.isPseudoTopic(name)) {
            throw new WikiException(new WikiMessage("common.exception.pseudotopic", name));
        }
        WikiLink wikiLink = LinkUtil.parseWikiLink(virtualWiki, name);
        String article = StringUtils.trimToNull((String)wikiLink.getArticle());
        if (StringUtils.startsWith((String)article, (String)"/")) {
            throw new WikiException(new WikiMessage("common.exception.name", name));
        }
        if (wikiLink.getNamespace().getId().equals(-1)) {
            throw new WikiException(new WikiMessage("common.exception.name", name));
        }
        Matcher m = INVALID_TOPIC_NAME_PATTERN.matcher(name);
        if (m.find()) {
            throw new WikiException(new WikiMessage("common.exception.name", name));
        }
    }

    public static void validatePassword(String password, String confirmPassword) throws WikiException {
        if (StringUtils.isBlank((String)password)) {
            throw new WikiException(new WikiMessage("error.newpasswordempty"));
        }
        if (StringUtils.isBlank((String)confirmPassword)) {
            throw new WikiException(new WikiMessage("error.passwordconfirm"));
        }
        if (!password.equals(confirmPassword)) {
            throw new WikiException(new WikiMessage("admin.message.passwordsnomatch"));
        }
    }

    public static void validateUserName(String name) throws WikiException {
        if (StringUtils.isBlank((String)name)) {
            throw new WikiException(new WikiMessage("error.loginempty"));
        }
        Matcher m = VALID_USER_LOGIN_PATTERN.matcher(name);
        if (!m.matches()) {
            throw new WikiException(new WikiMessage("common.exception.name", name));
        }
    }

    public static void validateVirtualWikiName(String virtualWikiName) throws WikiException {
        if (StringUtils.isBlank((String)virtualWikiName)) {
            throw new WikiException(new WikiMessage("common.exception.novirtualwiki"));
        }
        Matcher m = VALID_VIRTUAL_WIKI_PATTERN.matcher(virtualWikiName);
        if (!m.matches()) {
            throw new WikiException(new WikiMessage("common.exception.name", virtualWikiName));
        }
    }
}

