/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html.ancestor;

public class ChangeText {
    private int maxNbCharsPerLine;
    private StringBuilder txt = new StringBuilder();
    public static final String newLine = "<br/>";
    private int charsThisLine = 0;

    public ChangeText(int n) {
        this.maxNbCharsPerLine = n;
    }

    public synchronized void addText(String string) {
        if ((string = this.clean(string)).length() + this.charsThisLine > this.maxNbCharsPerLine) {
            this.addTextCarefully(string);
        } else {
            this.addToLine(string);
        }
    }

    private void addToLine(String string) {
        this.txt.append(string);
        this.charsThisLine += string.length();
    }

    public synchronized void addHtml(String string) {
        this.txt.append(string);
        if (string.contains("</li>") || string.contains("</ol>") || string.contains("</ul>")) {
            this.charsThisLine = 0;
        }
    }

    private synchronized void addTextCarefully(String string) {
        int n = string.indexOf(" ");
        if (n < 0) {
            if (string.length() < this.maxNbCharsPerLine) {
                if (this.charsThisLine > 0) {
                    this.addNewLine();
                }
                this.addText(string);
            } else {
                this.addNewLine();
                this.addTextBrokenAcrossLines(string);
            }
        } else if (n + 1 >= this.maxNbCharsPerLine) {
            if (this.charsThisLine > 0) {
                this.addNewLine();
            }
            this.addTextBrokenAcrossLines(string.substring(0, n + 1));
            if (n + 1 < string.length()) {
                this.addText(string.substring(n + 1, string.length()));
            }
        } else if (n + 1 + this.charsThisLine > this.maxNbCharsPerLine) {
            this.addNewLine();
            this.addText(string);
        } else {
            this.addText(string.substring(0, n + 1));
            if (n + 1 < string.length()) {
                this.addTextCarefully(string.substring(n + 1, string.length()));
            }
        }
    }

    private void addTextBrokenAcrossLines(String string) {
        assert (string.indexOf(32) < 0 && string.length() > this.maxNbCharsPerLine);
        int n = Math.min(string.length(), this.maxNbCharsPerLine - this.charsThisLine);
        this.addText(string.substring(0, n));
        this.addNewLine();
        this.addText(string.substring(n, string.length()));
    }

    public synchronized void addNewLine() {
        this.addHtml(newLine);
        this.charsThisLine = 0;
    }

    public String toString() {
        return this.txt.toString();
    }

    private String clean(String string) {
        return string.replaceAll("\n", "").replaceAll("\r", "").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&#39;").replaceAll("\"", "&#34;");
    }
}

