/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.providers;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.QueryItem;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.WikiAttachmentProvider;
import com.ecyrd.jspwiki.util.ClassUtil;
import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.CacheEntry;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.base.events.CacheEntryEvent;
import com.opensymphony.oscache.base.events.CacheEntryEventListener;
import com.opensymphony.oscache.base.events.CacheEventListener;
import com.opensymphony.oscache.base.events.CacheGroupEvent;
import com.opensymphony.oscache.base.events.CachePatternEvent;
import com.opensymphony.oscache.base.events.CachewideEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingAttachmentProvider
implements WikiAttachmentProvider {
    private static final Logger log = Logger.getLogger(CachingAttachmentProvider.class);
    private WikiAttachmentProvider m_provider;
    private Cache m_cache;
    private long m_cacheMisses = 0L;
    private long m_cacheHits = 0L;
    private Cache m_attCache;
    public static final String DIR_EXTENSION = "-att";
    public static final String PROP_STORAGEDIR = "jspwiki.basicAttachmentProvider.storageDir";
    private int m_refreshPeriod = 600;
    private boolean m_gotall = false;
    private CachedAttachmentCollector m_allCollector = new CachedAttachmentCollector();

    @Override
    public void initialize(WikiEngine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        log.info((Object)"Initing CachingAttachmentProvider");
        this.m_cache = new Cache(true, false, true);
        this.m_attCache = new Cache(true, false, true);
        this.m_attCache.addCacheEventListener((CacheEventListener)this.m_allCollector, CacheEntryEventListener.class);
        String classname = WikiEngine.getRequiredProperty(properties, "jspwiki.attachmentProvider");
        try {
            Class providerclass = ClassUtil.findClass("com.ecyrd.jspwiki.providers", classname);
            this.m_provider = (WikiAttachmentProvider)providerclass.newInstance();
            log.debug((Object)("Initializing real provider class " + this.m_provider));
            this.m_provider.initialize(engine, properties);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to locate provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("no provider class");
        }
        catch (InstantiationException e) {
            log.error((Object)("Unable to create provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("faulty provider class");
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal access to provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("illegal provider class");
        }
    }

    @Override
    public void putAttachmentData(Attachment att, InputStream data) throws ProviderException, IOException {
        this.m_provider.putAttachmentData(att, data);
        this.m_cache.removeEntry(att.getParentName());
        att.setLastModified(new Date());
        this.m_attCache.putInCache(att.getName(), (Object)att);
    }

    @Override
    public InputStream getAttachmentData(Attachment att) throws ProviderException, IOException {
        return this.m_provider.getAttachmentData(att);
    }

    @Override
    public Collection listAttachments(WikiPage page) throws ProviderException {
        log.debug((Object)("Listing attachments for " + page));
        try {
            Collection c = (Collection)this.m_cache.getFromCache(page.getName(), this.m_refreshPeriod);
            if (c != null) {
                log.debug((Object)("LIST from cache, " + page.getName() + ", size=" + c.size()));
                ++this.m_cacheHits;
                return this.cloneCollection(c);
            }
            log.debug((Object)("list NOT in cache, " + page.getName()));
            this.refresh(page);
        }
        catch (NeedsRefreshException nre) {
            try {
                Collection<Attachment> c = this.refresh(page);
                return this.cloneCollection(c);
            }
            catch (Exception ex) {
                log.warn((Object)"Provider failed, returning cached content", (Throwable)ex);
                this.m_cache.cancelUpdate(page.getName());
                return (Collection)nre.getCacheContent();
            }
        }
        return new ArrayList();
    }

    private <T> Collection<T> cloneCollection(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(c);
        return list;
    }

    @Override
    public Collection findAttachments(QueryItem[] query) {
        return this.m_provider.findAttachments(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List listAllChanged(Date timestamp) throws ProviderException {
        List all = null;
        if (!this.m_gotall) {
            all = this.m_provider.listAllChanged(timestamp);
            CachingAttachmentProvider cachingAttachmentProvider = this;
            synchronized (cachingAttachmentProvider) {
                for (Attachment att : all) {
                    this.m_attCache.putInCache(att.getName(), (Object)att);
                }
                this.m_gotall = true;
            }
        } else {
            all = this.m_allCollector.getAllItems();
        }
        return all;
    }

    private Attachment findAttachmentFromCollection(Collection c, String name) {
        for (Attachment att : c) {
            if (!name.equals(att.getFileName())) continue;
            return att;
        }
        return null;
    }

    private final Collection<Attachment> refresh(WikiPage page) throws ProviderException {
        ++this.m_cacheMisses;
        Collection c = this.m_provider.listAttachments(page);
        this.m_cache.putInCache(page.getName(), (Object)c);
        return c;
    }

    @Override
    public Attachment getAttachmentInfo(WikiPage page, String name, int version) throws ProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting attachments for " + page + ", name=" + name + ", version=" + version));
        }
        if (version != -1) {
            log.debug((Object)"...we don't cache old versions");
            return this.m_provider.getAttachmentInfo(page, name, version);
        }
        try {
            Collection<Attachment> c = (Collection<Attachment>)this.m_cache.getFromCache(page.getName(), this.m_refreshPeriod);
            if (c == null) {
                log.debug((Object)"...wasn't in the cache");
                c = this.refresh(page);
                if (c == null) {
                    return null;
                }
            } else {
                log.debug((Object)"...FOUND in the cache");
                ++this.m_cacheHits;
            }
            return this.findAttachmentFromCollection(c, name);
        }
        catch (NeedsRefreshException nre) {
            log.debug((Object)"...needs refresh");
            Collection c = null;
            try {
                c = this.refresh(page);
            }
            catch (Exception ex) {
                log.warn((Object)"Provider failed, returning cached content", (Throwable)ex);
                this.m_cache.cancelUpdate(page.getName());
                c = (Collection)nre.getCacheContent();
            }
            if (c != null) {
                return this.findAttachmentFromCollection(c, name);
            }
            return null;
        }
    }

    @Override
    public List getVersionHistory(Attachment att) {
        return this.m_provider.getVersionHistory(att);
    }

    @Override
    public void deleteVersion(Attachment att) throws ProviderException {
        this.m_cache.removeEntry(att.getParentName());
        this.m_provider.deleteVersion(att);
    }

    @Override
    public void deleteAttachment(Attachment att) throws ProviderException {
        this.m_cache.removeEntry(att.getParentName());
        this.m_attCache.removeEntry(att.getName());
        this.m_provider.deleteAttachment(att);
    }

    @Override
    public synchronized String getProviderInfo() {
        return "Real provider: " + this.m_provider.getClass().getName() + ".  Cache misses: " + this.m_cacheMisses + ".  Cache hits: " + this.m_cacheHits;
    }

    public WikiAttachmentProvider getRealProvider() {
        return this.m_provider;
    }

    @Override
    public void moveAttachmentsForPage(String oldParent, String newParent) throws ProviderException {
        this.m_provider.moveAttachmentsForPage(oldParent, newParent);
        this.m_cache.removeEntry(newParent);
        this.m_cache.removeEntry(oldParent);
        String checkName = oldParent + "/";
        Collection names = this.cloneCollection(this.m_allCollector.m_allItems.keySet());
        for (String name : names) {
            if (!name.startsWith(checkName)) continue;
            this.m_attCache.removeEntry(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedAttachmentCollector
    implements CacheEntryEventListener {
        private static final Logger log = Logger.getLogger(CachedAttachmentCollector.class);
        private Map<String, Attachment> m_allItems = new HashMap<String, Attachment>();

        private CachedAttachmentCollector() {
        }

        public List<Attachment> getAllItems() {
            LinkedList<Attachment> ret = new LinkedList<Attachment>();
            ret.addAll(this.m_allItems.values());
            log.info((Object)("returning " + ret.size() + " attachments"));
            return ret;
        }

        public void cacheEntryRemoved(CacheEntryEvent aEvent) {
            if (aEvent != null) {
                Attachment item;
                CacheEntry e;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("attachment cache entry removed: " + aEvent.getKey()));
                }
                if ((e = aEvent.getEntry()) != null && (item = (Attachment)e.getContent()) != null) {
                    this.m_allItems.remove(item.getName());
                }
            }
        }

        public void cacheEntryUpdated(CacheEntryEvent aEvent) {
            Attachment item;
            if (log.isDebugEnabled()) {
                log.debug((Object)("attachment cache entry updated: " + aEvent.getKey()));
            }
            if ((item = (Attachment)aEvent.getEntry().getContent()) != null) {
                this.m_allItems.put(item.getName(), item);
            } else {
                this.m_allItems.remove(aEvent.getKey());
            }
        }

        public void cacheEntryAdded(CacheEntryEvent aEvent) {
            this.cacheEntryUpdated(aEvent);
        }

        public void cachePatternFlushed(CachePatternEvent aEvent) {
        }

        public void cacheGroupFlushed(CacheGroupEvent aEvent) {
        }

        public void cacheFlushed(CachewideEvent aEvent) {
        }

        public void cacheEntryFlushed(CacheEntryEvent aEvent) {
            this.cacheEntryRemoved(aEvent);
        }
    }
}

