/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.checker.Checker;
import com.liferay.portal.security.pacl.checker.FileChecker;
import java.io.FilePermission;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.Security;
import java.security.URIParameter;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;

public abstract class BasePACLPolicy
implements PACLPolicy {
    private static Log _log = LogFactoryUtil.getLog(BasePACLPolicy.class);
    private Map<String, Checker> _checkers = new HashMap<String, Checker>();
    private ClassLoader _classLoader;
    private Policy _policy;
    private Properties _properties;
    private String _servletContextName;
    private List<URL> _urls = new ArrayList<URL>();

    public BasePACLPolicy(String servletContextName, ClassLoader classLoader, Properties properties) {
        this._servletContextName = servletContextName;
        this._classLoader = classLoader;
        this._properties = properties;
        try {
            this.initCheckers();
            this.initPolicy(servletContextName, classLoader);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public Policy getPolicy() {
        return this._policy;
    }

    @Override
    public Properties getProperties() {
        return this._properties;
    }

    @Override
    public String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    @Override
    public String[] getPropertyArray(String key) {
        return StringUtil.split((String)this.getProperty(key));
    }

    @Override
    public boolean getPropertyBoolean(String key) {
        return GetterUtil.getBoolean((String)this.getProperty(key));
    }

    @Override
    public Set<String> getPropertySet(String key) {
        return new TreeSet<String>(SetUtil.fromArray((Object[])this.getPropertyArray(key)));
    }

    @Override
    public String getServletContextName() {
        return this._servletContextName;
    }

    @Override
    public List<URL> getURLs() {
        return this._urls;
    }

    @Override
    public boolean isCheckablePermission(Permission permission) {
        Class<?> clazz = permission.getClass();
        return this._checkers.containsKey(clazz.getName());
    }

    public String toString() {
        StringBundler sb = new StringBundler(7);
        sb.append("{active=");
        sb.append(this.isActive());
        sb.append(", hashCode=");
        sb.append(this.hashCode());
        sb.append(", servletContextName=");
        sb.append(this._servletContextName);
        sb.append("}");
        return sb.toString();
    }

    protected void checkForAllPermission(Policy policy, String rootDir) throws MalformedURLException {
        URL rootURL = new URL("file", null, rootDir);
        ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(rootURL, new Certificate[0]), new Permissions());
        if (policy.implies(protectionDomain, new AllPermission())) {
            throw new IllegalStateException("The plugin's Java policy tried to declared all permissions");
        }
    }

    protected Checker getChecker(Class<? extends Permission> clazz) {
        return this._checkers.get(clazz.getName());
    }

    protected Provider getProvider() {
        String providerName = "SUN";
        if (JavaDetector.isIBM() && JavaDetector.isJDK6()) {
            providerName = "Policy";
        }
        return Security.getProvider(providerName);
    }

    protected Checker initChecker(Checker checker) {
        checker.setPACLPolicy(this);
        checker.afterPropertiesSet();
        return checker;
    }

    protected void initCheckers() throws Exception {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        Properties portalProperties = PropsUtil.getProperties((String)"portal.security.manager.pacl.policy.checker", (boolean)false);
        portalProperties = new SortedProperties(portalProperties);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering " + portalProperties.size() + " PACL policy checkers"));
        }
        for (Map.Entry<Object, Object> entry : portalProperties.entrySet()) {
            String key = (String)entry.getKey();
            int x = key.indexOf("[");
            int y = key.indexOf("]");
            String permissionClassName = key.substring(x + 1, y);
            String checkerClassName = (String)entry.getValue();
            Class<?> checkerClass = classLoader.loadClass(checkerClassName);
            Checker checker = (Checker)checkerClass.newInstance();
            this.initChecker(checker);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Registering permission " + permissionClassName + " with PACL policy " + checkerClassName));
            }
            this._checkers.put(permissionClassName, checker);
        }
    }

    protected void initPolicy(String servletContextName, ClassLoader classLoader) throws Exception {
        ServletContext servletContext = ServletContextPool.get((String)servletContextName);
        if (servletContext == null) {
            return;
        }
        URL url = servletContext.getResource("/WEB-INF/java.policy");
        if (url == null) {
            return;
        }
        FileChecker fileChecker = (FileChecker)this._checkers.get(FilePermission.class.getName());
        if (fileChecker == null) {
            return;
        }
        String rootDir = fileChecker.getRootDir();
        System.setProperty(servletContextName, rootDir);
        try {
            URIParameter parameter = new URIParameter(url.toURI());
            Policy policy = Policy.getInstance("JavaPolicy", (Policy.Parameters)parameter, this.getProvider());
            this.checkForAllPermission(policy, rootDir);
            this._policy = policy;
        }
        catch (Exception e) {
            _log.error((Object)("Unable to initialize Java policy " + url.toString()), (Throwable)e);
        }
    }
}

