/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.bnd.ant.AntMessages;
import aQute.libg.reporter.ReporterAdapter;
import aQute.libg.reporter.ReporterMessages;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTask
extends Task
implements Reporter {
    ReporterAdapter reporter = new ReporterAdapter();
    List<String> errors = new ArrayList<String>();
    List<String> warnings = new ArrayList<String>();
    List<String> progress = new ArrayList<String>();
    boolean pedantic;
    boolean trace;
    String onfail;
    final List<Property> properties = new LinkedList<Property>();
    final List<Property> workspaceProps = new LinkedList<Property>();
    final AntMessages messages = ReporterMessages.base(this, AntMessages.class);
    boolean exceptions;

    protected boolean report() {
        return this.report(this);
    }

    protected boolean report(Reporter reporter) {
        Iterator<String> e;
        if (reporter.getWarnings().size() > 0) {
            System.err.println("Warnings");
            e = reporter.getWarnings().iterator();
            while (e.hasNext()) {
                System.err.println(" " + e.next());
            }
        }
        if (reporter.getErrors().size() > 0) {
            System.err.println(reporter.getErrors().size() + " Errors");
            e = reporter.getErrors().iterator();
            while (e.hasNext()) {
                System.err.println(" " + e.next());
            }
            return true;
        }
        return false;
    }

    public static File getFile(File base, String file) {
        File f = new File(file);
        if (!f.isAbsolute()) {
            int n;
            f = base.getAbsoluteFile();
            while ((n = file.indexOf(47)) > 0) {
                String first = file.substring(0, n);
                file = file.substring(n + 1);
                if (first.equals("..")) {
                    f = f.getParentFile();
                    continue;
                }
                f = new File(f, first);
            }
            f = new File(f, file);
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    protected List<String> split(String dependsOn, String string) {
        if (dependsOn == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(string.split("\\s*" + string + "\\s*"));
    }

    protected String join(Collection<?> classpath, String string) {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (Object name : classpath) {
            sb.append(del);
            sb.append(name);
            del = string;
        }
        return sb.toString();
    }

    @Override
    public boolean isPedantic() {
        return this.pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean isTrace() {
        return this.trace;
    }

    @Override
    public void trace(String s, Object ... args) {
        System.err.printf("# " + s + "%n", args);
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public void addWsproperty(Property property) {
        this.workspaceProps.add(property);
    }

    public boolean isExceptions() {
        return this.exceptions;
    }

    public void setExceptions(boolean exceptions) {
        this.exceptions = exceptions;
    }

    @Override
    public Report.Location getLocation(String msg) {
        return this.reporter.getLocation(msg);
    }

    @Override
    public boolean isOk() {
        return this.reporter.isOk();
    }

    @Override
    public Reporter.SetLocation exception(Throwable t, String format, Object ... args) {
        return this.reporter.exception(t, format, args);
    }

    @Override
    public Reporter.SetLocation error(String s, Object ... args) {
        return this.reporter.error(s, args);
    }

    @Override
    public List<String> getErrors() {
        return this.reporter.getErrors();
    }

    @Override
    public List<String> getWarnings() {
        return this.reporter.getWarnings();
    }

    @Override
    public void progress(float progress, String s, Object ... args) {
        this.reporter.progress(progress, s, args);
    }

    @Override
    public Reporter.SetLocation warning(String s, Object ... args) {
        return this.reporter.warning(s, args);
    }
}

