/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.main;

import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.main.bnd;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Tree;
import aQute.configurable.Config;
import aQute.lib.getopt.Arguments;
import aQute.lib.getopt.Options;
import aQute.lib.tag.Tag;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class DiffCommand {
    bnd bnd;

    DiffCommand(bnd bnd2) {
        this.bnd = bnd2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(diffOptions options) throws Exception {
        if (options._().size() == 1) {
            this.bnd.trace("Show tree", new Object[0]);
            DiffCommand.showTree(this.bnd, options);
            return;
        }
        if (options._().size() != 2) {
            throw new IllegalArgumentException("Requires 2 jar files input");
        }
        File fout = options.output();
        PrintWriter pw = null;
        Jar newer = null;
        Jar older = null;
        try {
            boolean all;
            pw = fout == null ? new PrintWriter(this.bnd.out) : new PrintWriter(fout, "UTF-8");
            Instructions packageFilters = new Instructions(options.pack());
            Iterator<String> it = options._().iterator();
            newer = this.bnd.getJar(it.next());
            if (newer == null) {
                return;
            }
            older = this.bnd.getJar(it.next());
            if (older == null) {
                return;
            }
            DiffPluginImpl di = new DiffPluginImpl();
            Tree n = di.tree(newer);
            Tree o = di.tree(older);
            Diff diff = n.diff(o);
            boolean bl = all = !options.api() && !options.resources() && !options.manifest();
            if (!options.xml()) {
                if (all || options.api()) {
                    for (Diff diff2 : diff.get("<api>").getChildren()) {
                        if (!packageFilters.matches(diff2.getName())) continue;
                        DiffCommand.show(pw, diff2, 0, !options.full());
                    }
                }
                if (all || options.manifest()) {
                    DiffCommand.show(pw, diff.get("<manifest>"), 0, !options.full());
                }
                if (all || options.resources()) {
                    DiffCommand.show(pw, diff.get("<resources>"), 0, !options.full());
                }
            } else {
                Tag tag = new Tag("diff", new Object[0]);
                tag.addAttribute("date", new Date());
                tag.addContent(DiffCommand.getTagFrom("newer", newer));
                tag.addContent(DiffCommand.getTagFrom("older", older));
                if (all || options.api()) {
                    tag.addContent(DiffCommand.getTagFrom(diff.get("<api>"), !options.full()));
                }
                if (all || options.manifest()) {
                    tag.addContent(DiffCommand.getTagFrom(diff.get("<manifest>"), !options.full()));
                }
                if (all || options.resources()) {
                    tag.addContent(DiffCommand.getTagFrom(diff.get("<resources>"), !options.full()));
                }
                pw.println("<?xml version='1.0'?>");
                tag.print(0, pw);
            }
        }
        finally {
            if (older != null) {
                older.close();
            }
            if (newer != null) {
                newer.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showTree(bnd bnd2, diffOptions options) throws Exception {
        File fout = options.output();
        PrintWriter pw = fout == null ? new PrintWriter(bnd2.out) : new PrintWriter(fout, "UTF-8");
        Instructions packageFilters = new Instructions(options.pack());
        Jar newer = new Jar(bnd2.getFile(options._().get(0)));
        try {
            boolean all;
            DiffPluginImpl di = new DiffPluginImpl();
            Tree n = di.tree(newer);
            boolean bl = all = !options.api() && !options.resources() && !options.manifest();
            if (all || options.api()) {
                for (Tree packageDiff : n.get("<api>").getChildren()) {
                    if (!packageFilters.matches(packageDiff.getName())) continue;
                    DiffCommand.show(pw, packageDiff, 0);
                }
            }
            if (all || options.manifest()) {
                DiffCommand.show(pw, n.get("<manifest>"), 0);
            }
            if (all || options.resources()) {
                DiffCommand.show(pw, n.get("<resources>"), 0);
            }
            pw.close();
        }
        finally {
            newer.close();
        }
    }

    private static Tag getTagFrom(Diff diff, boolean limited) {
        if (limited && (diff.getDelta() == Delta.UNCHANGED || diff.getDelta() == Delta.IGNORED)) {
            return null;
        }
        Tag tag = new Tag("diff", new Object[0]);
        tag.addAttribute("name", diff.getName());
        tag.addAttribute("delta", (Object)diff.getDelta());
        tag.addAttribute("type", (Object)diff.getType());
        if (limited && (diff.getDelta() == Delta.ADDED || diff.getDelta() == Delta.REMOVED)) {
            return tag;
        }
        for (Diff diff2 : diff.getChildren()) {
            Tag child = DiffCommand.getTagFrom(diff2, limited);
            if (child == null) continue;
            tag.addContent(child);
        }
        return tag;
    }

    private static Tag getTagFrom(String name, Jar jar) throws Exception {
        Tag tag = new Tag(name, new Object[0]);
        tag.addAttribute("bsn", jar.getBsn());
        tag.addAttribute("name", jar.getName());
        tag.addAttribute("version", jar.getVersion());
        tag.addAttribute("lastmodified", jar.lastModified());
        return tag;
    }

    public static void show(PrintWriter out, Diff diff, int indent, boolean limited) {
        if (limited && (diff.getDelta() == Delta.UNCHANGED || diff.getDelta() == Delta.IGNORED)) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            out.print(" ");
        }
        out.println(diff.toString());
        if (limited && (diff.getDelta() == Delta.ADDED || diff.getDelta() == Delta.REMOVED)) {
            return;
        }
        for (Diff diff2 : diff.getChildren()) {
            DiffCommand.show(out, diff2, indent + 1, limited);
        }
    }

    public static void show(PrintWriter out, Tree tree, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(" ");
        }
        out.println(tree.toString());
        for (Tree c : tree.getChildren()) {
            DiffCommand.show(out, c, indent + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Arguments(arg={"newer file", "[older file]"})
    static interface diffOptions
    extends Options {
        @Config(description="Print the API")
        public boolean api();

        @Config(description="Print the Resources")
        public boolean resources();

        @Config(description="Print the Manifest")
        public boolean manifest();

        @Config(description="Show full tree")
        public boolean full();

        @Config(description="Print difference as valid XML")
        public boolean xml();

        @Config(description="Where to send the output")
        public File output();

        @Config(description="Limit to these packages")
        public Collection<String> pack();
    }
}

