/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.macro.PathMacros;
import jodd.util.ArraysUtil;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionConfigSet
implements Comparable<ActionConfigSet> {
    protected ActionConfig[] configs = new ActionConfig[0];
    public final String actionPath;
    public final int deep;
    public final PathMacros actionPathMacros;

    public ActionConfigSet(String actionPath, PathMacros pathMacros) {
        this.actionPath = actionPath;
        this.deep = StringUtil.count(actionPath, '/');
        this.actionPathMacros = pathMacros;
    }

    public List<ActionConfig> getActionConfigs() {
        ArrayList<ActionConfig> list = new ArrayList<ActionConfig>(this.configs.length);
        Collections.addAll(list, this.configs);
        return list;
    }

    public boolean add(ActionConfig cfg) {
        if (!cfg.actionPath.equals(this.actionPath)) {
            throw new MadvocException("Invalid configuration.");
        }
        cfg.actionConfigSet = this;
        int ndx = this.lookupIndex(cfg.actionMethod);
        if (ndx == -1) {
            this.configs = cfg.actionMethod == null ? ArraysUtil.append(this.configs, cfg) : ArraysUtil.insert(this.configs, cfg, 0);
            return false;
        }
        this.configs[ndx] = cfg;
        return true;
    }

    public ActionConfig lookup(String method) {
        int ndx = this.lookupIndex(method);
        if (ndx == -1) {
            return null;
        }
        return this.configs[ndx];
    }

    protected int lookupIndex(String method) {
        for (int i = 0; i < this.configs.length; ++i) {
            ActionConfig config = this.configs[i];
            if (config.actionMethod == null) {
                return i;
            }
            if (!config.actionMethod.equals(method)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int compareTo(ActionConfigSet set) {
        return this.actionPath.compareTo(set.actionPath);
    }
}

