/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistryUtil;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lar.backgroundtask.DefaultExportImportBackgroundTaskStatusMessageTranslator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.service.BackgroundTaskLocalServiceUtil;
import com.liferay.portal.spring.transaction.TransactionAttributeBuilder;
import java.util.Locale;
import java.util.Map;
import org.springframework.transaction.interceptor.TransactionAttribute;

public abstract class BaseStagingBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor {
    protected TransactionAttribute transactionAttribute = TransactionAttributeBuilder.build(Propagation.REQUIRED, new Class[]{Exception.class}, new Class[0]);

    public BaseStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new DefaultExportImportBackgroundTaskStatusMessageTranslator());
        this.setSerial(true);
    }

    public String handleException(BackgroundTask backgroundTask, Exception e2) {
        JSONObject jsonObject = StagingUtil.getExceptionMessagesJSONObject((Locale)this.getLocale(backgroundTask), (Exception)e2, (Map)backgroundTask.getTaskContextMap());
        return jsonObject.toString();
    }

    protected void clearBackgroundTaskStatus(BackgroundTask backgroundTask) {
        BackgroundTaskStatus backgroundTaskStatus = BackgroundTaskStatusRegistryUtil.getBackgroundTaskStatus((long)backgroundTask.getBackgroundTaskId());
        backgroundTaskStatus.clearAttributes();
    }

    protected BackgroundTask markBackgroundTask(BackgroundTask backgroundTask, String backgroundTaskState) throws SystemException {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        if (Validator.isNull((String)backgroundTaskState)) {
            return backgroundTask;
        }
        taskContextMap.put(backgroundTaskState, Boolean.TRUE);
        backgroundTask.setTaskContext(JSONFactoryUtil.serialize((Object)taskContextMap));
        return BackgroundTaskLocalServiceUtil.updateBackgroundTask((BackgroundTask)backgroundTask);
    }

    protected BackgroundTaskResult processMissingReferences(BackgroundTask backgroundTask, MissingReferences missingReferences) {
        BackgroundTaskResult backgroundTaskResult = new BackgroundTaskResult(3);
        Map weakMissingReferences = missingReferences.getWeakMissingReferences();
        if (weakMissingReferences != null && !weakMissingReferences.isEmpty()) {
            JSONArray jsonArray = StagingUtil.getWarningMessagesJSONArray((Locale)this.getLocale(backgroundTask), (Map)weakMissingReferences, (Map)backgroundTask.getTaskContextMap());
            backgroundTaskResult.setStatusMessage(jsonArray.toString());
        }
        return backgroundTaskResult;
    }
}

