/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.repository.liferayrepository.model.LiferayModel;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class LiferayFileEntry
extends LiferayModel
implements FileEntry {
    private static Log _log = LogFactoryUtil.getLog(LiferayFileEntry.class);
    private DLFileEntry _dlFileEntry;
    private DLFileVersion _dlFileVersion;
    private boolean _escapedModel;

    public LiferayFileEntry(DLFileEntry dlFileEntry) {
        this._dlFileEntry = dlFileEntry;
    }

    public LiferayFileEntry(DLFileEntry fileEntry, boolean escapedModel) {
        this._dlFileEntry = fileEntry;
        this._escapedModel = escapedModel;
    }

    public Object clone() {
        LiferayFileEntry liferayFileEntry = new LiferayFileEntry(this._dlFileEntry, this._escapedModel);
        FileVersion cachedFileVersion = this.getCachedFileVersion();
        if (cachedFileVersion != null) {
            liferayFileEntry.setCachedFileVersion(cachedFileVersion);
        }
        liferayFileEntry.setCompanyId(this.getCompanyId());
        liferayFileEntry.setCreateDate(this.getCreateDate());
        liferayFileEntry.setGroupId(this.getGroupId());
        liferayFileEntry.setModifiedDate(this.getModifiedDate());
        liferayFileEntry.setPrimaryKey(this.getPrimaryKey());
        liferayFileEntry.setUserId(this.getUserId());
        liferayFileEntry.setUserName(this.getUserName());
        try {
            liferayFileEntry.setUserUuid(this.getUserUuid());
        }
        catch (SystemException systemException) {}
        liferayFileEntry.setUuid(this.getUuid());
        return liferayFileEntry;
    }

    public boolean containsPermission(PermissionChecker permissionChecker, String actionId) throws PortalException, SystemException {
        return DLFileEntryPermission.contains(permissionChecker, this._dlFileEntry, actionId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LiferayFileEntry)) {
            return false;
        }
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)obj;
        return Validator.equals((Object)this._dlFileEntry, (Object)liferayFileEntry._dlFileEntry);
    }

    public Map<String, Serializable> getAttributes() {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        return expandoBridge.getAttributes();
    }

    public FileVersion getCachedFileVersion() {
        if (this._dlFileVersion == null) {
            return null;
        }
        return new LiferayFileVersion(this._dlFileVersion);
    }

    @Override
    public long getCompanyId() {
        return this._dlFileEntry.getCompanyId();
    }

    public InputStream getContentStream() throws PortalException, SystemException {
        InputStream inputStream = this._dlFileEntry.getContentStream();
        try {
            DLAppHelperLocalServiceUtil.getFileAsStream((long)PrincipalThreadLocal.getUserId(), (FileEntry)this, (boolean)true);
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        return inputStream;
    }

    public InputStream getContentStream(String version) throws PortalException, SystemException {
        InputStream inputStream = this._dlFileEntry.getContentStream(version);
        try {
            DLAppHelperLocalServiceUtil.getFileAsStream((long)PrincipalThreadLocal.getUserId(), (FileEntry)this, (boolean)true);
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        return inputStream;
    }

    public Date getCreateDate() {
        return this._dlFileEntry.getCreateDate();
    }

    public String getDescription() {
        return this._dlFileEntry.getDescription();
    }

    public DLFileEntry getDLFileEntry() {
        return this._dlFileEntry;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return this._dlFileEntry.getExpandoBridge();
    }

    public String getExtension() {
        return this._dlFileEntry.getExtension();
    }

    public long getFileEntryId() {
        return this._dlFileEntry.getFileEntryId();
    }

    public FileVersion getFileVersion() throws PortalException, SystemException {
        DLFileVersion dlFileVersion = this._dlFileVersion;
        if (dlFileVersion == null) {
            dlFileVersion = this._dlFileEntry.getFileVersion();
        }
        return new LiferayFileVersion(dlFileVersion);
    }

    public FileVersion getFileVersion(String version) throws PortalException, SystemException {
        return new LiferayFileVersion(this._dlFileEntry.getFileVersion(version));
    }

    public List<FileVersion> getFileVersions(int status) throws SystemException {
        return this.toFileVersions(this._dlFileEntry.getFileVersions(status));
    }

    public Folder getFolder() {
        LiferayFolder folder = null;
        try {
            folder = new LiferayFolder(this._dlFileEntry.getFolder());
        }
        catch (Exception exception) {
            return null;
        }
        return folder;
    }

    public long getFolderId() {
        return this._dlFileEntry.getFolderId();
    }

    public long getGroupId() {
        return this._dlFileEntry.getGroupId();
    }

    public String getIcon() {
        return this._dlFileEntry.getIcon();
    }

    public FileVersion getLatestFileVersion() throws PortalException, SystemException {
        return new LiferayFileVersion(this._dlFileEntry.getLatestFileVersion(false));
    }

    public Lock getLock() {
        return this._dlFileEntry.getLock();
    }

    public String getMimeType() {
        return this._dlFileEntry.getMimeType();
    }

    public String getMimeType(String version) {
        try {
            DLFileVersion dlFileVersion = DLFileVersionLocalServiceUtil.getFileVersion((long)this._dlFileEntry.getFileEntryId(), (String)version);
            return dlFileVersion.getMimeType();
        }
        catch (Exception exception) {
            return "application/octet-stream";
        }
    }

    public Object getModel() {
        return this._dlFileEntry;
    }

    public Class<?> getModelClass() {
        return LiferayFileEntry.class;
    }

    @Override
    public String getModelClassName() {
        return LiferayFileEntry.class.getName();
    }

    public Date getModifiedDate() {
        return this._dlFileEntry.getModifiedDate();
    }

    @Override
    public long getPrimaryKey() {
        return this._dlFileEntry.getPrimaryKey();
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public int getReadCount() {
        return this._dlFileEntry.getReadCount();
    }

    public long getRepositoryId() {
        return this._dlFileEntry.getRepositoryId();
    }

    public long getSize() {
        return this._dlFileEntry.getSize();
    }

    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFileEntryConstants.getClassName());
    }

    public String getTitle() {
        return this._dlFileEntry.getTitle();
    }

    public long getUserId() {
        return this._dlFileEntry.getUserId();
    }

    public String getUserName() {
        return this._dlFileEntry.getUserName();
    }

    public String getUserUuid() throws SystemException {
        return this._dlFileEntry.getUserUuid();
    }

    public String getUuid() {
        return this._dlFileEntry.getUuid();
    }

    public String getVersion() {
        return this._dlFileEntry.getVersion();
    }

    public long getVersionUserId() {
        long versionUserId = 0L;
        try {
            DLFileVersion dlFileVersion = this._dlFileEntry.getFileVersion();
            versionUserId = dlFileVersion.getUserId();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return versionUserId;
    }

    public String getVersionUserName() {
        String versionUserName = "";
        try {
            DLFileVersion dlFileVersion = this._dlFileEntry.getFileVersion();
            versionUserName = dlFileVersion.getUserName();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return versionUserName;
    }

    public String getVersionUserUuid() {
        String versionUserUuid = "";
        try {
            DLFileVersion dlFileVersion = this._dlFileEntry.getFileVersion();
            versionUserUuid = dlFileVersion.getUserUuid();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return versionUserUuid;
    }

    public int hashCode() {
        return this._dlFileEntry.hashCode();
    }

    public boolean hasLock() {
        return this._dlFileEntry.hasLock();
    }

    public boolean isCheckedOut() {
        return this._dlFileEntry.isCheckedOut();
    }

    public boolean isDefaultRepository() {
        return this._dlFileEntry.getGroupId() == this._dlFileEntry.getRepositoryId();
    }

    public boolean isEscapedModel() {
        return this._escapedModel;
    }

    public boolean isInTrash() {
        return this._dlFileEntry.isInTrash();
    }

    public boolean isInTrashContainer() {
        try {
            return this._dlFileEntry.isInTrashContainer();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isManualCheckInRequired() {
        return this._dlFileEntry.isManualCheckInRequired();
    }

    public boolean isSupportsLocking() {
        return true;
    }

    public boolean isSupportsMetadata() {
        return true;
    }

    public boolean isSupportsSocial() {
        return true;
    }

    public void setCachedFileVersion(FileVersion fileVersion) {
        this._dlFileVersion = (DLFileVersion)fileVersion.getModel();
    }

    public void setCompanyId(long companyId) {
        this._dlFileEntry.setCompanyId(companyId);
    }

    public void setCreateDate(Date date) {
        this._dlFileEntry.setCreateDate(date);
    }

    public void setGroupId(long groupId) {
        this._dlFileEntry.setGroupId(groupId);
    }

    public void setModifiedDate(Date date) {
        this._dlFileEntry.setModifiedDate(date);
    }

    public void setPrimaryKey(long primaryKey) {
        this._dlFileEntry.setPrimaryKey(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public void setUserId(long userId) {
        this._dlFileEntry.setUserId(userId);
    }

    public void setUserName(String userName) {
        this._dlFileEntry.setUserName(userName);
    }

    public void setUserUuid(String userUuid) {
        this._dlFileEntry.setUserUuid(userUuid);
    }

    public void setUuid(String uuid) {
        this._dlFileEntry.setUuid(uuid);
    }

    public FileEntry toEscapedModel() {
        if (this.isEscapedModel()) {
            return this;
        }
        return new LiferayFileEntry(this._dlFileEntry.toEscapedModel(), true);
    }

    public String toString() {
        return this._dlFileEntry.toString();
    }

    public FileEntry toUnescapedModel() {
        if (this.isEscapedModel()) {
            return new LiferayFileEntry(this._dlFileEntry.toUnescapedModel(), true);
        }
        return this;
    }
}

