/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.gzip;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.gzip.GZipResponse;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GZipFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = String.valueOf(GZipFilter.class.getName()) + "SKIP_FILTER";
    private static final String _COMPRESS = "compress";
    private static Log _log = LogFactoryUtil.getLog(GZipFilter.class);
    private boolean _filterEnabled;

    public GZipFilter() {
        if (super.isFilterEnabled()) {
            this._filterEnabled = ServerDetector.isJBoss() || ServerDetector.isJetty() || ServerDetector.isJOnAS() || ServerDetector.isOC4J() || ServerDetector.isTomcat();
        }
    }

    @Override
    public boolean isFilterEnabled() {
        return this._filterEnabled;
    }

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return this.isCompress(request) && !this.isInclude(request) && BrowserSnifferUtil.acceptsGzip((HttpServletRequest)request) && !this.isAlreadyFiltered(request);
    }

    protected boolean isAlreadyFiltered(HttpServletRequest request) {
        return request.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isCompress(HttpServletRequest request) {
        return ParamUtil.getBoolean((HttpServletRequest)request, (String)_COMPRESS, (boolean)true);
    }

    protected boolean isInclude(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        return uri != null;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        if (_log.isDebugEnabled()) {
            String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
            _log.debug((Object)("Compressing " + completeURL));
        }
        request.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        GZipResponse gZipResponse = new GZipResponse(request, response);
        this.processFilter(GZipFilter.class, request, (HttpServletResponse)gZipResponse, filterChain);
        gZipResponse.finishResponse(true);
    }
}

