/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webcache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePool;
import java.io.Serializable;

@DoPrivileged
public class WebCachePoolImpl
implements WebCachePool {
    private static final String _CACHE_NAME = WebCachePool.class.getName();
    private static Log _log = LogFactoryUtil.getLog(WebCachePoolImpl.class);
    private PortalCache<String, Object> _portalCache;
    private SingleVMPool _singleVMPool;

    public void afterPropertiesSet() {
        this._portalCache = this._singleVMPool.getCache(_CACHE_NAME);
    }

    public void clear() {
        this._portalCache.removeAll();
    }

    public Object get(String key, WebCacheItem wci) {
        Object obj;
        block4: {
            obj = this._portalCache.get((Serializable)((Object)key));
            if (obj != null) {
                return obj;
            }
            try {
                obj = wci.convert(key);
                int timeToLive = (int)(wci.getRefreshTime() / 1000L);
                this._portalCache.put((Serializable)((Object)key), obj, timeToLive);
            }
            catch (WebCacheException wce) {
                if (!_log.isWarnEnabled()) break block4;
                Throwable cause = wce.getCause();
                if (cause != null) {
                    _log.warn((Object)cause, cause);
                }
                _log.warn((Object)wce, (Throwable)wce);
            }
        }
        return obj;
    }

    public void remove(String key) {
        this._portalCache.remove((Serializable)((Object)key));
    }

    public void setSingleVMPool(SingleVMPool singleVMPool) {
        this._singleVMPool = singleVMPool;
    }
}

