/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.RestrictPortletServletRequest;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import java.util.Map;
import javax.portlet.Event;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RestrictPortletContainerWrapper
implements PortletContainer {
    private PortletContainer _portletContainer;

    public static PortletContainer createRestrictPortletContainerWrapper(PortletContainer portletContainer) {
        if (PropsValues.LAYOUT_PARALLEL_RENDER_ENABLE && ServerDetector.isTomcat() || PropsValues.PORTLET_CONTAINER_RESTRICT) {
            portletContainer = new RestrictPortletContainerWrapper(portletContainer);
        }
        return portletContainer;
    }

    public RestrictPortletContainerWrapper(PortletContainer portletContainer) {
        this._portletContainer = portletContainer;
    }

    public void preparePortlet(HttpServletRequest request, Portlet portlet) throws PortletContainerException {
        this._portletContainer.preparePortlet(request, portlet);
    }

    public ActionResult processAction(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        RestrictPortletServletRequest restrictPortletServletRequest = new RestrictPortletServletRequest(request);
        try {
            ActionResult actionResult = this._portletContainer.processAction(request, response, portlet);
            return actionResult;
        }
        finally {
            restrictPortletServletRequest.mergeSharedAttributes();
        }
    }

    public List<Event> processEvent(HttpServletRequest request, HttpServletResponse response, Portlet portlet, Layout layout, Event event) throws PortletContainerException {
        RestrictPortletServletRequest restrictPortletServletRequest = new RestrictPortletServletRequest(request);
        try {
            List list = this._portletContainer.processEvent(request, response, portlet, layout, event);
            return list;
        }
        finally {
            restrictPortletServletRequest.mergeSharedAttributes();
        }
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        RestrictPortletServletRequest restrictPortletServletRequest = null;
        if (request instanceof RestrictPortletServletRequest) {
            restrictPortletServletRequest = (RestrictPortletServletRequest)request;
            Map attributes = restrictPortletServletRequest.getAttributes();
            if (attributes.containsKey("RENDER_PORTLET")) {
                restrictPortletServletRequest = new RestrictPortletServletRequest(request);
            }
        } else {
            restrictPortletServletRequest = new RestrictPortletServletRequest(request);
        }
        try {
            try {
                this._portletContainer.render(request, response, portlet);
            }
            catch (Exception e2) {
                throw new PortletContainerException((Throwable)e2);
            }
        }
        finally {
            restrictPortletServletRequest.removeAttribute("RENDER_PATH");
            restrictPortletServletRequest.removeAttribute("RENDER_PORTLET_COLUMN_COUNT");
            restrictPortletServletRequest.removeAttribute("RENDER_PORTLET_COLUMN_ID");
            restrictPortletServletRequest.removeAttribute("RENDER_PORTLET_COLUMN_POS");
            Object lock = request.getAttribute("PARALLEL_RENDERING_MERGE_LOCK");
            if (lock == null) {
                restrictPortletServletRequest.mergeSharedAttributes();
            }
        }
    }

    public void serveResource(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        RestrictPortletServletRequest restrictPortletServletRequest = new RestrictPortletServletRequest(request);
        try {
            try {
                this._portletContainer.serveResource(request, response, portlet);
            }
            catch (Exception e2) {
                throw new PortletContainerException((Throwable)e2);
            }
        }
        finally {
            restrictPortletServletRequest.mergeSharedAttributes();
        }
    }
}

