/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetServiceUtil;
import com.liferay.portlet.dynamicdatalists.util.BaseDDLExporter;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDLCSVExporter
extends BaseDDLExporter {
    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator orderByComparator) throws Exception {
        DDLRecordSet recordSet = DDLRecordSetServiceUtil.getRecordSet((long)recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Map fieldsMap = ddmStructure.getFieldsMap(LocaleUtil.toLanguageId((Locale)this.getLocale()));
        StringBundler sb = new StringBundler();
        for (Map fieldMap : fieldsMap.values()) {
            String name = (String)fieldMap.get("name");
            if (ddmStructure.isFieldPrivate(name)) continue;
            String label = (String)fieldMap.get("label");
            sb.append(label);
            sb.append(',');
        }
        sb.append(LanguageUtil.get((Locale)this.getLocale(), (String)"status"));
        sb.append("\n");
        List records = DDLRecordLocalServiceUtil.getRecords((long)recordSetId, (int)status, (int)start, (int)end, (OrderByComparator)orderByComparator);
        for (DDLRecord record : records) {
            DDLRecordVersion recordVersion = record.getRecordVersion();
            Fields fields = StorageEngineUtil.getFields((long)recordVersion.getDDMStorageId());
            for (Map fieldMap : fieldsMap.values()) {
                String name = (String)fieldMap.get("name");
                String value = "";
                if (fields.contains(name)) {
                    Field field = fields.get(name);
                    if (field.isPrivate()) continue;
                    value = field.getRenderedValue(this.getLocale());
                }
                sb.append(CSVUtil.encode((String)value));
                sb.append(',');
            }
            sb.append(this.getStatusMessage(recordVersion.getStatus()));
            sb.append("\n");
        }
        String csv = sb.toString();
        return csv.getBytes();
    }
}

