/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.lar;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.mobile.device.rulegroup.action.impl.SiteRedirectActionHandler;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.mobiledevicerules.model.MDRAction;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import com.liferay.portlet.mobiledevicerules.service.MDRActionLocalServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceLocalServiceUtil;
import java.util.Map;

public class MDRActionStagedModelDataHandler
extends BaseStagedModelDataHandler<MDRAction> {
    public static final String[] CLASS_NAMES = new String[]{MDRAction.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(MDRActionStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws SystemException {
        MDRAction action = MDRActionLocalServiceUtil.fetchMDRActionByUuidAndGroupId((String)uuid, (long)groupId);
        if (action != null) {
            MDRActionLocalServiceUtil.deleteAction((MDRAction)action);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MDRAction action) {
        return action.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MDRAction action) throws Exception {
        Element actionElement;
        block3: {
            MDRRuleGroupInstance ruleGroupInstance = MDRRuleGroupInstanceLocalServiceUtil.getRuleGroupInstance((long)action.getRuleGroupInstanceId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)action, (StagedModel)ruleGroupInstance, (String)"parent");
            actionElement = portletDataContext.getExportDataElement((ClassedModel)action);
            String type = action.getType();
            if (type.equals(SiteRedirectActionHandler.class.getName())) {
                UnicodeProperties typeSettingsProperties = action.getTypeSettingsProperties();
                long plid = GetterUtil.getLong((String)typeSettingsProperties.getProperty("plid"));
                try {
                    Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                    actionElement.addAttribute("layout-uuid", layout.getUuid());
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to set the layout uuid of layout " + plid + ". Site redirect may not match after import."), (Throwable)e2);
                }
            }
        }
        portletDataContext.addClassedModel(actionElement, ExportImportPathUtil.getModelPath((StagedModel)action), (ClassedModel)action);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MDRAction action) throws Exception {
        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)action, MDRRuleGroupInstance.class, (long)action.getRuleGroupInstanceId());
        Map ruleGroupInstanceIds = portletDataContext.getNewPrimaryKeysMap(MDRRuleGroupInstance.class);
        long ruleGroupInstanceId = MapUtil.getLong((Map)ruleGroupInstanceIds, (long)action.getRuleGroupInstanceId(), (long)action.getRuleGroupInstanceId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)action);
        serviceContext.setUserId(portletDataContext.getUserId(action.getUserUuid()));
        Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)action);
        this.validateLayout(element, action);
        MDRAction importedAction = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MDRAction existingAction = MDRActionLocalServiceUtil.fetchMDRActionByUuidAndGroupId((String)action.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingAction == null) {
                serviceContext.setUuid(action.getUuid());
                importedAction = MDRActionLocalServiceUtil.addAction((long)ruleGroupInstanceId, (Map)action.getNameMap(), (Map)action.getDescriptionMap(), (String)action.getType(), (UnicodeProperties)action.getTypeSettingsProperties(), (ServiceContext)serviceContext);
            } else {
                importedAction = MDRActionLocalServiceUtil.updateAction((long)existingAction.getActionId(), (Map)action.getNameMap(), (Map)action.getDescriptionMap(), (String)action.getType(), (UnicodeProperties)action.getTypeSettingsProperties(), (ServiceContext)serviceContext);
            }
        } else {
            importedAction = MDRActionLocalServiceUtil.addAction((long)ruleGroupInstanceId, (Map)action.getNameMap(), (Map)action.getDescriptionMap(), (String)action.getType(), (UnicodeProperties)action.getTypeSettingsProperties(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)action, (ClassedModel)importedAction);
    }

    protected void validateLayout(Element actionElement, MDRAction action) {
        block4: {
            String type = action.getType();
            if (!type.equals(SiteRedirectActionHandler.class.getName())) {
                return;
            }
            String layoutUuid = actionElement.attributeValue("layout-uuid");
            if (Validator.isNull((String)layoutUuid)) {
                return;
            }
            UnicodeProperties typeSettingsProperties = action.getTypeSettingsProperties();
            long groupId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("groupId"));
            boolean privateLayout = GetterUtil.getBoolean((String)actionElement.attributeValue("private-layout"));
            try {
                Layout layout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)layoutUuid, (long)groupId, (boolean)privateLayout);
                typeSettingsProperties.setProperty("plid", String.valueOf(layout.getPlid()));
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block4;
                StringBundler sb = new StringBundler(5);
                sb.append("Unable to find layout with uuid ");
                sb.append(layoutUuid);
                sb.append(" in group ");
                sb.append(groupId);
                sb.append(". Site redirect may not match the target layout.");
                _log.warn((Object)sb.toString(), (Throwable)e2);
            }
        }
    }
}

