/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rolesadmin.action;

import com.liferay.portal.DuplicateRoleException;
import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.RequiredRoleException;
import com.liferay.portal.RoleNameException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.RoleServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.rolesadmin.action.ActionUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditRoleAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            Role role = null;
            if (cmd.equals("add") || cmd.equals("update")) {
                role = this.updateRole(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteRole(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (role != null) {
                redirect = HttpUtil.setParameter((String)redirect, (String)(String.valueOf(actionResponse.getNamespace()) + "roleId"), (long)role.getRoleId());
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.roles_admin.error");
            }
            if (e2 instanceof DuplicateRoleException || e2 instanceof NoSuchRoleException || e2 instanceof RequiredRoleException || e2 instanceof RoleNameException) {
                String redirect;
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                if (cmd.equals("delete") && Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                    actionResponse.sendRedirect(redirect);
                }
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getRole((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchRoleException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.roles_admin.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.roles_admin.edit_role"));
    }

    protected void deleteRole(ActionRequest actionRequest) throws Exception {
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        RoleServiceUtil.deleteRole((long)roleId);
    }

    protected Role updateRole(ActionRequest actionRequest) throws Exception {
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type", (int)1);
        String subtype = ParamUtil.getString((PortletRequest)actionRequest, (String)"subtype");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Role.class.getName(), (PortletRequest)actionRequest);
        if (roleId <= 0L) {
            return RoleServiceUtil.addRole(null, (long)0L, (String)name, (Map)titleMap, (Map)descriptionMap, (int)type, (String)subtype, (ServiceContext)serviceContext);
        }
        return RoleServiceUtil.updateRole((long)roleId, (String)name, (Map)titleMap, (Map)descriptionMap, (String)subtype, (ServiceContext)serviceContext);
    }
}

