/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.shopping.CategoryNameException;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.service.base.ShoppingCategoryLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class ShoppingCategoryLocalServiceImpl
extends ShoppingCategoryLocalServiceBaseImpl {
    public ShoppingCategory addCategory(long userId, long parentCategoryId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentCategoryId = this.getParentCategoryId(groupId, parentCategoryId);
        Date now = new Date();
        this.validate(name);
        long categoryId = this.counterLocalService.increment();
        ShoppingCategory category = this.shoppingCategoryPersistence.create(categoryId);
        category.setGroupId(groupId);
        category.setCompanyId(user.getCompanyId());
        category.setUserId(user.getUserId());
        category.setUserName(user.getFullName());
        category.setCreateDate(now);
        category.setModifiedDate(now);
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        this.shoppingCategoryPersistence.update((BaseModel)category);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addCategoryResources(category, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addCategoryResources(category, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return category;
    }

    public void addCategoryResources(long categoryId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        ShoppingCategory category = this.shoppingCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(long categoryId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        ShoppingCategory category = this.shoppingCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, groupPermissions, guestPermissions);
    }

    public void addCategoryResources(ShoppingCategory category, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), ShoppingCategory.class.getName(), category.getCategoryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(ShoppingCategory category, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), ShoppingCategory.class.getName(), category.getCategoryId(), groupPermissions, guestPermissions);
    }

    public void deleteCategories(long groupId) throws PortalException, SystemException {
        List categories = this.shoppingCategoryPersistence.findByGroupId(groupId);
        for (ShoppingCategory category : categories) {
            this.deleteCategory(category);
        }
    }

    public void deleteCategory(long categoryId) throws PortalException, SystemException {
        ShoppingCategory category = this.shoppingCategoryPersistence.findByPrimaryKey(categoryId);
        this.deleteCategory(category);
    }

    public void deleteCategory(ShoppingCategory category) throws PortalException, SystemException {
        List categories = this.shoppingCategoryPersistence.findByG_P(category.getGroupId(), category.getCategoryId());
        for (ShoppingCategory curCategory : categories) {
            this.deleteCategory(curCategory);
        }
        this.shoppingCategoryPersistence.remove((BaseModel)category);
        this.resourceLocalService.deleteResource(category.getCompanyId(), ShoppingCategory.class.getName(), 4, category.getCategoryId());
        this.shoppingItemLocalService.deleteItems(category.getGroupId(), category.getCategoryId());
    }

    public List<ShoppingCategory> getCategories(long groupId) throws SystemException {
        return this.shoppingCategoryPersistence.findByGroupId(groupId);
    }

    public List<ShoppingCategory> getCategories(long groupId, long parentCategoryId, int start, int end) throws SystemException {
        return this.shoppingCategoryPersistence.findByG_P(groupId, parentCategoryId, start, end);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId) throws SystemException {
        return this.shoppingCategoryPersistence.countByG_P(groupId, parentCategoryId);
    }

    public ShoppingCategory getCategory(long categoryId) throws PortalException, SystemException {
        return this.shoppingCategoryPersistence.findByPrimaryKey(categoryId);
    }

    public ShoppingCategory getCategory(long groupId, String categoryName) throws SystemException {
        return this.shoppingCategoryPersistence.fetchByG_N(groupId, categoryName);
    }

    public List<ShoppingCategory> getParentCategories(long categoryId) throws PortalException, SystemException {
        return this.getParentCategories(this.shoppingCategoryPersistence.findByPrimaryKey(categoryId));
    }

    public List<ShoppingCategory> getParentCategories(ShoppingCategory category) throws PortalException, SystemException {
        ArrayList<ShoppingCategory> parentCategories = new ArrayList<ShoppingCategory>();
        ShoppingCategory tempCategory = category;
        while (true) {
            parentCategories.add(tempCategory);
            if (tempCategory.getParentCategoryId() == 0L) break;
            tempCategory = this.shoppingCategoryPersistence.findByPrimaryKey(tempCategory.getParentCategoryId());
        }
        Collections.reverse(parentCategories);
        return parentCategories;
    }

    public ShoppingCategory getParentCategory(ShoppingCategory category) throws PortalException, SystemException {
        ShoppingCategory parentCategory = this.shoppingCategoryPersistence.findByPrimaryKey(category.getParentCategoryId());
        return parentCategory;
    }

    public void getSubcategoryIds(List<Long> categoryIds, long groupId, long categoryId) throws SystemException {
        List categories = this.shoppingCategoryPersistence.findByG_P(groupId, categoryId);
        for (ShoppingCategory category : categories) {
            categoryIds.add(category.getCategoryId());
            this.getSubcategoryIds(categoryIds, category.getGroupId(), category.getCategoryId());
        }
    }

    public ShoppingCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException, SystemException {
        ShoppingCategory category = this.shoppingCategoryPersistence.findByPrimaryKey(categoryId);
        parentCategoryId = this.getParentCategoryId(category, parentCategoryId);
        if (mergeWithParentCategory && categoryId != parentCategoryId && parentCategoryId != 0L) {
            this.mergeCategories(category, parentCategoryId);
            return category;
        }
        this.validate(name);
        category.setModifiedDate(new Date());
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        this.shoppingCategoryPersistence.update((BaseModel)category);
        return category;
    }

    protected long getParentCategoryId(long groupId, long parentCategoryId) throws SystemException {
        ShoppingCategory parentCategory;
        if (parentCategoryId != 0L && ((parentCategory = this.shoppingCategoryPersistence.fetchByPrimaryKey(parentCategoryId)) == null || groupId != parentCategory.getGroupId())) {
            parentCategoryId = 0L;
        }
        return parentCategoryId;
    }

    protected long getParentCategoryId(ShoppingCategory category, long parentCategoryId) throws SystemException {
        if (parentCategoryId == 0L) {
            return parentCategoryId;
        }
        if (category.getCategoryId() == parentCategoryId) {
            return category.getParentCategoryId();
        }
        ShoppingCategory parentCategory = this.shoppingCategoryPersistence.fetchByPrimaryKey(parentCategoryId);
        if (parentCategory == null || category.getGroupId() != parentCategory.getGroupId()) {
            return category.getParentCategoryId();
        }
        ArrayList<Long> subcategoryIds = new ArrayList<Long>();
        this.getSubcategoryIds(subcategoryIds, category.getGroupId(), category.getCategoryId());
        if (subcategoryIds.contains(parentCategoryId)) {
            return category.getParentCategoryId();
        }
        return parentCategoryId;
    }

    protected void mergeCategories(ShoppingCategory fromCategory, long toCategoryId) throws PortalException, SystemException {
        List categories = this.shoppingCategoryPersistence.findByG_P(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (ShoppingCategory category : categories) {
            this.mergeCategories(category, toCategoryId);
        }
        List items = this.shoppingItemPersistence.findByG_C(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (ShoppingItem item : items) {
            item.setCategoryId(toCategoryId);
            this.shoppingItemPersistence.update((BaseModel)item);
        }
        this.deleteCategory(fromCategory);
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name) || name.contains("\\\\") || name.contains("//")) {
            throw new CategoryNameException();
        }
    }
}

