/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion;
import com.liferay.portlet.softwarecatalog.service.SCFrameworkVersionLocalServiceUtil;

public class SCFrameworkVersionPermission {
    public static void check(PermissionChecker permissionChecker, long frameworkVersionId, String actionId) throws PortalException, SystemException {
        if (!SCFrameworkVersionPermission.contains(permissionChecker, frameworkVersionId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, SCFrameworkVersion frameworkVersion, String actionId) throws PortalException {
        if (!SCFrameworkVersionPermission.contains(permissionChecker, frameworkVersion, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long frameworkVersionId, String actionId) throws PortalException, SystemException {
        SCFrameworkVersion frameworkVersion = SCFrameworkVersionLocalServiceUtil.getFrameworkVersion((long)frameworkVersionId);
        return SCFrameworkVersionPermission.contains(permissionChecker, frameworkVersion, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, SCFrameworkVersion frameworkVersion, String actionId) {
        if (permissionChecker.hasOwnerPermission(frameworkVersion.getCompanyId(), SCFrameworkVersion.class.getName(), frameworkVersion.getFrameworkVersionId(), frameworkVersion.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(frameworkVersion.getGroupId(), SCFrameworkVersion.class.getName(), frameworkVersion.getFrameworkVersionId(), actionId);
    }
}

