/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.RuntimeFacetHandler;
import com.browseengine.bobo.facets.RuntimeFacetHandlerFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.ReaderUtil;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class BoboIndexReader
extends FilterIndexReader {
    private static final String SPRING_CONFIG = "bobo.spring";
    private static Logger logger = Logger.getLogger(BoboIndexReader.class);
    protected Map<String, FacetHandler<?>> _facetHandlerMap;
    protected Collection<FacetHandler<?>> _facetHandlers;
    protected Collection<RuntimeFacetHandlerFactory<?, ?>> _runtimeFacetHandlerFactories;
    protected Map<String, RuntimeFacetHandlerFactory<?, ?>> _runtimeFacetHandlerFactoryMap;
    protected WorkArea _workArea;
    protected IndexReader _srcReader;
    protected BoboIndexReader[] _subReaders = null;
    protected int[] _starts = null;
    private Directory _dir = null;
    private final Map<String, Object> _facetDataMap = new HashMap<String, Object>();
    private final ThreadLocal<Map<String, Object>> _runtimeFacetDataMap = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private final ThreadLocal<Map<String, RuntimeFacetHandler<?>>> _runtimeFacetHandlerMap = new ThreadLocal<Map<String, RuntimeFacetHandler<?>>>(){

        @Override
        protected Map<String, RuntimeFacetHandler<?>> initialValue() {
            return new HashMap();
        }
    };

    public static BoboIndexReader getInstance(IndexReader reader) throws IOException {
        return BoboIndexReader.getInstance(reader, null, null, new WorkArea());
    }

    public static BoboIndexReader getInstance(IndexReader reader, WorkArea workArea) throws IOException {
        return BoboIndexReader.getInstance(reader, null, null, workArea);
    }

    public static BoboIndexReader getInstance(IndexReader reader, Collection<FacetHandler<?>> facetHandlers, Collection<RuntimeFacetHandlerFactory<?, ?>> facetHandlerFactories) throws IOException {
        return BoboIndexReader.getInstance(reader, facetHandlers, facetHandlerFactories, new WorkArea());
    }

    public static BoboIndexReader getInstance(IndexReader reader, Collection<FacetHandler<?>> facetHandlers) throws IOException {
        return BoboIndexReader.getInstance(reader, facetHandlers, Collections.EMPTY_LIST, new WorkArea());
    }

    public static BoboIndexReader getInstance(IndexReader reader, Collection<FacetHandler<?>> facetHandlers, Collection<RuntimeFacetHandlerFactory<?, ?>> facetHandlerFactories, WorkArea workArea) throws IOException {
        BoboIndexReader boboReader = new BoboIndexReader(reader, facetHandlers, facetHandlerFactories, workArea);
        boboReader.facetInit();
        return boboReader;
    }

    public static BoboIndexReader getInstanceAsSubReader(IndexReader reader) throws IOException {
        return BoboIndexReader.getInstanceAsSubReader(reader, null, null, new WorkArea());
    }

    public static BoboIndexReader getInstanceAsSubReader(IndexReader reader, Collection<FacetHandler<?>> facetHandlers, Collection<RuntimeFacetHandlerFactory<?, ?>> facetHandlerFactories) throws IOException {
        return BoboIndexReader.getInstanceAsSubReader(reader, facetHandlers, facetHandlerFactories, new WorkArea());
    }

    public static BoboIndexReader getInstanceAsSubReader(IndexReader reader, Collection<FacetHandler<?>> facetHandlers, Collection<RuntimeFacetHandlerFactory<?, ?>> facetHandlerFactories, WorkArea workArea) throws IOException {
        BoboIndexReader boboReader = new BoboIndexReader(reader, facetHandlers, facetHandlerFactories, workArea, false);
        boboReader.facetInit();
        return boboReader;
    }

    public long getVersion() {
        try {
            SegmentInfos sinfos = new SegmentInfos();
            sinfos.read(this._dir);
            return sinfos.getVersion();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public IndexReader getInnerReader() {
        return this.in;
    }

    public synchronized IndexReader reopen() throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException();
    }

    public synchronized IndexReader reopen(boolean openReadOnly) throws CorruptIndexException, IOException {
        return this.reopen();
    }

    public Object getFacetData(String name) {
        return this._facetDataMap.get(name);
    }

    public Object putFacetData(String name, Object data) {
        return this._facetDataMap.put(name, data);
    }

    public Object getRuntimeFacetData(String name) {
        Map<String, Object> map = this._runtimeFacetDataMap.get();
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public Object putRuntimeFacetData(String name, Object data) {
        Map<String, Object> map = this._runtimeFacetDataMap.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            this._runtimeFacetDataMap.set(map);
        }
        return map.put(name, data);
    }

    public void clearRuntimeFacetData() {
        this._runtimeFacetDataMap.set(null);
    }

    public RuntimeFacetHandler<?> getRuntimeFacetHandler(String name) {
        Map<String, RuntimeFacetHandler<?>> map = this._runtimeFacetHandlerMap.get();
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public void putRuntimeFacetHandler(String name, RuntimeFacetHandler<?> data) {
        Map<String, RuntimeFacetHandler<?>> map = this._runtimeFacetHandlerMap.get();
        if (map == null) {
            map = new HashMap();
            this._runtimeFacetHandlerMap.set(map);
        }
        map.put(name, data);
    }

    public void clearRuntimeFacetHandler() {
        this._runtimeFacetHandlerMap.set(null);
    }

    protected void doClose() throws IOException {
    }

    protected void doCommit(Map commitUserData) throws IOException {
        if (this._srcReader != null) {
            this._srcReader.flush(commitUserData);
        }
    }

    protected void doDelete(int n) throws CorruptIndexException, IOException {
        if (this._srcReader != null) {
            this._srcReader.deleteDocument(n);
        }
    }

    private void loadFacetHandler(String name, Set<String> loaded, Set<String> visited, WorkArea workArea) throws IOException {
        FacetHandler<?> facetHandler = this._facetHandlerMap.get(name);
        if (facetHandler != null && !loaded.contains(name)) {
            visited.add(name);
            Set<String> dependsOn = facetHandler.getDependsOn();
            if (dependsOn.size() > 0) {
                for (String f : dependsOn) {
                    if (name.equals(f)) continue;
                    if (!loaded.contains(f)) {
                        if (visited.contains(f)) {
                            throw new IOException("Facet handler dependency cycle detected, facet handler: " + name + " not loaded");
                        }
                        this.loadFacetHandler(f, loaded, visited, workArea);
                    }
                    if (!loaded.contains(f)) {
                        throw new IOException("unable to load facet handler: " + f);
                    }
                    facetHandler.putDependedFacetHandler(this._facetHandlerMap.get(f));
                }
            }
            long start = System.currentTimeMillis();
            facetHandler.loadFacetData(this, workArea);
            long end = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("facetHandler loaded: ").append(name).append(", took: ").append(end - start).append(" ms");
                logger.debug((Object)buf.toString());
            }
            loaded.add(name);
        }
    }

    private void loadFacetHandlers(WorkArea workArea, Set<String> toBeRemoved) throws IOException {
        HashSet<String> loaded = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        for (String name : this._facetHandlerMap.keySet()) {
            this.loadFacetHandler(name, loaded, visited, workArea);
        }
        for (String name : toBeRemoved) {
            this._facetHandlerMap.remove(name);
        }
    }

    private static IndexReader[] createSubReaders(IndexReader reader, WorkArea workArea) throws IOException {
        BoboIndexReader[] boboReaders;
        ArrayList readerList = new ArrayList();
        ReaderUtil.gatherSubReaders(readerList, (IndexReader)reader);
        IndexReader[] subReaders = readerList.toArray(new IndexReader[readerList.size()]);
        if (subReaders != null && subReaders.length > 0) {
            boboReaders = new BoboIndexReader[subReaders.length];
            for (int i = 0; i < subReaders.length; ++i) {
                boboReaders[i] = new BoboIndexReader(subReaders[i], null, null, workArea, false);
            }
        } else {
            boboReaders = new BoboIndexReader[]{new BoboIndexReader(reader, null, null, workArea, false)};
        }
        return boboReaders;
    }

    public Directory directory() {
        return this._subReaders != null ? this._subReaders[0].directory() : super.directory();
    }

    private static Collection<FacetHandler<?>> loadFromIndex(File file, WorkArea workArea) throws IOException {
        Set<Map.Entry<Class<?>, Object>> entries = workArea.map.entrySet();
        FileSystemXmlApplicationContext appCtx = new FileSystemXmlApplicationContext();
        for (Map.Entry<Class<?>, Object> entry : entries) {
            Object obj = entry.getValue();
            if (!(obj instanceof ClassLoader)) continue;
            appCtx.setClassLoader((ClassLoader)obj);
            break;
        }
        String absolutePath = file.getAbsolutePath();
        String partOne = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator));
        String partTwo = URLEncoder.encode(absolutePath.substring(absolutePath.lastIndexOf(File.separator) + 1), "UTF-8");
        absolutePath = partOne + File.separator + partTwo;
        File springFile = new File(new File(absolutePath), SPRING_CONFIG);
        appCtx.setConfigLocation("file:" + springFile.getAbsolutePath());
        appCtx.refresh();
        return (Collection)appCtx.getBean("handlers");
    }

    protected void initialize(Collection<FacetHandler<?>> facetHandlers) throws IOException {
        if (facetHandlers == null) {
            FSDirectory fsDir;
            File file;
            Directory idxDir = this.directory();
            facetHandlers = idxDir != null && idxDir instanceof FSDirectory ? (new File(file = (fsDir = (FSDirectory)idxDir).getFile(), SPRING_CONFIG).exists() ? BoboIndexReader.loadFromIndex(file, this._workArea) : new ArrayList()) : new ArrayList();
        }
        this._facetHandlers = facetHandlers;
        this._facetHandlerMap = new HashMap();
        for (FacetHandler<?> facetHandler : facetHandlers) {
            this._facetHandlerMap.put(facetHandler.getName(), facetHandler);
        }
    }

    protected BoboIndexReader(IndexReader reader, Collection<FacetHandler<?>> facetHandlers, Collection<RuntimeFacetHandlerFactory<?, ?>> facetHandlerFactories, WorkArea workArea) throws IOException {
        this(reader, facetHandlers, facetHandlerFactories, workArea, true);
        this._srcReader = reader;
    }

    protected BoboIndexReader(IndexReader reader, Collection<FacetHandler<?>> facetHandlers, Collection<RuntimeFacetHandlerFactory<?, ?>> facetHandlerFactories, WorkArea workArea, boolean useSubReaders) throws IOException {
        super((IndexReader)(useSubReaders ? new MultiReader(BoboIndexReader.createSubReaders(reader, workArea), false) : reader));
        if (useSubReaders) {
            this._dir = reader.directory();
            BoboIndexReader[] subReaders = (BoboIndexReader[])this.in.getSequentialSubReaders();
            if (subReaders != null && subReaders.length > 0) {
                this._subReaders = subReaders;
                int maxDoc = 0;
                this._starts = new int[this._subReaders.length + 1];
                for (int i = 0; i < this._subReaders.length; ++i) {
                    this._subReaders[i]._dir = this._dir;
                    if (facetHandlers != null) {
                        this._subReaders[i].setFacetHandlers(facetHandlers);
                    }
                    this._starts[i] = maxDoc;
                    maxDoc += this._subReaders[i].maxDoc();
                }
                this._starts[this._subReaders.length] = maxDoc;
            }
        }
        this._runtimeFacetHandlerFactories = facetHandlerFactories;
        this._runtimeFacetHandlerFactoryMap = new HashMap();
        if (this._runtimeFacetHandlerFactories != null) {
            for (RuntimeFacetHandlerFactory<?, ?> factory : this._runtimeFacetHandlerFactories) {
                this._runtimeFacetHandlerFactoryMap.put(factory.getName(), factory);
            }
        }
        this._facetHandlers = facetHandlers;
        this._workArea = workArea;
    }

    protected void facetInit() throws IOException {
        this.facetInit(new HashSet<String>());
    }

    protected void facetInit(Set<String> toBeRemoved) throws IOException {
        this.initialize(this._facetHandlers);
        if (this._subReaders == null) {
            this.loadFacetHandlers(this._workArea, toBeRemoved);
        } else {
            for (BoboIndexReader r : this._subReaders) {
                r.facetInit(toBeRemoved);
            }
            for (String name : toBeRemoved) {
                this._facetHandlerMap.remove(name);
            }
        }
    }

    protected void setFacetHandlers(Collection<FacetHandler<?>> facetHandlers) {
        this._facetHandlers = facetHandlers;
    }

    public Query getFastMatchAllDocsQuery() {
        return new MatchAllDocsQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpFields(File outFile) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(outFile);
            PrintWriter out = new PrintWriter(writer);
            Set<String> fieldNames = this.getFacetNames();
            for (String fieldName : fieldNames) {
                Term term;
                TermEnum te = this.terms(new Term(fieldName, ""));
                out.write(fieldName + ":\n");
                while (te.next() && fieldName.equals((term = te.term()).field())) {
                    out.write(term.text() + "\n");
                }
                out.write("\n\n");
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public Set<String> getFacetNames() {
        return this._facetHandlerMap.keySet();
    }

    public FacetHandler<?> getFacetHandler(String fieldname) {
        FacetHandler<?> f = this._facetHandlerMap.get(fieldname);
        if (f == null) {
            f = this.getRuntimeFacetHandler(fieldname);
        }
        return f;
    }

    public IndexReader[] getSequentialSubReaders() {
        return this._subReaders;
    }

    public Map<String, FacetHandler<?>> getFacetHandlerMap() {
        return this._facetHandlerMap;
    }

    public Map<String, RuntimeFacetHandlerFactory<?, ?>> getRuntimeFacetHandlerFactoryMap() {
        return this._runtimeFacetHandlerFactoryMap;
    }

    public Map<String, RuntimeFacetHandler<?>> getRuntimeFacetHandlerMap() {
        return this._runtimeFacetHandlerMap.get();
    }

    public Map<String, Object> getRuntimeFacetDataMap() {
        return this._runtimeFacetDataMap.get();
    }

    public void setRuntimeFacetHandlerMap(Map<String, RuntimeFacetHandler<?>> map) {
        this._runtimeFacetHandlerMap.set(map);
    }

    public void setRuntimeFacetDataMap(Map<String, Object> map) {
        this._runtimeFacetDataMap.set(map);
    }

    public Document document(int docid) throws IOException {
        if (this._subReaders != null) {
            int readerIndex = BoboIndexReader.readerIndex(docid, this._starts, this._subReaders.length);
            BoboIndexReader subReader = this._subReaders[readerIndex];
            return subReader.document(docid - this._starts[readerIndex]);
        }
        Document doc = super.document(docid);
        Collection<FacetHandler<?>> facetHandlers = this._facetHandlerMap.values();
        for (FacetHandler<?> facetHandler : facetHandlers) {
            String[] vals = facetHandler.getFieldValues(this, docid);
            if (vals == null) continue;
            String[] values = doc.getValues(facetHandler.getName());
            HashSet<String> storedVals = new HashSet<String>(Arrays.asList(values));
            for (String val : vals) {
                storedVals.add(val);
            }
            doc.removeField(facetHandler.getName());
            for (String val : storedVals) {
                doc.add((Fieldable)new Field(facetHandler.getName(), val, Field.Store.NO, Field.Index.NOT_ANALYZED));
            }
        }
        return doc;
    }

    private static int readerIndex(int n, int[] starts, int numSubReaders) {
        int lo = 0;
        int hi = numSubReaders - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < numSubReaders && starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    private BoboIndexReader(IndexReader in) {
        super(in);
    }

    public BoboIndexReader copy(IndexReader in) {
        if (this._subReaders != null) {
            throw new IllegalStateException("this BoboIndexReader has subreaders");
        }
        BoboIndexReader copy = new BoboIndexReader(in);
        copy._facetHandlerMap = this._facetHandlerMap;
        copy._facetHandlers = this._facetHandlers;
        copy._runtimeFacetHandlerFactories = this._runtimeFacetHandlerFactories;
        copy._runtimeFacetHandlerFactoryMap = this._runtimeFacetHandlerFactoryMap;
        copy._workArea = this._workArea;
        copy._facetDataMap.putAll(this._facetDataMap);
        copy._srcReader = in;
        copy._starts = this._starts;
        return copy;
    }

    public static class WorkArea {
        HashMap<Class<?>, Object> map = new HashMap();

        public <T> T get(Class<T> cls) {
            Object obj = this.map.get(cls);
            return (T)obj;
        }

        public void put(Object obj) {
            this.map.put(obj.getClass(), obj);
        }

        public void clear() {
            this.map.clear();
        }

        public String toString() {
            return this.map.toString();
        }
    }
}

