/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.impl;

import com.browseengine.bobo.api.BoboBrowser;
import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseException;
import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.BrowseResult;
import com.browseengine.bobo.service.BrowseService;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DefaultBrowseServiceImpl
implements BrowseService {
    private static Logger logger = Logger.getLogger(DefaultBrowseServiceImpl.class);
    private BoboIndexReader _reader;
    private boolean _closeReader;

    public DefaultBrowseServiceImpl(BoboIndexReader reader) {
        this._reader = reader;
        this._closeReader = false;
    }

    public void setCloseReaderOnCleanup(boolean closeReader) {
        this._closeReader = closeReader;
    }

    @Override
    public BrowseResult browse(BrowseRequest req) throws BrowseException {
        BrowseResult result = BrowseService.EMPTY_RESULT;
        if (req.getOffset() < 0) {
            throw new BrowseException("Invalid offset: " + req.getOffset());
        }
        if (this._reader != null) {
            BoboBrowser browser;
            try {
                browser = new BoboBrowser(this._reader);
            }
            catch (IOException e) {
                throw new BrowseException("failed to create BoboBrowser", e);
            }
            result = browser.browse(req);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws BrowseException {
        if (this._closeReader) {
            DefaultBrowseServiceImpl defaultBrowseServiceImpl = this;
            synchronized (defaultBrowseServiceImpl) {
                if (this._reader != null) {
                    try {
                        this._reader.close();
                        this._reader = null;
                    }
                    catch (IOException ioe) {
                        throw new BrowseException(ioe.getMessage(), ioe);
                    }
                }
            }
        }
    }
}

