/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.io;

import it.unimi.dsi.fastutil.booleans.AbstractBooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;

public class BinIO {
    private BinIO() {
    }

    public static void storeObject(Object o, File file) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        oos.writeObject(o);
        oos.close();
    }

    public static void storeObject(Object o, CharSequence filename) throws IOException {
        BinIO.storeObject(o, new File(((Object)filename).toString()));
    }

    public static Object loadObject(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FastBufferedInputStream(new FileInputStream(file)));
        Object result = ois.readObject();
        ois.close();
        return result;
    }

    public static Object loadObject(CharSequence filename) throws IOException, ClassNotFoundException {
        return BinIO.loadObject(new File(((Object)filename).toString()));
    }

    public static void storeObject(Object o, OutputStream s) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FastBufferedOutputStream(s));
        oos.writeObject(o);
        oos.flush();
    }

    public static Object loadObject(InputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FastBufferedInputStream(s));
        Object result = ois.readObject();
        return result;
    }

    public static int loadBooleans(DataInput dataInput, boolean[] array, int offset, int length) throws IOException {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readBoolean();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadBooleans(DataInput dataInput, boolean[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readBoolean();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadBooleans(File file, boolean[] array, int offset, int length) throws IOException {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readBoolean();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadBooleans(CharSequence filename, boolean[] array, int offset, int length) throws IOException {
        return BinIO.loadBooleans(new File(((Object)filename).toString()), array, offset, length);
    }

    public static int loadBooleans(File file, boolean[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readBoolean();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadBooleans(CharSequence filename, boolean[] array) throws IOException {
        return BinIO.loadBooleans(new File(((Object)filename).toString()), array);
    }

    public static boolean[] loadBooleans(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long length = fis.getChannel().size();
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        boolean[] array = new boolean[(int)length];
        int i = 0;
        while ((long)i < length) {
            array[i] = dis.readBoolean();
            ++i;
        }
        dis.close();
        return array;
    }

    public static boolean[] loadBooleans(CharSequence filename) throws IOException {
        return BinIO.loadBooleans(new File(((Object)filename).toString()));
    }

    public static void storeBooleans(boolean[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeBoolean(array[offset + i]);
        }
    }

    public static void storeBooleans(boolean[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeBoolean(array[i]);
        }
    }

    public static void storeBooleans(boolean[] array, int offset, int length, File file) throws IOException {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeBoolean(array[offset + i]);
        }
        dos.close();
    }

    public static void storeBooleans(boolean[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeBooleans(array, offset, length, new File(((Object)filename).toString()));
    }

    public static void storeBooleans(boolean[] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeBoolean(array[i]);
        }
        dos.close();
    }

    public static void storeBooleans(boolean[] array, CharSequence filename) throws IOException {
        BinIO.storeBooleans(array, new File(((Object)filename).toString()));
    }

    public static void storeBooleans(BooleanIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeBoolean(i.nextBoolean());
        }
    }

    public static void storeBooleans(BooleanIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeBoolean(i.nextBoolean());
        }
        dos.close();
    }

    public static void storeBooleans(BooleanIterator i, CharSequence filename) throws IOException {
        BinIO.storeBooleans(i, new File(((Object)filename).toString()));
    }

    public static BooleanIterator asBooleanIterator(DataInput dataInput) {
        return new BooleanDataInputWrapper(dataInput);
    }

    public static BooleanIterator asBooleanIterator(File file) throws IOException {
        return new BooleanDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static BooleanIterator asBooleanIterator(CharSequence filename) throws IOException {
        return BinIO.asBooleanIterator(new File(((Object)filename).toString()));
    }

    public static int loadBytes(DataInput dataInput, byte[] array, int offset, int length) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readByte();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadBytes(DataInput dataInput, byte[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readByte();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadBytes(File file, byte[] array, int offset, int length) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readByte();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadBytes(CharSequence filename, byte[] array, int offset, int length) throws IOException {
        return BinIO.loadBytes(new File(((Object)filename).toString()), array, offset, length);
    }

    public static int loadBytes(File file, byte[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readByte();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadBytes(CharSequence filename, byte[] array) throws IOException {
        return BinIO.loadBytes(new File(((Object)filename).toString()), array);
    }

    public static byte[] loadBytes(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long length = fis.getChannel().size() / 1L;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        byte[] array = new byte[(int)length];
        int i = 0;
        while ((long)i < length) {
            array[i] = dis.readByte();
            ++i;
        }
        dis.close();
        return array;
    }

    public static byte[] loadBytes(CharSequence filename) throws IOException {
        return BinIO.loadBytes(new File(((Object)filename).toString()));
    }

    public static void storeBytes(byte[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeByte(array[offset + i]);
        }
    }

    public static void storeBytes(byte[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeByte(array[i]);
        }
    }

    public static void storeBytes(byte[] array, int offset, int length, File file) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeByte(array[offset + i]);
        }
        dos.close();
    }

    public static void storeBytes(byte[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeBytes(array, offset, length, new File(((Object)filename).toString()));
    }

    public static void storeBytes(byte[] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeByte(array[i]);
        }
        dos.close();
    }

    public static void storeBytes(byte[] array, CharSequence filename) throws IOException {
        BinIO.storeBytes(array, new File(((Object)filename).toString()));
    }

    public static void storeBytes(ByteIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeByte(i.nextByte());
        }
    }

    public static void storeBytes(ByteIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeByte(i.nextByte());
        }
        dos.close();
    }

    public static void storeBytes(ByteIterator i, CharSequence filename) throws IOException {
        BinIO.storeBytes(i, new File(((Object)filename).toString()));
    }

    public static ByteIterator asByteIterator(DataInput dataInput) {
        return new ByteDataInputWrapper(dataInput);
    }

    public static ByteIterator asByteIterator(File file) throws IOException {
        return new ByteDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static ByteIterator asByteIterator(CharSequence filename) throws IOException {
        return BinIO.asByteIterator(new File(((Object)filename).toString()));
    }

    public static int loadShorts(DataInput dataInput, short[] array, int offset, int length) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readShort();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadShorts(DataInput dataInput, short[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readShort();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadShorts(File file, short[] array, int offset, int length) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readShort();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadShorts(CharSequence filename, short[] array, int offset, int length) throws IOException {
        return BinIO.loadShorts(new File(((Object)filename).toString()), array, offset, length);
    }

    public static int loadShorts(File file, short[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readShort();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadShorts(CharSequence filename, short[] array) throws IOException {
        return BinIO.loadShorts(new File(((Object)filename).toString()), array);
    }

    public static short[] loadShorts(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long length = fis.getChannel().size() / 2L;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        short[] array = new short[(int)length];
        int i = 0;
        while ((long)i < length) {
            array[i] = dis.readShort();
            ++i;
        }
        dis.close();
        return array;
    }

    public static short[] loadShorts(CharSequence filename) throws IOException {
        return BinIO.loadShorts(new File(((Object)filename).toString()));
    }

    public static void storeShorts(short[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeShort(array[offset + i]);
        }
    }

    public static void storeShorts(short[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeShort(array[i]);
        }
    }

    public static void storeShorts(short[] array, int offset, int length, File file) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeShort(array[offset + i]);
        }
        dos.close();
    }

    public static void storeShorts(short[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeShorts(array, offset, length, new File(((Object)filename).toString()));
    }

    public static void storeShorts(short[] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeShort(array[i]);
        }
        dos.close();
    }

    public static void storeShorts(short[] array, CharSequence filename) throws IOException {
        BinIO.storeShorts(array, new File(((Object)filename).toString()));
    }

    public static void storeShorts(ShortIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeShort(i.nextShort());
        }
    }

    public static void storeShorts(ShortIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeShort(i.nextShort());
        }
        dos.close();
    }

    public static void storeShorts(ShortIterator i, CharSequence filename) throws IOException {
        BinIO.storeShorts(i, new File(((Object)filename).toString()));
    }

    public static ShortIterator asShortIterator(DataInput dataInput) {
        return new ShortDataInputWrapper(dataInput);
    }

    public static ShortIterator asShortIterator(File file) throws IOException {
        return new ShortDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static ShortIterator asShortIterator(CharSequence filename) throws IOException {
        return BinIO.asShortIterator(new File(((Object)filename).toString()));
    }

    public static int loadChars(DataInput dataInput, char[] array, int offset, int length) throws IOException {
        CharArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readChar();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadChars(DataInput dataInput, char[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadChars(File file, char[] array, int offset, int length) throws IOException {
        CharArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readChar();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadChars(CharSequence filename, char[] array, int offset, int length) throws IOException {
        return BinIO.loadChars(new File(((Object)filename).toString()), array, offset, length);
    }

    public static int loadChars(File file, char[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readChar();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadChars(CharSequence filename, char[] array) throws IOException {
        return BinIO.loadChars(new File(((Object)filename).toString()), array);
    }

    public static char[] loadChars(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long length = fis.getChannel().size() / 2L;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        char[] array = new char[(int)length];
        int i = 0;
        while ((long)i < length) {
            array[i] = dis.readChar();
            ++i;
        }
        dis.close();
        return array;
    }

    public static char[] loadChars(CharSequence filename) throws IOException {
        return BinIO.loadChars(new File(((Object)filename).toString()));
    }

    public static void storeChars(char[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        CharArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeChar(array[offset + i]);
        }
    }

    public static void storeChars(char[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeChar(array[i]);
        }
    }

    public static void storeChars(char[] array, int offset, int length, File file) throws IOException {
        CharArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeChar(array[offset + i]);
        }
        dos.close();
    }

    public static void storeChars(char[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeChars(array, offset, length, new File(((Object)filename).toString()));
    }

    public static void storeChars(char[] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeChar(array[i]);
        }
        dos.close();
    }

    public static void storeChars(char[] array, CharSequence filename) throws IOException {
        BinIO.storeChars(array, new File(((Object)filename).toString()));
    }

    public static void storeChars(CharIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeChar(i.nextChar());
        }
    }

    public static void storeChars(CharIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeChar(i.nextChar());
        }
        dos.close();
    }

    public static void storeChars(CharIterator i, CharSequence filename) throws IOException {
        BinIO.storeChars(i, new File(((Object)filename).toString()));
    }

    public static CharIterator asCharIterator(DataInput dataInput) {
        return new CharDataInputWrapper(dataInput);
    }

    public static CharIterator asCharIterator(File file) throws IOException {
        return new CharDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static CharIterator asCharIterator(CharSequence filename) throws IOException {
        return BinIO.asCharIterator(new File(((Object)filename).toString()));
    }

    public static int loadInts(DataInput dataInput, int[] array, int offset, int length) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readInt();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadInts(DataInput dataInput, int[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readInt();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadInts(File file, int[] array, int offset, int length) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readInt();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadInts(CharSequence filename, int[] array, int offset, int length) throws IOException {
        return BinIO.loadInts(new File(((Object)filename).toString()), array, offset, length);
    }

    public static int loadInts(File file, int[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readInt();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadInts(CharSequence filename, int[] array) throws IOException {
        return BinIO.loadInts(new File(((Object)filename).toString()), array);
    }

    public static int[] loadInts(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long length = fis.getChannel().size() / 4L;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        int[] array = new int[(int)length];
        int i = 0;
        while ((long)i < length) {
            array[i] = dis.readInt();
            ++i;
        }
        dis.close();
        return array;
    }

    public static int[] loadInts(CharSequence filename) throws IOException {
        return BinIO.loadInts(new File(((Object)filename).toString()));
    }

    public static void storeInts(int[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeInt(array[offset + i]);
        }
    }

    public static void storeInts(int[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeInt(array[i]);
        }
    }

    public static void storeInts(int[] array, int offset, int length, File file) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeInt(array[offset + i]);
        }
        dos.close();
    }

    public static void storeInts(int[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeInts(array, offset, length, new File(((Object)filename).toString()));
    }

    public static void storeInts(int[] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeInt(array[i]);
        }
        dos.close();
    }

    public static void storeInts(int[] array, CharSequence filename) throws IOException {
        BinIO.storeInts(array, new File(((Object)filename).toString()));
    }

    public static void storeInts(IntIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeInt(i.nextInt());
        }
    }

    public static void storeInts(IntIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeInt(i.nextInt());
        }
        dos.close();
    }

    public static void storeInts(IntIterator i, CharSequence filename) throws IOException {
        BinIO.storeInts(i, new File(((Object)filename).toString()));
    }

    public static IntIterator asIntIterator(DataInput dataInput) {
        return new IntDataInputWrapper(dataInput);
    }

    public static IntIterator asIntIterator(File file) throws IOException {
        return new IntDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static IntIterator asIntIterator(CharSequence filename) throws IOException {
        return BinIO.asIntIterator(new File(((Object)filename).toString()));
    }

    public static int loadLongs(DataInput dataInput, long[] array, int offset, int length) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readLong();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadLongs(DataInput dataInput, long[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readLong();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadLongs(File file, long[] array, int offset, int length) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readLong();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadLongs(CharSequence filename, long[] array, int offset, int length) throws IOException {
        return BinIO.loadLongs(new File(((Object)filename).toString()), array, offset, length);
    }

    public static int loadLongs(File file, long[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readLong();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadLongs(CharSequence filename, long[] array) throws IOException {
        return BinIO.loadLongs(new File(((Object)filename).toString()), array);
    }

    public static long[] loadLongs(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long length = fis.getChannel().size() / 8L;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        long[] array = new long[(int)length];
        int i = 0;
        while ((long)i < length) {
            array[i] = dis.readLong();
            ++i;
        }
        dis.close();
        return array;
    }

    public static long[] loadLongs(CharSequence filename) throws IOException {
        return BinIO.loadLongs(new File(((Object)filename).toString()));
    }

    public static void storeLongs(long[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeLong(array[offset + i]);
        }
    }

    public static void storeLongs(long[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeLong(array[i]);
        }
    }

    public static void storeLongs(long[] array, int offset, int length, File file) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeLong(array[offset + i]);
        }
        dos.close();
    }

    public static void storeLongs(long[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeLongs(array, offset, length, new File(((Object)filename).toString()));
    }

    public static void storeLongs(long[] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeLong(array[i]);
        }
        dos.close();
    }

    public static void storeLongs(long[] array, CharSequence filename) throws IOException {
        BinIO.storeLongs(array, new File(((Object)filename).toString()));
    }

    public static void storeLongs(LongIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeLong(i.nextLong());
        }
    }

    public static void storeLongs(LongIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeLong(i.nextLong());
        }
        dos.close();
    }

    public static void storeLongs(LongIterator i, CharSequence filename) throws IOException {
        BinIO.storeLongs(i, new File(((Object)filename).toString()));
    }

    public static LongIterator asLongIterator(DataInput dataInput) {
        return new LongDataInputWrapper(dataInput);
    }

    public static LongIterator asLongIterator(File file) throws IOException {
        return new LongDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static LongIterator asLongIterator(CharSequence filename) throws IOException {
        return BinIO.asLongIterator(new File(((Object)filename).toString()));
    }

    public static int loadFloats(DataInput dataInput, float[] array, int offset, int length) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readFloat();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadFloats(DataInput dataInput, float[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readFloat();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadFloats(File file, float[] array, int offset, int length) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readFloat();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadFloats(CharSequence filename, float[] array, int offset, int length) throws IOException {
        return BinIO.loadFloats(new File(((Object)filename).toString()), array, offset, length);
    }

    public static int loadFloats(File file, float[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readFloat();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadFloats(CharSequence filename, float[] array) throws IOException {
        return BinIO.loadFloats(new File(((Object)filename).toString()), array);
    }

    public static float[] loadFloats(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long length = fis.getChannel().size() / 4L;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        float[] array = new float[(int)length];
        int i = 0;
        while ((long)i < length) {
            array[i] = dis.readFloat();
            ++i;
        }
        dis.close();
        return array;
    }

    public static float[] loadFloats(CharSequence filename) throws IOException {
        return BinIO.loadFloats(new File(((Object)filename).toString()));
    }

    public static void storeFloats(float[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeFloat(array[offset + i]);
        }
    }

    public static void storeFloats(float[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeFloat(array[i]);
        }
    }

    public static void storeFloats(float[] array, int offset, int length, File file) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeFloat(array[offset + i]);
        }
        dos.close();
    }

    public static void storeFloats(float[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeFloats(array, offset, length, new File(((Object)filename).toString()));
    }

    public static void storeFloats(float[] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeFloat(array[i]);
        }
        dos.close();
    }

    public static void storeFloats(float[] array, CharSequence filename) throws IOException {
        BinIO.storeFloats(array, new File(((Object)filename).toString()));
    }

    public static void storeFloats(FloatIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeFloat(i.nextFloat());
        }
    }

    public static void storeFloats(FloatIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeFloat(i.nextFloat());
        }
        dos.close();
    }

    public static void storeFloats(FloatIterator i, CharSequence filename) throws IOException {
        BinIO.storeFloats(i, new File(((Object)filename).toString()));
    }

    public static FloatIterator asFloatIterator(DataInput dataInput) {
        return new FloatDataInputWrapper(dataInput);
    }

    public static FloatIterator asFloatIterator(File file) throws IOException {
        return new FloatDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static FloatIterator asFloatIterator(CharSequence filename) throws IOException {
        return BinIO.asFloatIterator(new File(((Object)filename).toString()));
    }

    public static int loadDoubles(DataInput dataInput, double[] array, int offset, int length) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readDouble();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadDoubles(DataInput dataInput, double[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readDouble();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadDoubles(File file, double[] array, int offset, int length) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readDouble();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadDoubles(CharSequence filename, double[] array, int offset, int length) throws IOException {
        return BinIO.loadDoubles(new File(((Object)filename).toString()), array, offset, length);
    }

    public static int loadDoubles(File file, double[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readDouble();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadDoubles(CharSequence filename, double[] array) throws IOException {
        return BinIO.loadDoubles(new File(((Object)filename).toString()), array);
    }

    public static double[] loadDoubles(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long length = fis.getChannel().size() / 8L;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        double[] array = new double[(int)length];
        int i = 0;
        while ((long)i < length) {
            array[i] = dis.readDouble();
            ++i;
        }
        dis.close();
        return array;
    }

    public static double[] loadDoubles(CharSequence filename) throws IOException {
        return BinIO.loadDoubles(new File(((Object)filename).toString()));
    }

    public static void storeDoubles(double[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeDouble(array[offset + i]);
        }
    }

    public static void storeDoubles(double[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeDouble(array[i]);
        }
    }

    public static void storeDoubles(double[] array, int offset, int length, File file) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeDouble(array[offset + i]);
        }
        dos.close();
    }

    public static void storeDoubles(double[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeDoubles(array, offset, length, new File(((Object)filename).toString()));
    }

    public static void storeDoubles(double[] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeDouble(array[i]);
        }
        dos.close();
    }

    public static void storeDoubles(double[] array, CharSequence filename) throws IOException {
        BinIO.storeDoubles(array, new File(((Object)filename).toString()));
    }

    public static void storeDoubles(DoubleIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeDouble(i.nextDouble());
        }
    }

    public static void storeDoubles(DoubleIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeDouble(i.nextDouble());
        }
        dos.close();
    }

    public static void storeDoubles(DoubleIterator i, CharSequence filename) throws IOException {
        BinIO.storeDoubles(i, new File(((Object)filename).toString()));
    }

    public static DoubleIterator asDoubleIterator(DataInput dataInput) {
        return new DoubleDataInputWrapper(dataInput);
    }

    public static DoubleIterator asDoubleIterator(File file) throws IOException {
        return new DoubleDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static DoubleIterator asDoubleIterator(CharSequence filename) throws IOException {
        return BinIO.asDoubleIterator(new File(((Object)filename).toString()));
    }

    private static final class DoubleDataInputWrapper
    extends AbstractDoubleIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private double next;

        public DoubleDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readDouble();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class FloatDataInputWrapper
    extends AbstractFloatIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private float next;

        public FloatDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readFloat();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class LongDataInputWrapper
    extends AbstractLongIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private long next;

        public LongDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readLong();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class IntDataInputWrapper
    extends AbstractIntIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private int next;

        public IntDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readInt();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class CharDataInputWrapper
    extends AbstractCharIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private char next;

        public CharDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readChar();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ShortDataInputWrapper
    extends AbstractShortIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private short next;

        public ShortDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readShort();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ByteDataInputWrapper
    extends AbstractByteIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private byte next;

        public ByteDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readByte();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class BooleanDataInputWrapper
    extends AbstractBooleanIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private boolean next;

        public BooleanDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readBoolean();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public boolean nextBoolean() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }
}

