/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security.policy;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freshcookies.security.cert.JarHelper;
import org.freshcookies.security.policy.Canonicalizer;
import org.freshcookies.security.policy.GenericPrincipal;
import org.freshcookies.security.policy.PolicyReader;
import org.freshcookies.security.policy.UnresolvedPrincipal;

public class SecurityTokenFactory {
    private static final String ONE_SPACE = " ";
    private static final int NOT_FOUND = -1;
    private static final String DOUBLE_QUOTE = "\"";
    protected static final String REGEX_JAVA_TYPE = "((?:[a-zA-Z0-9$_]+\\.)*[A-Z$_][a-zA-Z0-9$_]*)";
    protected static final Pattern PERMISSION_PATTERN = Pattern.compile("^((?:[a-zA-Z0-9$_]+\\.)*[A-Z$_][a-zA-Z0-9$_]*)(?: ?\"(.*?)\")??(?: ?, ?\"(.*?)\")??$");
    private final ClassLoader classLoader;
    private final Map cachedCodeSources;
    private final Map cachedPermissions;
    private final Map cachedPrincipals;
    private final JarHelper jarHelper;
    private final Canonicalizer canonicalizer;

    public SecurityTokenFactory(URL[] urls) {
        this.classLoader = urls != null && urls.length > 0 ? new URLClassLoader(urls) : null;
        this.cachedCodeSources = new HashMap();
        this.cachedPermissions = new HashMap();
        this.cachedPrincipals = new HashMap();
        this.canonicalizer = new Canonicalizer();
        this.jarHelper = new JarHelper();
    }

    public Principal getPrincipal(String s) {
        String principalClass;
        String principalName;
        if (this.cachedPrincipals.containsKey(s)) {
            return (Principal)this.cachedPrincipals.get(s);
        }
        int space = s.indexOf(ONE_SPACE);
        int quote = s.indexOf(DOUBLE_QUOTE);
        Principal principal = null;
        if (space == -1 || quote < space) {
            s = GenericPrincipal.class.getName() + ONE_SPACE + s;
            space = s.indexOf(ONE_SPACE);
        }
        if ((principalName = s.substring((principalClass = s.substring(0, space).trim()).length()).trim()).startsWith(DOUBLE_QUOTE) && principalName.endsWith(DOUBLE_QUOTE) && principalName.length() > 2) {
            principalName = principalName.substring(1, principalName.length() - 1);
        }
        try {
            Class clazz = this.findClass(principalClass);
            Constructor c = clazz.getConstructor(String.class);
            Object p = c.newInstance(principalName);
            principal = (Principal)p;
        }
        catch (Exception e) {
            principal = new UnresolvedPrincipal(principalClass, principalName, e);
        }
        this.cachedPermissions.put(s, principal);
        return principal;
    }

    public int getPrincipalCount() {
        return this.cachedPrincipals.size();
    }

    public Permission getPermission(String permissionString) throws ClassNotFoundException {
        return this.getPermission(permissionString, false);
    }

    public Permission getPermission(String permissionString, boolean canonicalize) throws ClassNotFoundException {
        if (this.cachedPermissions.containsKey(permissionString)) {
            return (Permission)this.cachedPermissions.get(permissionString);
        }
        String permissionClass = null;
        String target = null;
        String actions = null;
        Matcher m = PERMISSION_PATTERN.matcher(permissionString);
        if (m.find()) {
            permissionClass = m.group(1);
            if (m.group(3) != null) {
                target = m.group(2);
                actions = m.group(3);
            } else if (m.group(2) != null) {
                target = m.group(2);
            }
        } else {
            throw new ClassNotFoundException("Malformed permission: " + permissionString);
        }
        Permission perm = null;
        try {
            Class clazz = this.findClass(permissionClass);
            Class[] constructorArgClasses = new Class[]{};
            Object[] constructorArgs = new String[]{};
            if (actions != null) {
                constructorArgs = new String[]{target, actions};
                constructorArgClasses = new Class[]{String.class, String.class};
            } else if (target != null) {
                constructorArgs = new String[]{target};
                constructorArgClasses = new Class[]{String.class};
            }
            Constructor c = clazz.getConstructor(constructorArgClasses);
            perm = (Permission)c.newInstance(constructorArgs);
        }
        catch (Exception e) {
            perm = new UnresolvedPermission(permissionClass, target, actions, null);
        }
        if (canonicalize) {
            perm = this.canonicalizer.canonicalize(perm);
        }
        this.cachedPermissions.put(permissionString, perm);
        return perm;
    }

    public int getPermissonCount() {
        return this.cachedPermissions.size();
    }

    public CodeSource getCodeSource(String path) throws IOException, MalformedURLException {
        return this.getCodeSource(path, false);
    }

    public CodeSource getCodeSource(String path, boolean canonicalize) throws IOException, MalformedURLException {
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if (this.cachedCodeSources.containsKey(path)) {
            return (CodeSource)this.cachedCodeSources.get(path);
        }
        File file = new File(path);
        if (!PolicyReader.secureExists(file)) {
            throw new IOException("Path " + path + " does not exist.");
        }
        if (canonicalize) {
            path = file.getCanonicalPath();
        }
        CodeSource cs = null;
        if (path.endsWith(".jar")) {
            JarFile jar = new JarFile(new File(path));
            Set certSet = this.jarHelper.extractSigningCertificates(jar);
            Certificate[] certs = certSet.toArray(new Certificate[certSet.size()]);
            cs = new CodeSource(new URL("file:" + path), certs);
        } else {
            cs = new CodeSource(new URL("file:" + path), new Certificate[0]);
        }
        this.cachedCodeSources.put(path, cs);
        return cs;
    }

    public int getCodeSourceCount() {
        return this.cachedCodeSources.size();
    }

    public Class findClass(String className) throws ClassNotFoundException {
        Class<?> cls = null;
        try {
            cls = this.getClass().getClassLoader().loadClass(className);
            return cls;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.classLoader != null) {
                return this.classLoader.loadClass(className);
            }
            throw new ClassNotFoundException("Class not found: " + className);
        }
    }

    public synchronized void reset() {
        this.cachedCodeSources.clear();
        this.cachedPermissions.clear();
        this.cachedPrincipals.clear();
    }
}

