/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.ehcache.Ehcache;

public class BootstrapRequest {
    private volatile CountDownLatch boostrapCompleteLatch = new CountDownLatch(1);
    private final AtomicLong replicated = new AtomicLong();
    private final Ehcache cache;
    private final boolean asynchronous;
    private final int chunkSize;
    private volatile BootstrapStatus bootstrapStatus = BootstrapStatus.UNSENT;

    public BootstrapRequest(Ehcache cache, boolean asynchronous, int chunkSize) {
        this.cache = cache;
        this.asynchronous = asynchronous;
        this.chunkSize = chunkSize;
    }

    public BootstrapStatus getBootstrapStatus() {
        return this.bootstrapStatus;
    }

    public void setBootstrapStatus(BootstrapStatus bootstrapStatus) {
        if (bootstrapStatus == null) {
            throw new IllegalArgumentException("BootstrapStatus cannot be null");
        }
        this.bootstrapStatus = bootstrapStatus;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void reset() {
        this.boostrapCompleteLatch = new CountDownLatch(1);
        this.replicated.set(0L);
        this.bootstrapStatus = BootstrapStatus.UNSENT;
    }

    public void boostrapComplete(BootstrapStatus status) {
        this.bootstrapStatus = status;
        this.boostrapCompleteLatch.countDown();
    }

    public boolean waitForBoostrap(long timeout, TimeUnit unit) throws InterruptedException {
        return this.boostrapCompleteLatch.await(timeout, unit);
    }

    public void countReplication() {
        this.replicated.incrementAndGet();
    }

    public long getReplicationCount() {
        return this.replicated.get();
    }

    public Ehcache getCache() {
        return this.cache;
    }

    public String toString() {
        return "BootstrapRequest [cache=" + this.cache.getName() + ", bootstrapStatus=" + (Object)((Object)this.bootstrapStatus) + ", boostrapCompleteLatch=" + this.boostrapCompleteLatch.getCount() + ", replicated=" + this.replicated + ", asynchronous=" + this.asynchronous + ", chunkSize=" + this.chunkSize + "]";
    }

    public static enum BootstrapStatus {
        UNSENT,
        REQUESTED,
        INCOMPLETE,
        COMPLETE;

    }
}

