/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.video;

import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.BgrConverter;
import com.xuggle.xuggler.video.IConverter;
import java.awt.image.BufferedImage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConverterFactory {
    public static final String XUGGLER_ARGB_32 = "XUGGLER-ARGB-32";
    public static final String XUGGLER_BGR_24 = "XUGGLER-BGR-24";
    private static Map<String, Type> mConverterTypes = new HashMap<String, Type>();

    protected ConverterFactory() {
    }

    public static Type registerConverter(Type converterType) {
        return mConverterTypes.put(converterType.getDescriptor(), converterType);
    }

    public static Type unregisterConverter(Type converterType) {
        return mConverterTypes.remove(converterType.getDescriptor());
    }

    public static Collection<Type> getRegisteredConverters() {
        return Collections.unmodifiableCollection(mConverterTypes.values());
    }

    public static Type findRegisteredConverter(String descriptor) {
        return mConverterTypes.get(descriptor);
    }

    public static String findDescriptor(BufferedImage image) {
        for (Type converterType : ConverterFactory.getRegisteredConverters()) {
            if (converterType.getImageType() != image.getType()) continue;
            return converterType.getDescriptor();
        }
        return null;
    }

    public static IConverter createConverter(String converterDescriptor, IVideoPicture picture) {
        if (picture == null) {
            throw new IllegalArgumentException("The picture is NULL.");
        }
        return ConverterFactory.createConverter(converterDescriptor, picture.getPixelType(), picture.getWidth(), picture.getHeight());
    }

    public static IConverter createConverter(BufferedImage image, IPixelFormat.Type pictureType) {
        if (image == null) {
            throw new IllegalArgumentException("The image is NULL.");
        }
        String converterDescriptor = ConverterFactory.findDescriptor(image);
        if (converterDescriptor == null) {
            throw new UnsupportedOperationException("No converter found for BufferedImage type #" + image.getType());
        }
        return ConverterFactory.createConverter(converterDescriptor, pictureType, image.getWidth(), image.getHeight());
    }

    public static IConverter createConverter(String converterDescriptor, IPixelFormat.Type pictureType, int width, int height) {
        return ConverterFactory.createConverter(converterDescriptor, pictureType, width, height, width, height);
    }

    public static IConverter createConverter(String converterDescriptor, IPixelFormat.Type pictureType, int pictureWidth, int pictureHeight, int imageWidth, int imageHeight) {
        IConverter converter = null;
        Type converterType = ConverterFactory.findRegisteredConverter(converterDescriptor);
        if (null == converterType) {
            throw new UnsupportedOperationException("No converter \"" + converterDescriptor + "\" found.");
        }
        try {
            Constructor<? extends IConverter> converterConstructor = converterType.getConverterClass().getConstructor(IPixelFormat.Type.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            converter = converterConstructor.newInstance(new Object[]{pictureType, pictureWidth, pictureHeight, imageWidth, imageHeight});
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Converter " + converterType.getConverterClass() + " requries a constructor of the form " + "(IPixelFormat.Type, int, int, int, int)");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)cause;
            }
            throw new UnsupportedOperationException("Converter " + converterType.getConverterClass() + " constructor failed with: " + e.getCause());
        }
        catch (IllegalAccessException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)cause;
            }
            throw new UnsupportedOperationException("Converter " + converterType.getConverterClass() + " constructor failed with: " + e.getCause());
        }
        catch (InstantiationException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)cause;
            }
            throw new UnsupportedOperationException("Converter " + converterType.getConverterClass() + " constructor failed with: " + e.getCause());
        }
        return converter;
    }

    public static BufferedImage convertToType(BufferedImage sourceImage, int targetType) {
        BufferedImage image;
        if (sourceImage.getType() == targetType) {
            image = sourceImage;
        } else {
            image = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), targetType);
            image.getGraphics().drawImage(sourceImage, 0, 0, null);
        }
        return image;
    }

    static {
        ConverterFactory.registerConverter(new Type(XUGGLER_BGR_24, BgrConverter.class, IPixelFormat.Type.BGR24, 5));
    }

    public static class Type {
        private final String mDescriptor;
        private final Class<? extends IConverter> mConverterClass;
        private final IPixelFormat.Type mPictureType;
        private final int mImageType;

        public Type(String descriptor, Class<? extends IConverter> converterClass, IPixelFormat.Type pictureType, int imageType) {
            this.mDescriptor = descriptor;
            this.mConverterClass = converterClass;
            this.mPictureType = pictureType;
            this.mImageType = imageType;
        }

        public String getDescriptor() {
            return this.mDescriptor;
        }

        public Class<? extends IConverter> getConverterClass() {
            return this.mConverterClass;
        }

        public IPixelFormat.Type getPictureType() {
            return this.mPictureType;
        }

        public int getImageType() {
            return this.mImageType;
        }

        public String toString() {
            return this.getDescriptor() + ": picture type " + (Object)((Object)this.getPictureType()) + ", image type " + this.getImageType();
        }
    }
}

