/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.Array;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCArrayBasic;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.types.Type;

public class ArrayType
extends Type {
    public static final int defaultArrayCardinality = 1024;
    public static final int defaultLargeArrayCardinality = 0x100000;
    final Type dataType;
    final int maxCardinality;

    public ArrayType(Type dataType, int cardinality) {
        super(50, 50, 0L, 0);
        this.dataType = dataType;
        this.maxCardinality = cardinality;
    }

    public int displaySize() {
        return 7 + (this.dataType.displaySize() + 1) * this.maxCardinality;
    }

    public int getJDBCTypeCode() {
        return 2003;
    }

    public Class getJDBCClass() {
        return Array.class;
    }

    public String getJDBCClassName() {
        return "java.sql.Array";
    }

    public int getJDBCScale() {
        return 0;
    }

    public int getJDBCPrecision() {
        return 0;
    }

    public int getSQLGenericTypeCode() {
        return 0;
    }

    public String getNameString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.dataType.getNameString()).append(' ');
        sb.append("ARRAY");
        if (this.maxCardinality != 1024) {
            sb.append('[').append(this.maxCardinality).append(']');
        }
        return sb.toString();
    }

    String getDefinition() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.dataType.getDefinition()).append(' ');
        sb.append("ARRAY");
        if (this.maxCardinality != 1024) {
            sb.append('[').append(this.maxCardinality).append(']');
        }
        return sb.toString();
    }

    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Object[] arrb = (Object[])b;
        Object[] arra = (Object[])a;
        int length = arra.length;
        if (arrb.length < length) {
            length = arrb.length;
        }
        for (int i = 0; i < length; ++i) {
            int result = this.dataType.compare(session, arra[i], arrb[i]);
            if (result == 0) continue;
            return result;
        }
        if (arra.length > arrb.length) {
            return 1;
        }
        if (arra.length < arrb.length) {
            return -1;
        }
        return 0;
    }

    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        Object[] arra = (Object[])a;
        if (arra.length > this.maxCardinality) {
            throw Error.error(3491);
        }
        Object[] arrb = new Object[arra.length];
        for (int i = 0; i < arra.length; ++i) {
            arrb[i] = this.dataType.convertToTypeLimits(session, arra[i]);
        }
        return arrb;
    }

    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return null;
        }
        if (otherType == null) {
            return a;
        }
        if (!otherType.isArrayType()) {
            throw Error.error(5562);
        }
        Object[] arra = (Object[])a;
        if (arra.length > this.maxCardinality) {
            throw Error.error(3491);
        }
        Type otherComponent = otherType.collectionBaseType();
        if (this.dataType.equals(otherComponent)) {
            return a;
        }
        Object[] arrb = new Object[arra.length];
        for (int i = 0; i < arra.length; ++i) {
            arrb[i] = this.dataType.convertToType(session, arra[i], otherComponent);
        }
        return arrb;
    }

    public Object convertJavaToSQL(SessionInterface session, Object a) {
        Object[] data;
        boolean convert = false;
        if (a == null) {
            return null;
        }
        if (a instanceof Object[]) {
            data = (Object[])a;
            convert = true;
        } else if (a instanceof JDBCArray) {
            data = ((JDBCArray)a).getArrayInternal();
        } else if (a instanceof JDBCArrayBasic) {
            data = (Object[])((JDBCArrayBasic)a).getArray();
            convert = true;
        } else if (a instanceof Array) {
            try {
                data = (Object[])((Array)a).getArray();
                convert = true;
            }
            catch (Exception e) {
                throw Error.error(5561);
            }
        } else {
            throw Error.error(5561);
        }
        if (convert) {
            Object[] array = new Object[data.length];
            for (int i = 0; i < data.length; ++i) {
                array[i] = this.dataType.convertJavaToSQL(session, data[i]);
            }
            return array;
        }
        return data;
    }

    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a instanceof Object[]) {
            Object[] data = (Object[])a;
            return new JDBCArray(data, this.collectionBaseType(), (Type)this, session);
        }
        throw Error.error(5561);
    }

    public Object convertToDefaultType(SessionInterface sessionInterface, Object o) {
        return o;
    }

    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return this.convertToSQLString(a);
    }

    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        Object[] arra = (Object[])a;
        StringBuffer sb = new StringBuffer();
        sb.append("ARRAY");
        sb.append('[');
        for (int i = 0; i < arra.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.dataType.convertToSQLString(arra[i]));
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean canConvertFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        if (!otherType.isArrayType()) {
            return false;
        }
        Type otherComponent = otherType.collectionBaseType();
        return this.dataType.canConvertFrom(otherComponent);
    }

    public int canMoveFrom(Type otherType) {
        if (otherType == this) {
            return 0;
        }
        if (!otherType.isArrayType()) {
            return -1;
        }
        if (this.maxCardinality >= ((ArrayType)otherType).maxCardinality) {
            return this.dataType.canMoveFrom((ArrayType)otherType);
        }
        if (this.dataType.canMoveFrom((ArrayType)otherType) == -1) {
            return -1;
        }
        return 1;
    }

    public boolean canBeAssignedFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        Type otherComponent = otherType.collectionBaseType();
        return otherComponent != null && this.dataType.canBeAssignedFrom(otherComponent);
    }

    public Type collectionBaseType() {
        return this.dataType;
    }

    public int arrayLimitCardinality() {
        return this.maxCardinality;
    }

    public boolean isArrayType() {
        return true;
    }

    public Type getAggregateType(Type otherType) {
        if (otherType == null) {
            return this;
        }
        if (!otherType.isArrayType()) {
            throw Error.error(5562);
        }
        Type otherComponent = otherType.collectionBaseType();
        if (this.dataType.equals(otherComponent)) {
            return this;
        }
        Type newType = this.dataType.getAggregateType(otherComponent);
        return new ArrayType(newType, this.maxCardinality);
    }

    public Type getCombinedType(Type otherType, int operation) {
        if (operation != 36) {
            return this.getAggregateType(otherType);
        }
        if (otherType == null) {
            return this;
        }
        if (!otherType.isArrayType()) {
            throw Error.error(5562);
        }
        Type otherComponent = otherType.collectionBaseType();
        Type combinedType = this.dataType.getAggregateType(otherComponent);
        return new ArrayType(combinedType, this.maxCardinality + otherType.arrayLimitCardinality());
    }

    public int cardinality(Session session, Object a) {
        if (a == null) {
            return 0;
        }
        return ((Object[])a).length;
    }

    public Object concat(Session session, Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        int size = ((Object[])a).length + ((Object[])b).length;
        Object[] array = new Object[size];
        System.arraycopy(a, 0, array, 0, ((Object[])a).length);
        System.arraycopy(b, 0, array, ((Object[])a).length, ((Object[])b).length);
        return array;
    }

    public void sort(Session session, Object a, SortAndSlice sort) {
        Object[] array = (Object[])a;
        Type.TypedComparator comparator = session.getComparator();
        comparator.setType(this.dataType, sort);
        ArraySort.sort(array, 0, array.length, comparator);
    }

    public int deDuplicate(Session session, Object a, SortAndSlice sort) {
        Object[] array = (Object[])a;
        Type.TypedComparator comparator = session.getComparator();
        comparator.setType(this.dataType, sort);
        return ArraySort.deDuplicate(array, 0, array.length, comparator);
    }
}

