/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.tools;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.velocity.tools.view.tools.AbstractPagerTool;

public abstract class AbstractSearchTool
extends AbstractPagerTool {
    protected static final String STORED_RESULTS_KEY = StoredResults.class.getName();
    private Object criteria;

    public void reset() {
        super.reset();
        this.criteria = null;
    }

    public void setCriteria(Object criteria) {
        this.criteria = criteria;
    }

    public Object getCriteria() {
        return this.criteria;
    }

    public boolean hasResults() {
        return this.hasItems();
    }

    public List getResults() {
        return this.getItems();
    }

    public List getItems() {
        if (this.criteria == null) {
            return Collections.EMPTY_LIST;
        }
        List list = super.getItems();
        if (list.isEmpty()) {
            list = this.executeQuery(this.criteria);
            if (list == null) {
                list = Collections.EMPTY_LIST;
            }
            this.setItems(list);
        }
        return list;
    }

    protected List getStoredItems() {
        StoredResults sr = this.getStoredResults();
        if (sr != null && this.criteria.equals(sr.getCriteria())) {
            return sr.getList();
        }
        return null;
    }

    protected void setStoredItems(List items) {
        this.setStoredResults(new StoredResults(this.criteria, items));
    }

    protected abstract List executeQuery(Object var1);

    protected StoredResults getStoredResults() {
        if (this.session != null) {
            return (StoredResults)this.session.getAttribute(STORED_RESULTS_KEY);
        }
        return null;
    }

    protected void setStoredResults(StoredResults results) {
        if (this.session != null) {
            this.session.setAttribute(STORED_RESULTS_KEY, (Object)results);
        }
    }

    public class StoredResults
    implements Serializable {
        private static final long serialVersionUID = 4503130168585978169L;
        private transient Object crit;
        private transient List list;

        public StoredResults(Object crit, List list) {
            this.crit = crit;
            this.list = list;
        }

        public Object getCriteria() {
            return this.crit;
        }

        public List getList() {
            return this.list;
        }
    }
}

