/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.portal.kernel.io.AnnotatedObjectInputStream;
import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.util.CharBufferPool;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import com.liferay.portal.kernel.util.ClassResolverUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Deserializer {
    protected byte[] buffer;
    protected int index;
    protected int limit;

    public Deserializer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.array();
        this.index = byteBuffer.arrayOffset();
        this.limit = this.index + byteBuffer.remaining();
    }

    public boolean readBoolean() {
        this.detectBufferUnderflow(1);
        return BigEndianCodec.getBoolean(this.buffer, this.index++);
    }

    public byte readByte() {
        this.detectBufferUnderflow(1);
        return this.buffer[this.index++];
    }

    public char readChar() {
        this.detectBufferUnderflow(2);
        char c = BigEndianCodec.getChar(this.buffer, this.index);
        this.index += 2;
        return c;
    }

    public double readDouble() {
        this.detectBufferUnderflow(8);
        double d = BigEndianCodec.getDouble(this.buffer, this.index);
        this.index += 8;
        return d;
    }

    public float readFloat() {
        this.detectBufferUnderflow(4);
        float f = BigEndianCodec.getFloat(this.buffer, this.index);
        this.index += 4;
        return f;
    }

    public int readInt() {
        this.detectBufferUnderflow(4);
        int i = BigEndianCodec.getInt(this.buffer, this.index);
        this.index += 4;
        return i;
    }

    public long readLong() {
        this.detectBufferUnderflow(8);
        long l = BigEndianCodec.getLong(this.buffer, this.index);
        this.index += 8;
        return l;
    }

    public <T extends Serializable> T readObject() throws ClassNotFoundException {
        byte tcByte = this.buffer[this.index++];
        switch (tcByte) {
            case 0: {
                return (T)Boolean.valueOf(this.readBoolean());
            }
            case 1: {
                return (T)Byte.valueOf(this.readByte());
            }
            case 2: {
                return (T)Character.valueOf(this.readChar());
            }
            case 3: {
                String contextName = this.readString();
                String className = this.readString();
                ClassLoader classLoader = ClassLoaderPool.getClassLoader(contextName);
                return (T)ClassResolverUtil.resolve(className, classLoader);
            }
            case 4: {
                return (T)Double.valueOf(this.readDouble());
            }
            case 5: {
                return (T)Float.valueOf(this.readFloat());
            }
            case 6: {
                return (T)Integer.valueOf(this.readInt());
            }
            case 7: {
                return (T)Long.valueOf(this.readLong());
            }
            case 8: {
                return null;
            }
            case 10: {
                return (T)Short.valueOf(this.readShort());
            }
            case 11: {
                return (T)this.readString();
            }
            case 9: {
                try {
                    AnnotatedObjectInputStream objectInpputStream = new AnnotatedObjectInputStream(new BufferInputStream());
                    Serializable t = (Serializable)objectInpputStream.readObject();
                    objectInpputStream.close();
                    return (T)t;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
        throw new IllegalStateException("Unkown TC code " + tcByte);
    }

    public short readShort() {
        this.detectBufferUnderflow(2);
        short s = BigEndianCodec.getShort(this.buffer, this.index);
        this.index += 2;
        return s;
    }

    public String readString() {
        this.detectBufferUnderflow(5);
        boolean asciiCode = BigEndianCodec.getBoolean(this.buffer, this.index++);
        int length = BigEndianCodec.getInt(this.buffer, this.index);
        this.index += 4;
        if (asciiCode) {
            this.detectBufferUnderflow(length);
            char[] chars = CharBufferPool.borrow(length);
            int i = 0;
            while (i < length) {
                chars[i] = (char)this.buffer[this.index++];
                ++i;
            }
            return new String(chars, 0, length);
        }
        this.detectBufferUnderflow(length * 2);
        char[] chars = CharBufferPool.borrow(length);
        int i = 0;
        while (i < length) {
            chars[i] = BigEndianCodec.getChar(this.buffer, this.index);
            this.index += 2;
            ++i;
        }
        return new String(chars, 0, length);
    }

    protected final void detectBufferUnderflow(int availableBytes) {
        if (this.index + availableBytes > this.limit) {
            throw new IllegalStateException("Buffer underflow");
        }
    }

    protected class BufferInputStream
    extends InputStream {
        protected BufferInputStream() {
        }

        @Override
        public int read() {
            return Deserializer.this.buffer[Deserializer.this.index++];
        }

        @Override
        public int read(byte[] bytes) {
            return this.read(bytes, 0, bytes.length);
        }

        @Override
        public int read(byte[] bytes, int offset, int length) {
            int remain = Deserializer.this.limit - Deserializer.this.index;
            if (remain < length) {
                length = remain;
            }
            System.arraycopy(Deserializer.this.buffer, Deserializer.this.index, bytes, offset, length);
            Deserializer.this.index += length;
            return length;
        }
    }
}

