/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.cache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.cache.IntrabandPortalCache;
import com.liferay.portal.kernel.nio.intraband.cache.PortalCacheActionType;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IntrabandPortalCacheManager<K extends Serializable, V extends Serializable>
implements PortalCacheManager<K, V> {
    private static PortalCacheManager<? extends Serializable, ? extends Serializable> _portalCacheManager;
    private final Intraband _intraband;
    private final Map<String, PortalCache<K, V>> _portalCaches = new ConcurrentHashMap<String, PortalCache<K, V>>();
    private final RegistrationReference _registrationReference;

    public static <K extends Serializable, V extends Serializable> PortalCacheManager<K, V> getPortalCacheManager() {
        return _portalCacheManager;
    }

    public static void setPortalCacheManager(PortalCacheManager<? extends Serializable, ? extends Serializable> portalCacheManager) {
        _portalCacheManager = portalCacheManager;
    }

    public IntrabandPortalCacheManager(RegistrationReference registrationReference) {
        this._intraband = registrationReference.getIntraband();
        this._registrationReference = registrationReference;
    }

    @Override
    public void clearAll() {
        this._portalCaches.clear();
    }

    @Override
    public PortalCache<K, V> getCache(String name) {
        return this.getCache(name, false);
    }

    @Override
    public PortalCache<K, V> getCache(String name, boolean blocking) {
        PortalCache<K, V> portalCache = this._portalCaches.get(name);
        if (portalCache == null) {
            portalCache = new IntrabandPortalCache(name, this._registrationReference);
            this._portalCaches.put(name, portalCache);
        }
        return portalCache;
    }

    @Override
    public void reconfigureCaches(URL configurationURL) {
        Serializer serializer = new Serializer();
        serializer.writeInt(PortalCacheActionType.RECONFIGURE.ordinal());
        serializer.writeString(configurationURL.toExternalForm());
        SystemDataType systemDataType = SystemDataType.PORTAL_CACHE;
        this._intraband.sendDatagram(this._registrationReference, Datagram.createRequestDatagram(systemDataType.getValue(), serializer.toByteBuffer()));
    }

    @Override
    public void removeCache(String name) {
        this._portalCaches.remove(name);
    }
}

