/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassLoaderPool {
    private static Map<String, ClassLoader> _classLoaders = new ConcurrentHashMap<String, ClassLoader>();
    private static Map<ClassLoader, String> _contextNames = new ConcurrentHashMap<ClassLoader, String>();

    public static ClassLoader getClassLoader(String contextName) {
        PortalRuntimePermission.checkGetBeanProperty(ClassLoaderPool.class);
        ClassLoader classLoader = _classLoaders.get(contextName);
        if (classLoader == null) {
            classLoader = PortalClassLoaderUtil.getClassLoader();
        }
        if (classLoader == null) {
            Thread currentThread = Thread.currentThread();
            classLoader = currentThread.getContextClassLoader();
        }
        return classLoader;
    }

    public static String getContextName(ClassLoader classLoader) {
        if (classLoader == null) {
            return "";
        }
        String contextName = _contextNames.get(classLoader);
        if (contextName == null) {
            contextName = "";
        }
        return contextName;
    }

    public static void register(String contextName, ClassLoader classLoader) {
        PortalRuntimePermission.checkGetBeanProperty(ClassLoaderPool.class);
        _classLoaders.put(contextName, classLoader);
        _contextNames.put(classLoader, contextName);
    }

    public static void unregister(ClassLoader classLoader) {
        PortalRuntimePermission.checkGetBeanProperty(ClassLoaderPool.class);
        String contextName = _contextNames.remove(classLoader);
        if (contextName != null) {
            _classLoaders.remove(contextName);
        }
    }

    public static void unregister(String contextName) {
        PortalRuntimePermission.checkGetBeanProperty(ClassLoaderPool.class);
        ClassLoader classLoader = _classLoaders.remove(contextName);
        if (classLoader != null) {
            _contextNames.remove(classLoader);
        }
    }
}

