/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.util.comparator;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.shopping.model.ShoppingItem;

public class ItemMinQuantityComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "ShoppingItem.categoryId ASC, ShoppingItem.minQuantity ASC, ShoppingItem.name ASC";
    public static final String ORDER_BY_DESC = "ShoppingItem.categoryId DESC, ShoppingItem.minQuantity DESC, ShoppingItem.name DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"categoryId", "minQuantity", "name"};
    private boolean _ascending;

    public ItemMinQuantityComparator() {
        this(false);
    }

    public ItemMinQuantityComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        Long categoryId2;
        ShoppingItem item1 = (ShoppingItem)obj1;
        ShoppingItem item2 = (ShoppingItem)obj2;
        Long categoryId1 = new Long(item1.getCategoryId());
        int value = categoryId1.compareTo(categoryId2 = new Long(item2.getCategoryId()));
        if (value == 0) {
            if (item1.getMinQuantity() < item2.getMinQuantity()) {
                value = -1;
            } else if (item1.getMinQuantity() > item2.getMinQuantity()) {
                value = 1;
            }
        }
        if (value == 0) {
            String name1 = StringUtil.toLowerCase(item1.getName());
            String name2 = StringUtil.toLowerCase(item2.getName());
            value = name1.compareTo(name2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

