/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.ExchangeInfo;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.handlers.ChatNavListener;
import org.walluck.oscar.handlers.MiscHandler;
import org.walluck.oscar.handlers.SNACHandler;

public class ChatNavHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$oscar$handlers$ChatNavHandler == null ? (class$org$walluck$oscar$handlers$ChatNavHandler = ChatNavHandler.class$("org.walluck.oscar.handlers.ChatNavHandler")) : class$org$walluck$oscar$handlers$ChatNavHandler).getName());
    static /* synthetic */ Class class$org$walluck$oscar$handlers$ChatNavHandler;

    public ChatNavHandler() {
        this.setFamily(13);
        this.setVersion(1);
    }

    public void reqRights(AIMSession sess, AIMConnection conn) throws IOException {
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNullSnacID(sess, conn, 13, 2);
    }

    public void createRoom(AIMSession sess, AIMConnection conn, String name, int exchange) throws IOException {
        String ck = "create";
        String lang = "en";
        String charset = "us-ascii";
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(13, 8, 0, null, true);
        TLVChain tlvchain = new TLVChain(3);
        tlvchain.addString(211, name);
        tlvchain.addString(214, charset);
        tlvchain.addString(215, lang);
        AIMOutputStream buffer = new AIMOutputStream(3 + ck.length() + 2 + 1 + 2 + tlvchain.length());
        buffer.writeShort(exchange);
        buffer.writeStringL(ck);
        buffer.writeShort(65535);
        buffer.writeByte(1);
        buffer.writeShort(tlvchain.size());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void parseInfoPerms(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer, SNAC snac2) throws IOException {
        byte maxrooms = 0;
        TLVChain tlvchain = buffer.readTLVChain();
        ArrayList<ExchangeInfo> exchanges = new ArrayList<ExchangeInfo>();
        TLV tlv = tlvchain.getTLV(2, 1);
        if (tlv != null) {
            maxrooms = tlv.getValueByte();
        }
        int curexchange = 0;
        while ((tlv = tlvchain.getTLV(3, curexchange + 1)) != null) {
            AIMInputStream buffer2 = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
            ++curexchange;
            ExchangeInfo ei = new ExchangeInfo();
            ei.setNumber(buffer2.readShort());
            TLVChain tlvchain2 = buffer2.readTLVChain();
            tlv = tlvchain2.getTLV(10, 1);
            if (tlv != null) {
                LOG.warn((Object)("Unknown TLV type=0x" + Integer.toHexString(10) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
            }
            if ((tlv = tlvchain2.getTLV(13, 1)) != null) {
                LOG.warn((Object)("Unknown TLV type=0x" + Integer.toHexString(13) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
            }
            if ((tlv = tlvchain2.getTLV(4, 1)) != null) {
                LOG.warn((Object)("Unknown TLV type=0x" + Integer.toHexString(4) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
            }
            if ((tlv = tlvchain2.getTLV(2, 1)) != null) {
                short classperms = tlvchain.getTLV(2, 1).getValueShort();
                LOG.info((Object)("Class permissions " + Integer.toHexString(classperms)));
            }
            if ((tlv = tlvchain2.getTLV(205, 1)) != null) {
                ei.setFlags(tlv.getValueShort());
            }
            if ((tlv = tlvchain2.getTLV(202, 1)) != null) {
                LOG.warn((Object)("Unhandled TLV type=0x" + Integer.toHexString(202) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
            }
            if ((tlv = tlvchain2.getTLV(208, 1)) != null) {
                LOG.warn((Object)("Unhandled TLV type=0x" + Integer.toHexString(208) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
            }
            if ((tlv = tlvchain2.getTLV(209, 1)) != null) {
                LOG.warn((Object)("Unhandled TLV type=0x" + Integer.toHexString(209) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
            }
            if ((tlv = tlvchain2.getTLV(210, 1)) != null) {
                LOG.warn((Object)("Unhandled TLV type=0x" + Integer.toHexString(210) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
            }
            if ((tlv = tlvchain2.getTLV(211, 1)) != null) {
                ei.setName(tlv.getValueString());
            } else {
                ei.setName(null);
            }
            tlv = tlvchain2.getTLV(212, 1);
            if (tlv != null) {
                LOG.warn((Object)("Unhandled TLV type=0x" + Integer.toHexString(217) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
            }
            if ((tlv = tlvchain2.getTLV(213, 1)) != null) {
                byte createperms = tlv.getValueByte();
            }
            if ((tlv = tlvchain2.getTLV(214, 1)) != null) {
                ei.setCharset1(tlv.getValueString());
            } else {
                ei.setCharset1(null);
            }
            tlv = tlvchain2.getTLV(215, 1);
            if (tlv != null) {
                ei.setLang1(tlv.getValueString());
            } else {
                ei.setLang1(null);
            }
            tlv = tlvchain2.getTLV(216, 1);
            if (tlv != null) {
                ei.setCharset2(tlv.getValueString());
            } else {
                ei.setCharset2(null);
            }
            tlv = tlvchain2.getTLV(217, 1);
            if (tlv != null) {
                ei.setLang2(tlv.getValueString());
            } else {
                ei.setLang2(null);
            }
            tlv = tlvchain2.getTLV(218, 1);
            if (tlv != null) {
                LOG.warn((Object)("Unhandled TLV type=0x" + Integer.toHexString(218) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
            }
            exchanges.add(ei);
        }
        Iterator i = frame.getConn().getListeners(13, 9);
        while (i.hasNext()) {
            ((ChatNavListener)i.next()).parseInfoPerms(sess, frame, snac2.getSubtype(), maxrooms, curexchange, exchanges);
        }
    }

    private void parseInfoCreate(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer, SNAC snac2) throws IOException {
        TLVChain tlvchain = buffer.readTLVChain();
        TLV bigblock = null;
        bigblock = tlvchain.getTLV(4, 1);
        if (bigblock == null) {
            LOG.warn((Object)"No bigblock in top tlv in create room response");
            return;
        }
        AIMInputStream buffer2 = new AIMInputStream(new ByteArrayInputStream(bigblock.getValue()));
        short exchange = buffer2.readShort();
        String ck = buffer2.readStringL();
        short instance = buffer2.readShort();
        byte detaillevel = buffer2.readByte();
        if (detaillevel != 2) {
            LOG.warn((Object)("unknown detaillevel in create room response=0x" + Integer.toHexString(detaillevel)));
            return;
        }
        short unknown = buffer2.readShort();
        TLVChain tlvchain2 = buffer2.readTLVChain();
        String fqcn = null;
        TLV tlv = tlvchain2.getTLV(218, 1);
        if (tlv != null) {
            fqcn = tlv.getValueString();
        }
        short flags = 0;
        tlv = tlvchain2.getTLV(201, 1);
        if (tlv != null) {
            flags = tlv.getValueShort();
        }
        int createtime = 0;
        tlv = tlvchain2.getTLV(202, 1);
        if (tlv != null) {
            createtime = tlv.getValueInt();
        }
        short maxmsglen = 0;
        tlv = tlvchain2.getTLV(209, 1);
        if (tlv != null) {
            maxmsglen = tlv.getValueShort();
        }
        short maxoccupancy = 0;
        tlv = tlvchain2.getTLV(210, 1);
        if (tlv != null) {
            maxoccupancy = tlv.getValueShort();
        }
        String name = null;
        tlv = tlvchain2.getTLV(211, 1);
        if (tlv != null) {
            name = tlv.getValueString();
        }
        byte createperms = 0;
        tlv = tlvchain2.getTLV(213, 1);
        if (tlv != null) {
            createperms = tlv.getValueByte();
        }
        Iterator i = frame.getConn().getListeners(13, 9);
        while (i.hasNext()) {
            ((ChatNavListener)i.next()).parseInfoCreate(sess, frame, snac2.getSubtype(), fqcn, instance, exchange, flags, createtime, maxmsglen, maxoccupancy, createperms, unknown, name, ck);
        }
    }

    private void parseInfo(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        SNAC snac2 = frame.getConn().peekSNAC(snac.getId());
        if (snac2 == null) {
            LOG.error((Object)("parseInfo: received response to unknown request " + Integer.toHexString(snac.getId())));
            return;
        }
        frame.getConn().remSNAC(snac.getId());
        if (snac2.getFamily() != 13) {
            LOG.error((Object)("parseInfo: recieved response that maps to corrupt request (fam=" + Integer.toHexString(snac2.getFamily()) + ")"));
            return;
        }
        if (snac2.getSubtype() == 2) {
            this.parseInfoPerms(sess, handler, frame, snac, buffer, snac2);
        } else if (snac2.getSubtype() == 3) {
            LOG.debug((Object)"Response to exchange info");
        } else if (snac2.getSubtype() == 4) {
            LOG.debug((Object)"Response to room info");
        } else if (snac2.getSubtype() == 5) {
            LOG.debug((Object)"response to more room info");
        } else if (snac2.getSubtype() == 6) {
            LOG.debug((Object)"response to occupant info");
        } else if (snac2.getSubtype() == 7) {
            LOG.debug((Object)"search results");
        } else if (snac2.getSubtype() == 8) {
            this.parseInfoCreate(sess, handler, frame, snac, buffer, snac2);
        } else {
            LOG.warn((Object)("unknown request subtype=0x" + Integer.toHexString(snac2.getSubtype())));
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 9) {
            this.parseInfo(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

