/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.TDistribution;
import org.apache.commons.math.special.Beta;

public class TDistributionImpl
extends AbstractContinuousDistribution
implements TDistribution,
Serializable {
    private static final long serialVersionUID = -5852615386664158222L;
    private double degreesOfFreedom;

    public TDistributionImpl(double degreesOfFreedom) {
        this.setDegreesOfFreedom(degreesOfFreedom);
    }

    public void setDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("degrees of freedom must be positive ({0})", degreesOfFreedom);
        }
        this.degreesOfFreedom = degreesOfFreedom;
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public double cumulativeProbability(double x) throws MathException {
        double ret;
        if (x == 0.0) {
            ret = 0.5;
        } else {
            double t = Beta.regularizedBeta(this.getDegreesOfFreedom() / (this.getDegreesOfFreedom() + x * x), 0.5 * this.getDegreesOfFreedom(), 0.5);
            ret = x < 0.0 ? 0.5 * t : 1.0 - 0.5 * t;
        }
        return ret;
    }

    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    protected double getDomainLowerBound(double p) {
        return -1.7976931348623157E308;
    }

    protected double getDomainUpperBound(double p) {
        return Double.MAX_VALUE;
    }

    protected double getInitialDomain(double p) {
        return 0.0;
    }
}

