/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.util.Text;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHighlighter {
    public static final int DEFAULT_MAXFRAGMENTS = 3;
    public static final int DEFAULT_SURROUND = 75;
    public static final String START_EXCERPT = "<excerpt>";
    public static final String END_EXCERPT = "</excerpt>";
    public static final String START_FRAGMENT_SEPARATOR = "<fragment>";
    public static final String END_FRAGMENT_SEPARATOR = "</fragment>";
    public static final String START_HIGHLIGHT = "<highlight>";
    public static final String END_HIGHLIGHT = "</highlight>";

    protected DefaultHighlighter() {
    }

    public static String highlight(TermPositionVector tvec, Set<Term[]> queryTerms, String text, String excerptStart, String excerptEnd, String fragmentStart, String fragmentEnd, String hlStart, String hlEnd, int maxFragments, int surround) throws IOException {
        return new DefaultHighlighter().doHighlight(tvec, queryTerms, text, excerptStart, excerptEnd, fragmentStart, fragmentEnd, hlStart, hlEnd, maxFragments, surround);
    }

    public static String highlight(TermPositionVector tvec, Set<Term[]> queryTerms, String text, int maxFragments, int surround) throws IOException {
        return DefaultHighlighter.highlight(tvec, queryTerms, text, START_EXCERPT, END_EXCERPT, START_FRAGMENT_SEPARATOR, END_FRAGMENT_SEPARATOR, START_HIGHLIGHT, END_HIGHLIGHT, maxFragments, surround);
    }

    protected String doHighlight(TermPositionVector tvec, Set<Term[]> queryTerms, String text, String excerptStart, String excerptEnd, String fragmentStart, String fragmentEnd, String hlStart, String hlEnd, int maxFragments, int surround) throws IOException {
        ArrayList termOffsetInfo = new ArrayList();
        for (Term[] qt : queryTerms) {
            TermVectorOffsetInfo[] termoffsets;
            int qtLen = qt.length;
            if (qt == null || qtLen == 0) continue;
            String[] qtText = new String[qtLen];
            for (int i = 0; i < qtLen; ++i) {
                qtText[i] = qt[i].text();
            }
            int[] tvecindexes = tvec.indexesOf(qtText, 0, qtText.length);
            HashMap<Integer, TermVectorOffsetInfo[]> localTermOffsetInfo = new HashMap<Integer, TermVectorOffsetInfo[]>();
            for (int tvecindex : tvecindexes) {
                termoffsets = tvec.getOffsets(tvecindex);
                if (termoffsets == null || termoffsets.length == 0) continue;
                localTermOffsetInfo.put(tvecindex, termoffsets);
            }
            if (tvecindexes.length <= 0 || tvecindexes[0] < 0) continue;
            ArrayList<TermVectorOffsetInfo> intervalTermOffsetInfo = new ArrayList<TermVectorOffsetInfo>();
            TermVectorOffsetInfo[] firstKeyTermOffsets = (TermVectorOffsetInfo[])localTermOffsetInfo.get(tvecindexes[0]);
            Arrays.sort(firstKeyTermOffsets, new TermVectorOffsetInfoSorter());
            intervalTermOffsetInfo.addAll(Arrays.asList(firstKeyTermOffsets));
            for (int i = 1; i < tvecindexes.length; ++i) {
                Integer key = tvecindexes[i];
                termoffsets = (TermVectorOffsetInfo[])localTermOffsetInfo.get(key);
                if (termoffsets == null) continue;
                Arrays.sort(termoffsets, new TermVectorOffsetInfoSorter());
                Iterator intervalIterator = intervalTermOffsetInfo.iterator();
                int index = 0;
                while (intervalIterator.hasNext()) {
                    TermVectorOffsetInfo intervalOI = (TermVectorOffsetInfo)intervalIterator.next();
                    if (index >= termoffsets.length) {
                        intervalIterator.remove();
                        continue;
                    }
                    boolean matchSearch = true;
                    boolean matchFound = false;
                    while (matchSearch) {
                        TermVectorOffsetInfo localOI = termoffsets[index];
                        int diff = localOI.getStartOffset() - intervalOI.getEndOffset();
                        if (diff == 1 || diff == 0) {
                            intervalOI.setEndOffset(localOI.getEndOffset());
                            matchSearch = false;
                            matchFound = true;
                        }
                        if (++index < termoffsets.length) continue;
                        matchSearch = false;
                    }
                    if (matchFound) continue;
                    --index;
                    intervalIterator.remove();
                }
            }
            termOffsetInfo.addAll(intervalTermOffsetInfo);
        }
        TermVectorOffsetInfo[] offsets = termOffsetInfo.toArray(new TermVectorOffsetInfo[termOffsetInfo.size()]);
        if (offsets != null && offsets.length > 1) {
            Arrays.sort(offsets, new TermVectorOffsetInfoSorter());
        }
        return this.mergeFragments(offsets, text, excerptStart, excerptEnd, fragmentStart, fragmentEnd, hlStart, hlEnd, maxFragments, surround);
    }

    protected String mergeFragments(TermVectorOffsetInfo[] offsets, String text, String excerptStart, String excerptEnd, String fragmentStart, String fragmentEnd, String hlStart, String hlEnd, int maxFragments, int surround) throws IOException {
        int skippedChars;
        char[] cbuf;
        int skip;
        int i;
        if (offsets == null || offsets.length == 0) {
            return this.createDefaultExcerpt(text, excerptStart, excerptEnd, fragmentStart, fragmentEnd, surround * 2);
        }
        int lastOffset = offsets.length;
        ArrayList<FragmentInfo> fragmentInfoList = new ArrayList<FragmentInfo>();
        if (offsets[0].getEndOffset() <= text.length()) {
            FragmentInfo fi = new FragmentInfo(offsets[0], surround * 2);
            for (i = 1; i < lastOffset && offsets[i].getEndOffset() <= text.length(); ++i) {
                if (fi.add(offsets[i])) continue;
                fragmentInfoList.add(fi);
                fi = new FragmentInfo(offsets[i], surround * 2);
            }
            fragmentInfoList.add(fi);
        }
        if (fragmentInfoList.isEmpty()) {
            return this.createDefaultExcerpt(text, excerptStart, excerptEnd, fragmentStart, fragmentEnd, surround * 2);
        }
        Collections.sort(fragmentInfoList, new FragmentInfoScoreSorter());
        ArrayList bestFragmentsList = new ArrayList();
        for (i = 0; i < Math.min(fragmentInfoList.size(), maxFragments); ++i) {
            bestFragmentsList.add(fragmentInfoList.get(i));
        }
        Collections.sort(bestFragmentsList, new FragmentInfoPositionSorter());
        StringReader reader = new StringReader(text);
        StringBuffer sb = new StringBuffer(excerptStart);
        int pos = 0;
        for (int i2 = 0; i2 < bestFragmentsList.size(); ++i2) {
            FragmentInfo fi = (FragmentInfo)bestFragmentsList.get(i2);
            fi.trim();
            int nextStart = fi.getStartOffset();
            skip = nextStart - pos;
            if (skip > surround * 2) {
                skip -= surround;
                if (i2 > 0) {
                    cbuf = new char[surround];
                    reader.read(cbuf, 0, surround);
                    for (skippedChars = 1; skippedChars < surround + 1 && !Character.isWhitespace(cbuf[surround - skippedChars]); ++skippedChars) {
                    }
                    pos += surround;
                    if (skippedChars > surround) {
                        skippedChars = surround;
                    }
                    sb.append(this.escape(new String(cbuf, 0, surround - skippedChars)));
                    sb.append(fragmentEnd);
                }
            }
            if (skip >= surround) {
                if (i2 > 0) {
                    skip -= surround;
                }
                reader.skip(skip);
                pos += skip;
            }
            cbuf = new char[nextStart - pos];
            int firstWhitespace = skippedChars = Math.max(cbuf.length - 1, 0);
            reader.read(cbuf, 0, nextStart - pos);
            pos += nextStart - pos;
            sb.append(fragmentStart);
            if (cbuf.length > 0) {
                while (skippedChars >= 0) {
                    if (Character.isWhitespace(cbuf[skippedChars])) {
                        firstWhitespace = skippedChars;
                        if (skippedChars - 1 >= 0 && cbuf[skippedChars - 1] == '.') {
                            ++skippedChars;
                            break;
                        }
                    }
                    --skippedChars;
                }
            }
            boolean sentenceStart = true;
            if (skippedChars == -1) {
                if (pos == cbuf.length) {
                    skippedChars = 0;
                } else {
                    sentenceStart = false;
                    skippedChars = firstWhitespace + 1;
                }
            }
            if (!sentenceStart) {
                sb.append("... ");
            }
            sb.append(this.escape(new String(cbuf, skippedChars, cbuf.length - skippedChars)));
            Iterator iter = fi.iterator();
            while (iter.hasNext()) {
                TermVectorOffsetInfo ti = (TermVectorOffsetInfo)iter.next();
                nextStart = ti.getStartOffset();
                if (nextStart - pos > 0) {
                    cbuf = new char[nextStart - pos];
                    int charsRead = reader.read(cbuf, 0, nextStart - pos);
                    pos += nextStart - pos;
                    sb.append(this.escape(new String(cbuf, 0, charsRead)));
                }
                sb.append(hlStart);
                nextStart = ti.getEndOffset();
                cbuf = new char[nextStart - pos];
                reader.read(cbuf, 0, nextStart - pos);
                pos += nextStart - pos;
                sb.append(this.escape(new String(cbuf)));
                sb.append(hlEnd);
            }
        }
        if (pos != 0) {
            boolean EOF;
            if (offsets.length > lastOffset) {
                surround = Math.min(offsets[lastOffset].getStartOffset() - pos, surround);
            }
            cbuf = new char[surround];
            skip = reader.read(cbuf, 0, surround);
            boolean bl = EOF = reader.read() == -1;
            if (skip >= 0) {
                char lastChar;
                if (!EOF) {
                    for (skippedChars = 1; skippedChars < surround + 1 && !Character.isWhitespace(cbuf[surround - skippedChars]); ++skippedChars) {
                    }
                    if (skippedChars > surround) {
                        skippedChars = surround;
                    }
                } else {
                    skippedChars = 0;
                }
                sb.append(this.escape(new String(cbuf, 0, EOF ? skip : surround - skippedChars)));
                if (!EOF && (lastChar = sb.charAt(sb.length() - 1)) != '.' && lastChar != '!' && lastChar != '?') {
                    sb.append(" ...");
                }
            }
            sb.append(fragmentEnd);
        }
        sb.append(excerptEnd);
        return sb.toString();
    }

    protected String createDefaultExcerpt(String text, String excerptStart, String excerptEnd, String fragmentStart, String fragmentEnd, int maxLength) throws IOException {
        StringReader reader = new StringReader(text);
        StringBuffer excerpt = new StringBuffer(excerptStart);
        excerpt.append(fragmentStart);
        int min = excerpt.length();
        char[] buf = new char[maxLength];
        int len = reader.read(buf);
        StringBuffer tmp = new StringBuffer();
        tmp.append(buf, 0, len);
        if (len == buf.length) {
            for (int i = tmp.length() - 1; i > min; --i) {
                if (!Character.isWhitespace(tmp.charAt(i))) continue;
                tmp.delete(i, tmp.length());
                tmp.append(" ...");
                break;
            }
        }
        excerpt.append(this.escape(tmp.toString()));
        excerpt.append(fragmentEnd).append(excerptEnd);
        return excerpt.toString();
    }

    protected String escape(String input) {
        return Text.encodeIllegalXMLCharacters((String)input);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TermVectorOffsetInfoSorter
    implements Comparator<TermVectorOffsetInfo> {
        private TermVectorOffsetInfoSorter() {
        }

        @Override
        public int compare(TermVectorOffsetInfo o1, TermVectorOffsetInfo o2) {
            int s2;
            int s1 = o1.getStartOffset();
            if (s1 == (s2 = o2.getStartOffset())) {
                return 0;
            }
            return s1 < s2 ? -1 : 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FragmentInfoPositionSorter
    implements Comparator<FragmentInfo> {
        private FragmentInfoPositionSorter() {
        }

        @Override
        public int compare(FragmentInfo o1, FragmentInfo o2) {
            int s2;
            int s1 = o1.getStartOffset();
            if (s1 == (s2 = o2.getStartOffset())) {
                return 0;
            }
            return s1 < s2 ? -1 : 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FragmentInfoScoreSorter
    implements Comparator<FragmentInfo> {
        private FragmentInfoScoreSorter() {
        }

        @Override
        public int compare(FragmentInfo o1, FragmentInfo o2) {
            int s2;
            int s1 = o1.numTerms();
            if (s1 == (s2 = o2.numTerms())) {
                return o1.getStartOffset() < o2.getStartOffset() ? -1 : 1;
            }
            return s1 > s2 ? -1 : 1;
        }
    }

    private static class FragmentInfo {
        List<TermVectorOffsetInfo> offsetInfosList = new ArrayList<TermVectorOffsetInfo>();
        int startOffset;
        int endOffset;
        int mergeGap;
        int numTerms;

        public FragmentInfo(TermVectorOffsetInfo offsetinfo, int mergeGap) {
            this.offsetInfosList.add(offsetinfo);
            this.startOffset = offsetinfo.getStartOffset();
            this.endOffset = offsetinfo.getEndOffset();
            this.mergeGap = mergeGap;
            this.numTerms = 1;
        }

        public boolean add(TermVectorOffsetInfo offsetinfo) {
            if (offsetinfo.getStartOffset() > this.endOffset + this.mergeGap) {
                return false;
            }
            this.offsetInfosList.add(offsetinfo);
            ++this.numTerms;
            this.endOffset = offsetinfo.getEndOffset();
            return true;
        }

        public Iterator iterator() {
            return this.offsetInfosList.iterator();
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int numTerms() {
            return this.numTerms;
        }

        public void trim() {
            int end = this.startOffset + this.mergeGap / 2;
            Iterator<TermVectorOffsetInfo> it = this.offsetInfosList.iterator();
            while (it.hasNext()) {
                TermVectorOffsetInfo tvoi = it.next();
                if (tvoi.getStartOffset() <= end) continue;
                it.remove();
            }
        }
    }
}

