/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.join.AbstractCondition;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquiJoin
extends AbstractCondition {
    private final IndexReader reader;
    private final Map<String, List<ScoreNode[]>> rowsByInnerNodeValue = new HashMap<String, List<ScoreNode[]>>();
    private final Map<Integer, Set<String>> valuesByOuterNodeDocument = new HashMap<Integer, Set<String>>();

    public EquiJoin(MultiColumnQueryHits inner, int innerScoreNodeIndex, NamespaceMappings nsMappings, IndexReader reader, Name innerProperty, Name outerProperty) throws IOException, IllegalNameException {
        super(inner);
        this.reader = reader;
        HashMap<Integer, ArrayList<ScoreNode[]>> rowsByInnerDocument = new HashMap<Integer, ArrayList<ScoreNode[]>>();
        ScoreNode[] row = inner.nextScoreNodes();
        while (row != null) {
            int document = row[innerScoreNodeIndex].getDoc(reader);
            ArrayList<ScoreNode[]> rows = (ArrayList<ScoreNode[]>)rowsByInnerDocument.get(document);
            if (rows == null) {
                rows = new ArrayList<ScoreNode[]>();
                rowsByInnerDocument.put(document, rows);
            }
            rows.add(row);
            row = inner.nextScoreNodes();
        }
        String innerName = nsMappings.translateName(innerProperty);
        for (Map.Entry<Term, String> entry : this.getPropertyTerms(innerName)) {
            String value = entry.getValue();
            TermDocs docs = reader.termDocs(entry.getKey());
            while (docs.next()) {
                List match = (List)rowsByInnerDocument.get(docs.doc());
                if (match == null) continue;
                List<ScoreNode[]> rows = this.rowsByInnerNodeValue.get(value);
                if (rows == null) {
                    rows = new ArrayList<ScoreNode[]>();
                    this.rowsByInnerNodeValue.put(value, rows);
                }
                rows.addAll(match);
            }
        }
        String outerName = nsMappings.translateName(outerProperty);
        for (Map.Entry<Term, String> entry : this.getPropertyTerms(outerName)) {
            String value = entry.getValue();
            TermDocs docs = reader.termDocs(entry.getKey());
            while (docs.next()) {
                Set<String> values = this.valuesByOuterNodeDocument.get(docs.doc());
                if (values == null) {
                    values = new HashSet<String>();
                    this.valuesByOuterNodeDocument.put(docs.doc(), values);
                }
                values.add(value);
            }
        }
    }

    @Override
    public ScoreNode[][] getMatchingScoreNodes(ScoreNode outer) throws IOException {
        ArrayList<ScoreNode[]> list = new ArrayList<ScoreNode[]>();
        Set<String> values = this.valuesByOuterNodeDocument.get(outer.getDoc(this.reader));
        if (values != null) {
            for (String value : values) {
                List<ScoreNode[]> rows = this.rowsByInnerNodeValue.get(value);
                if (rows == null) continue;
                list.addAll(rows);
            }
        }
        return (ScoreNode[][])list.toArray((T[])new ScoreNode[list.size()][]);
    }

    private Set<Map.Entry<Term, String>> getPropertyTerms(String property) throws IOException {
        Term term;
        HashMap<Term, String> map = new HashMap<Term, String>();
        Term prefix = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(property, ""));
        TermEnum terms = this.reader.terms(prefix);
        while ((term = terms.term()) != null && term.field().equals(prefix.field()) && term.text().startsWith(prefix.text())) {
            map.put(term, term.text().substring(prefix.text().length()));
            if (terms.next()) continue;
        }
        return map.entrySet();
    }
}

