/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.request;

import org.gcube.smartgears.handlers.application.request.RequestException;

public enum RequestError {
    application_failed_error(410, "this resource is not currently available"),
    application_unavailable_error(503, "this resource is permanently available"),
    resource_notfound_error(404, "no gCube resource at this URI"),
    illegal_state_error(409, "this resource cannot assume the required state"),
    method_unsupported_error(405, "this resource does not support this method"),
    invalid_request_error(400, "this resource cannot process this request because it is malformed"),
    incoming_contenttype_unsupported_error(415, "this resource cannot consume this media type"),
    outgoing_contenttype_unsupported_error(406, "this resource cannot produce this media type"),
    application_error(500, "this resource has incurred in a generic error");

    private final int code;
    private final String msg;

    private RequestError(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.msg;
    }

    public void fire() {
        throw this.toException();
    }

    public void fire(String msg) {
        throw this.toException(msg);
    }

    public void fire(Throwable cause) {
        throw this.toException(cause);
    }

    public void fire(String msg, Throwable cause) {
        throw this.toException(msg, cause);
    }

    public RequestException toException() {
        return new RequestException(this);
    }

    public RequestException toException(String msg) {
        return new RequestException(this, msg);
    }

    public RequestException toException(Throwable cause) {
        return new RequestException(this, cause);
    }

    public RequestException toException(String msg, Throwable cause) {
        return new RequestException(this, cause, msg);
    }
}

