/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.validator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.common.validator.Util;
import org.gcube.common.validator.ValidationError;
import org.gcube.common.validator.Validator;
import org.gcube.common.validator.annotations.FieldValidator;
import org.gcube.common.validator.annotations.IsValid;
import org.gcube.common.validator.annotations.ValidityChecker;
import org.gcube.common.validator.context.ValidatorContext;

public class DefaultValidator
implements Validator {
    @Override
    public List<ValidationError> validate(Object obj) {
        try {
            return this.validateObject(obj, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<ValidationError> validateObject(Object obj, Object parent) throws Exception {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Class<?> _clazz = obj.getClass();
        for (Field field : Util.getAllFields(_clazz)) {
            ValidatorContext context = new ValidatorContext(parent, field, obj);
            this.validateField(context);
            errors.addAll(context.errors());
        }
        return errors;
    }

    private void validateField(ValidatorContext context) throws Exception {
        Field field = context.field();
        field.setAccessible(true);
        Object object = context.value();
        for (Annotation annotation : field.getAnnotations()) {
            Object toCheck;
            Class<FieldValidator<?>> managedClass;
            FieldValidator<?> validator;
            if (!annotation.annotationType().isAnnotationPresent(ValidityChecker.class) || (validator = (managedClass = annotation.annotationType().getAnnotation(ValidityChecker.class).managed()).newInstance()).isValid(toCheck = field.get(object))) continue;
            context.addError(validator.getErrorSuffix());
        }
        if (field.isAnnotationPresent(IsValid.class) && field.get(object) != null) {
            if (field.getType().isArray()) {
                for (Object o : (Object[])field.get(object)) {
                    context.addErrors(this.validateObject(o, object));
                }
            } else if (field.get(object) instanceof Iterable) {
                for (Object t : (Iterable)field.get(object)) {
                    context.addErrors(this.validateObject(t, object));
                }
            } else if (field.get(object) instanceof Map) {
                for (Map.Entry entry : ((Map)field.get(object)).entrySet()) {
                    context.addErrors(this.validateObject(entry.getValue(), object));
                }
            } else if (!field.getType().isPrimitive()) {
                context.addErrors(this.validateObject(field.get(object), object));
            }
        }
    }
}

