/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.BundleSupport;
import org.apache.taglibs.standard.tag.common.fmt.SetLocaleSupport;

public abstract class MessageSupport
extends BodyTagSupport {
    public static final String UNDEFINED_KEY = "???";
    protected String keyAttrValue;
    protected boolean keySpecified;
    protected LocalizationContext bundleAttrValue;
    protected boolean bundleSpecified;
    private String var;
    private int scope;
    private List params = new ArrayList();

    public MessageSupport() {
        this.init();
    }

    private void init() {
        this.var = null;
        this.scope = 1;
        this.keyAttrValue = null;
        this.keySpecified = false;
        this.bundleAttrValue = null;
        this.bundleSpecified = false;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    public void addParam(Object arg) {
        this.params.add(arg);
    }

    public int doStartTag() throws JspException {
        this.params.clear();
        return 2;
    }

    public int doEndTag() throws JspException {
        ResourceBundle bundle;
        String key = null;
        LocalizationContext locCtxt = null;
        if (this.keySpecified) {
            key = this.keyAttrValue;
        } else if (this.bodyContent != null && this.bodyContent.getString() != null) {
            key = this.bodyContent.getString().trim();
        }
        if (key == null || key.equals("")) {
            try {
                this.pageContext.getOut().print("??????");
            }
            catch (IOException ioe) {
                throw new JspTagException(ioe.toString(), (Throwable)ioe);
            }
            return 6;
        }
        String prefix = null;
        if (!this.bundleSpecified) {
            Tag t = MessageSupport.findAncestorWithClass((Tag)this, BundleSupport.class);
            if (t != null) {
                BundleSupport parent = (BundleSupport)t;
                locCtxt = parent.getLocalizationContext();
                prefix = parent.getPrefix();
            } else {
                locCtxt = BundleSupport.getLocalizationContext(this.pageContext);
            }
        } else {
            locCtxt = this.bundleAttrValue;
            if (locCtxt.getLocale() != null) {
                SetLocaleSupport.setResponseLocale(this.pageContext, locCtxt.getLocale());
            }
        }
        String message = UNDEFINED_KEY + key + UNDEFINED_KEY;
        if (locCtxt != null && (bundle = locCtxt.getResourceBundle()) != null) {
            try {
                if (prefix != null) {
                    key = prefix + key;
                }
                message = bundle.getString(key);
                if (!this.params.isEmpty()) {
                    Object[] messageArgs = this.params.toArray();
                    MessageFormat formatter = new MessageFormat("");
                    if (locCtxt.getLocale() != null) {
                        formatter.setLocale(locCtxt.getLocale());
                    } else {
                        Locale locale = SetLocaleSupport.getFormattingLocale(this.pageContext);
                        if (locale != null) {
                            formatter.setLocale(locale);
                        }
                    }
                    formatter.applyPattern(message);
                    message = formatter.format(messageArgs);
                }
            }
            catch (MissingResourceException mre) {
                message = UNDEFINED_KEY + key + UNDEFINED_KEY;
            }
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)message, this.scope);
        } else {
            try {
                this.pageContext.getOut().print(message);
            }
            catch (IOException ioe) {
                throw new JspTagException(ioe.toString(), (Throwable)ioe);
            }
        }
        return 6;
    }

    public void release() {
        this.init();
    }
}

