/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.Record;

public class FallbackPersistenceBackend
extends PersistenceBackend {
    private File fallbackFile;

    protected File getFallbackFile() {
        return this.fallbackFile;
    }

    protected FallbackPersistenceBackend(File fallbackFile) {
        super(null);
        this.fallbackFile = fallbackFile;
    }

    @Override
    public void prepareConnection(PersistenceBackendConfiguration configuration) {
    }

    @Override
    protected void reallyAccount(Record record) throws Exception {
        this.printLine(String.valueOf(record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLine(String line) throws Exception {
        File file = this.fallbackFile;
        synchronized (file) {
            try (FileWriter fw = new FileWriter(this.fallbackFile, true);
                 BufferedWriter bw = new BufferedWriter(fw);
                 PrintWriter out = new PrintWriter(bw);){
                out.println(line);
                out.flush();
            }
        }
    }

    @Override
    public void close() throws Exception {
    }
}

