/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.events.Hub;
import org.gcube.common.events.impl.DefaultHub;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.application.ApplicationConfigurationBinder;
import org.gcube.smartgears.configuration.application.ApplicationExtensions;
import org.gcube.smartgears.configuration.application.ApplicationHandlers;
import org.gcube.smartgears.configuration.application.BridgedApplicationConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfigurationBinder;
import org.gcube.smartgears.configuration.container.ContainerHandlers;
import org.gcube.smartgears.configuration.library.SmartGearsConfiguration;
import org.gcube.smartgears.configuration.library.SmartGearsConfigurationBinder;
import org.gcube.smartgears.context.Properties;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.application.DefaultApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.context.container.DefaultContainerContext;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.persistence.DefaultPersistence;
import org.gcube.smartgears.provider.OfflinePublisher;
import org.gcube.smartgears.provider.Provider;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProvider
implements Provider {
    private static Logger log = LoggerFactory.getLogger(Provider.class);
    private ContainerContext containerContext;

    protected DefaultProvider() {
    }

    @Override
    public ContainerContext containerContext() {
        if (this.containerContext == null) {
            ContainerConfiguration configuration = this.containerConfiguration();
            if (configuration.persistence() == null) {
                String location = Utils.home() + "/state";
                File dir = new File(location);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                configuration.persistence(new DefaultPersistence(location));
                log.trace("setting persistence location for container @ {}", (Object)dir.getAbsolutePath());
            }
            DefaultHub hub = new DefaultHub();
            ContainerLifecycle lifecycle = new ContainerLifecycle((Hub)hub);
            File file = configuration.persistence().file("ghn.xml");
            String id = null;
            List tokens = null;
            if (file.exists()) {
                log.info("loading persisted state for container");
                try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
                    id = (String)ois.readObject();
                    tokens = (List)ois.readObject();
                }
                catch (Exception e) {
                    log.error("error loading persisted state, creating new uuid", (Throwable)e);
                }
            }
            if (id == null) {
                id = UUID.randomUUID().toString();
                log.info("container id created is {}", (Object)id);
            }
            if (tokens != null) {
                configuration.startTokens(tokens);
            }
            this.containerContext = new DefaultContainerContext(id, configuration, (Hub)hub, lifecycle, new Properties());
        }
        return this.containerContext;
    }

    @Override
    public ContainerHandlers containerHandlers() {
        try {
            InputStream config = this.getClass().getResourceAsStream("/META-INF/container-handlers.xml");
            if (config == null) {
                throw new IllegalStateException("invalid distribution: cannot find /META-INF/container-handlers.xml");
            }
            ContainerConfigurationBinder binder = new ContainerConfigurationBinder();
            return binder.bindHandlers(config);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("cannot install container handlers (see cause) ", e);
        }
    }

    @Override
    public ApplicationContext contextFor(ContainerContext context, ServletContext application) {
        ApplicationConfiguration configuration = null;
        ApplicationConfiguration embedded = this.configurationFor(application);
        ApplicationConfiguration external = context.configuration().app(application.getContextPath());
        if (embedded == null && external == null) {
            throw new AssertionError((Object)("application @ " + application.getContextPath() + " is not distributed with " + "/WEB-INF/gcube-app.xml" + " and there is no external configuration for it in " + "container.xml"));
        }
        if (embedded == null) {
            configuration = external;
            log.info("loaded  configuration for application " + configuration.name() + " from " + "container.xml");
        } else {
            configuration = embedded;
            if (external == null) {
                log.info("loaded configuration for application " + configuration.name() + " from " + "/WEB-INF/gcube-app.xml");
            } else {
                configuration.merge(external);
                log.info("loaded configuration for application " + configuration.name() + " from " + "/WEB-INF/gcube-app.xml" + " and " + "container.xml");
            }
        }
        BridgedApplicationConfiguration bridgedConfiguration = new BridgedApplicationConfiguration(context.configuration(), configuration);
        DefaultHub hub = new DefaultHub();
        ApplicationLifecycle lifecycle = new ApplicationLifecycle((Hub)hub, configuration.name());
        File file = bridgedConfiguration.persistence().file("endpoint.xml");
        String id = null;
        if (file.exists()) {
            log.info("loading persisted state for application {}", (Object)application.getContextPath());
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
                id = (String)ois.readObject();
            }
            catch (Exception e) {
                log.error("error loading persisted state, creating new uuid", (Throwable)e);
            }
        }
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        return new DefaultApplicationContext(id, context, application, bridgedConfiguration, (Hub)hub, lifecycle, new Properties());
    }

    @Override
    public ApplicationHandlers handlersFor(ApplicationContext context) {
        try {
            InputStream config = context.application().getResourceAsStream("/WEB-INF/gcube-handlers.xml");
            if (config == null) {
                log.trace("{} uses the default lifecycle as it does not include {}", (Object)context.name(), (Object)"/WEB-INF/gcube-handlers.xml");
                config = this.getClass().getResourceAsStream("/META-INF/default-handlers.xml");
                if (config == null) {
                    throw new IllegalStateException("invalid distribution: cannot find /META-INF/default-handlers.xml");
                }
            } else {
                log.info("{} uses a custom lifecycle @ {}", (Object)context.name(), (Object)"/WEB-INF/gcube-handlers.xml");
            }
            ApplicationConfigurationBinder binder = new ApplicationConfigurationBinder();
            return binder.bindHandlers(config);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("cannot install handlers for application @ " + context.name() + " (see cause) ", e);
        }
    }

    @Override
    public ApplicationExtensions extensionsFor(ApplicationContext context) {
        try {
            InputStream config = context.application().getResourceAsStream("/WEB-INF/gcube-extensions.xml");
            if (config == null) {
                log.trace("{} uses default extensions as it does not include {}", (Object)context.name(), (Object)"/WEB-INF/gcube-extensions.xml");
                config = this.getClass().getResourceAsStream("/META-INF/default-extensions.xml");
                if (config == null) {
                    throw new IllegalStateException("invalid distribution: cannot find /META-INF/default-extensions.xml");
                }
            } else {
                log.info("{} uses custom extensions @ {}", (Object)context.name(), (Object)"/WEB-INF/gcube-extensions.xml");
            }
            ApplicationConfigurationBinder binder = new ApplicationConfigurationBinder();
            return binder.bindExtensions(config);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("cannot install extensions for application @ " + context.name() + " (see cause) ", e);
        }
    }

    @Override
    public SmartGearsConfiguration smartgearsConfiguration() {
        try {
            InputStream config = this.getClass().getResourceAsStream("/META-INF/smartgears-config.xml");
            if (config == null) {
                throw new IllegalStateException("invalid distribution: cannot find /META-INF/smartgears-config.xml");
            }
            SmartGearsConfigurationBinder binder = new SmartGearsConfigurationBinder();
            SmartGearsConfiguration configuration = binder.bind(config);
            configuration.validate();
            return configuration;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("cannot read library configuration (see cause) ", e);
        }
    }

    private ApplicationConfiguration configurationFor(ServletContext application) {
        try {
            InputStream config = application.getResourceAsStream("/WEB-INF/gcube-app.xml");
            if (config == null) {
                return null;
            }
            ApplicationConfigurationBinder binder = new ApplicationConfigurationBinder();
            return binder.bind(config);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("invalid configuration (see cause)", e);
        }
    }

    private ContainerConfiguration containerConfiguration() {
        String home = Utils.home();
        if (home == null) {
            throw new IllegalStateException("invalid node configuration: the environment variable GHN_HOME or the system property ghn.home must be defined");
        }
        File homeDir = new File(home);
        if (!(homeDir.exists() && homeDir.isDirectory() && homeDir.canRead() && homeDir.canWrite())) {
            throw new IllegalStateException("invalid node configuration: home " + home + " does not exist or is not a directory or cannot be accessed in read/write mode");
        }
        File config = new File(homeDir, "container.xml");
        if (!config.exists() || !config.canRead()) {
            throw new IllegalStateException("invalid node configuration: file " + config.getAbsolutePath() + " does not exist or cannot be accessed");
        }
        log.trace("reading container configuration @ {} ", (Object)config.getAbsolutePath());
        ContainerConfigurationBinder binder = new ContainerConfigurationBinder();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(config);
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected exception reading container configuration file see cause)", e);
        }
        ContainerConfiguration configuration = binder.bind(stream);
        try {
            stream.close();
        }
        catch (Exception e) {
            log.warn("could not close stream when reading container configuration @ " + config.getAbsolutePath() + " (see cause)", (Throwable)e);
        }
        return configuration;
    }

    @Override
    public ScopedPublisher publisherFor(ContainerContext context) {
        return context.configuration().mode() == Mode.online ? RegistryPublisherFactory.scopedPublisher() : new OfflinePublisher();
    }

    @Override
    public ScopedPublisher publisherFor(ApplicationContext context) {
        return context.configuration().mode() == Mode.online ? RegistryPublisherFactory.scopedPublisher() : new OfflinePublisher();
    }

    @Override
    public AuthorizationProxy authorizationProxy() {
        return Constants.authorizationService();
    }
}

