/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core;

import com.couchbase.client.core.BucketClosedException;
import com.couchbase.client.core.RequestEvent;
import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.ServiceNotAvailableException;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.event.system.ConfigUpdatedEvent;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.BootstrapMessage;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.config.ConfigRequest;
import com.couchbase.client.core.message.dcp.DCPRequest;
import com.couchbase.client.core.message.internal.AddServiceRequest;
import com.couchbase.client.core.message.internal.RemoveServiceRequest;
import com.couchbase.client.core.message.internal.SignalFlush;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.query.QueryRequest;
import com.couchbase.client.core.message.search.SearchRequest;
import com.couchbase.client.core.message.view.ViewRequest;
import com.couchbase.client.core.node.CouchbaseNode;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.ConfigLocator;
import com.couchbase.client.core.node.locate.DCPLocator;
import com.couchbase.client.core.node.locate.KeyValueLocator;
import com.couchbase.client.core.node.locate.Locator;
import com.couchbase.client.core.node.locate.QueryLocator;
import com.couchbase.client.core.node.locate.SearchLocator;
import com.couchbase.client.core.node.locate.ViewLocator;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.deps.com.lmax.disruptor.EventHandler;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public class RequestHandler
implements EventHandler<RequestEvent> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(RequestHandler.class);
    private final Locator binaryLocator = new KeyValueLocator();
    private final Locator viewLocator = new ViewLocator();
    private final Locator queryLocator = new QueryLocator();
    private final Locator configLocator = new ConfigLocator();
    private final Locator dcpLocator = new DCPLocator();
    private final Locator searchLocator = new SearchLocator();
    private final CopyOnWriteArrayList<Node> nodes;
    private final CoreEnvironment environment;
    private final RingBuffer<ResponseEvent> responseBuffer;
    private final EventBus eventBus;
    private volatile ClusterConfig configuration;

    public RequestHandler(CoreEnvironment environment, Observable<ClusterConfig> configObservable, RingBuffer<ResponseEvent> responseBuffer) {
        this(new CopyOnWriteArrayList<Node>(), environment, configObservable, responseBuffer);
    }

    RequestHandler(CopyOnWriteArrayList<Node> nodes, CoreEnvironment environment, Observable<ClusterConfig> configObservable, RingBuffer<ResponseEvent> responseBuffer) {
        this.nodes = nodes;
        this.environment = environment;
        this.responseBuffer = responseBuffer;
        this.eventBus = environment.eventBus();
        this.configuration = null;
        configObservable.subscribe((Action1)new Action1<ClusterConfig>(){

            public void call(ClusterConfig config) {
                try {
                    LOGGER.debug("Got notified of a new configuration arriving.");
                    RequestHandler.this.configuration = config;
                    RequestHandler.this.reconfigure(config).subscribe();
                    if (RequestHandler.this.eventBus != null) {
                        RequestHandler.this.eventBus.publish(new ConfigUpdatedEvent(config));
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Error while subscribing to bucket config stream.", ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(RequestEvent event, long sequence, boolean endOfBatch) throws Exception {
        try {
            this.dispatchRequest(event.getRequest());
        }
        finally {
            event.setRequest(null);
            if (endOfBatch && this.nodes != null) {
                this.flush();
            }
        }
    }

    private void flush() {
        for (Node node : this.nodes) {
            node.send(SignalFlush.INSTANCE);
        }
    }

    private void dispatchRequest(CouchbaseRequest request) {
        ClusterConfig config = this.configuration;
        if (!(request instanceof BootstrapMessage)) {
            BucketConfig bucketConfig;
            BucketConfig bucketConfig2 = bucketConfig = config == null ? null : config.bucketConfig(request.bucket());
            if (config == null || request.bucket() != null && bucketConfig == null) {
                request.observable().onError((Throwable)new BucketClosedException(request.bucket() + " has been closed"));
                return;
            }
            try {
                this.checkFeaturesForRequest(request, bucketConfig);
            }
            catch (ServiceNotAvailableException e) {
                request.observable().onError((Throwable)e);
                return;
            }
        }
        this.locator(request).locateAndDispatch(request, this.nodes, config, this.environment, this.responseBuffer);
    }

    protected void checkFeaturesForRequest(CouchbaseRequest request, BucketConfig config) {
        if (request instanceof BinaryRequest && !config.serviceEnabled(ServiceType.BINARY)) {
            throw new ServiceNotAvailableException("The KeyValue service is not enabled or no node in the cluster supports it.");
        }
        if (request instanceof ViewRequest && !config.serviceEnabled(ServiceType.VIEW)) {
            throw new ServiceNotAvailableException("The View service is not enabled or no node in the cluster supports it.");
        }
        if (request instanceof QueryRequest && !this.environment.queryEnabled() && !config.serviceEnabled(ServiceType.QUERY)) {
            throw new ServiceNotAvailableException("The Query service is not enabled or no node in the cluster supports it.");
        }
        if (request instanceof SearchRequest && !config.serviceEnabled(ServiceType.SEARCH)) {
            throw new ServiceNotAvailableException("The Search service is not enabled or no node in the cluster supports it.");
        }
        if (request instanceof DCPRequest && !this.environment.dcpEnabled() && !config.serviceEnabled(ServiceType.DCP)) {
            throw new ServiceNotAvailableException("The DCP service is not enabled or no node in the cluster supports it.");
        }
    }

    public Observable<LifecycleState> addNode(InetAddress hostname) {
        Node node = this.nodeBy(hostname);
        if (node != null) {
            LOGGER.debug("Node {} already registered, skipping.", (Object)hostname);
            return Observable.just(node.state());
        }
        return this.addNode(new CouchbaseNode(hostname, this.environment, this.responseBuffer));
    }

    Observable<LifecycleState> addNode(final Node node) {
        LOGGER.debug("Got instructed to add Node {}", (Object)node.hostname());
        if (this.nodes.contains(node)) {
            LOGGER.debug("Node {} already registered, skipping.", (Object)node.hostname());
            return Observable.just(node.state());
        }
        LOGGER.debug("Connecting Node " + node.hostname());
        return node.connect().map((Func1)new Func1<LifecycleState, LifecycleState>(){

            public LifecycleState call(LifecycleState lifecycleState) {
                LOGGER.debug("Connect finished, registering for use.");
                RequestHandler.this.nodes.addIfAbsent(node);
                return lifecycleState;
            }
        });
    }

    public Observable<LifecycleState> removeNode(InetAddress hostname) {
        return this.removeNode(this.nodeBy(hostname));
    }

    Observable<LifecycleState> removeNode(Node node) {
        LOGGER.debug("Got instructed to remove Node {}", (Object)node.hostname());
        this.nodes.remove(node);
        return node.disconnect();
    }

    public Observable<Service> addService(AddServiceRequest request) {
        LOGGER.debug("Got instructed to add Service {}, to Node {}", (Object)request.type(), (Object)request.hostname());
        return this.nodeBy(request.hostname()).addService(request);
    }

    public Observable<Service> removeService(RemoveServiceRequest request) {
        LOGGER.debug("Got instructed to remove Service {}, from Node {}", (Object)request.type(), (Object)request.hostname());
        return this.nodeBy(request.hostname()).removeService(request);
    }

    public Node nodeBy(InetAddress hostname) {
        if (hostname == null) {
            return null;
        }
        for (Node node : this.nodes) {
            if (!node.hostname().equals(hostname)) continue;
            return node;
        }
        return null;
    }

    protected Locator locator(CouchbaseRequest request) {
        if (request instanceof BinaryRequest) {
            return this.binaryLocator;
        }
        if (request instanceof ViewRequest) {
            return this.viewLocator;
        }
        if (request instanceof QueryRequest) {
            return this.queryLocator;
        }
        if (request instanceof ConfigRequest) {
            return this.configLocator;
        }
        if (request instanceof DCPRequest) {
            return this.dcpLocator;
        }
        if (request instanceof SearchRequest) {
            return this.searchLocator;
        }
        throw new IllegalArgumentException("Unknown Request Type: " + request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Observable<ClusterConfig> reconfigure(final ClusterConfig config) {
        LOGGER.debug("Starting reconfiguration.");
        if (config.bucketConfigs().values().isEmpty()) {
            ArrayList<Node> snapshotNodes;
            LOGGER.debug("No open bucket found in config, disconnecting all nodes.");
            CopyOnWriteArrayList<Node> copyOnWriteArrayList = this.nodes;
            synchronized (copyOnWriteArrayList) {
                snapshotNodes = new ArrayList<Node>(this.nodes);
            }
            if (snapshotNodes.isEmpty()) {
                return Observable.just((Object)config);
            }
            return Observable.from(snapshotNodes).doOnNext((Action1)new Action1<Node>(){

                public void call(Node node) {
                    RequestHandler.this.removeNode(node);
                    node.disconnect().subscribe();
                }
            }).last().map((Func1)new Func1<Node, ClusterConfig>(){

                public ClusterConfig call(Node node) {
                    return config;
                }
            });
        }
        return Observable.just((Object)config).flatMap((Func1)new Func1<ClusterConfig, Observable<BucketConfig>>(){

            public Observable<BucketConfig> call(ClusterConfig clusterConfig) {
                return Observable.from(clusterConfig.bucketConfigs().values());
            }
        }).flatMap((Func1)new Func1<BucketConfig, Observable<Boolean>>(){

            public Observable<Boolean> call(BucketConfig bucketConfig) {
                return RequestHandler.this.reconfigureBucket(bucketConfig);
            }
        }).last().doOnNext((Action1)new Action1<Boolean>(){

            public void call(Boolean aBoolean) {
                HashSet<InetAddress> configNodes = new HashSet<InetAddress>();
                for (Map.Entry<String, BucketConfig> bucket : config.bucketConfigs().entrySet()) {
                    for (NodeInfo node : bucket.getValue().nodes()) {
                        configNodes.add(node.hostname());
                    }
                }
                for (Node node : RequestHandler.this.nodes) {
                    if (configNodes.contains(node.hostname())) continue;
                    LOGGER.debug("Removing and disconnecting node {}.", (Object)node.hostname());
                    RequestHandler.this.removeNode(node);
                    node.disconnect().subscribe();
                }
            }
        }).map((Func1)new Func1<Boolean, ClusterConfig>(){

            public ClusterConfig call(Boolean aBoolean) {
                return config;
            }
        });
    }

    private Observable<Boolean> reconfigureBucket(final BucketConfig config) {
        LOGGER.debug("Starting reconfiguration for bucket {}", (Object)config.name());
        ArrayList<Observable> observables = new ArrayList<Observable>();
        for (final NodeInfo nodeInfo : config.nodes()) {
            Observable obs = this.addNode(nodeInfo.hostname()).flatMap((Func1)new Func1<LifecycleState, Observable<Map<ServiceType, Integer>>>(){

                public Observable<Map<ServiceType, Integer>> call(LifecycleState lifecycleState) {
                    Map<ServiceType, Integer> services;
                    Map<ServiceType, Integer> map = services = RequestHandler.this.environment.sslEnabled() ? nodeInfo.sslServices() : nodeInfo.services();
                    if (!services.containsKey((Object)ServiceType.QUERY) && RequestHandler.this.environment.queryEnabled()) {
                        services.put(ServiceType.QUERY, RequestHandler.this.environment.queryPort());
                    }
                    if (services.containsKey((Object)ServiceType.BINARY) && RequestHandler.this.environment.dcpEnabled()) {
                        services.put(ServiceType.DCP, services.get((Object)ServiceType.BINARY));
                    }
                    return Observable.just(services);
                }
            }).flatMap((Func1)new Func1<Map<ServiceType, Integer>, Observable<AddServiceRequest>>(){

                public Observable<AddServiceRequest> call(Map<ServiceType, Integer> services) {
                    ArrayList<AddServiceRequest> requests = new ArrayList<AddServiceRequest>(services.size());
                    for (Map.Entry<ServiceType, Integer> service : services.entrySet()) {
                        requests.add(new AddServiceRequest(service.getKey(), config.name(), config.password(), service.getValue(), nodeInfo.hostname()));
                    }
                    return Observable.from(requests);
                }
            }).flatMap((Func1)new Func1<AddServiceRequest, Observable<Service>>(){

                public Observable<Service> call(AddServiceRequest request) {
                    return RequestHandler.this.addService(request);
                }
            }).last().map((Func1)new Func1<Service, Boolean>(){

                public Boolean call(Service service) {
                    return true;
                }
            });
            observables.add(obs);
        }
        return Observable.merge(observables).last();
    }
}

