/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.gcube.documentstore.persistence.DefaultPersitenceExecutor;
import org.gcube.documentstore.persistence.ExecutorUtils;
import org.gcube.documentstore.persistence.FallbackPersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.PersistenceBackendRediscover;
import org.gcube.documentstore.records.RecordUtility;
import org.gcube.documentstore.records.aggregation.AggregationScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistenceBackendFactory {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceBackendFactory.class);
    public static final String DEFAULT_CONTEXT = "DEFAULT_CONTEXT";
    public static final String HOME_SYSTEM_PROPERTY = "user.home";
    protected static final String FALLBACK_FILENAME = "fallback.log";
    private static String fallbackLocation;
    private static Map<String, PersistenceBackend> persistenceBackends;
    private static Map<String, Boolean> forceImmediateRediscoveries;
    public static final long INITIAL_DELAY = 1000L;
    public static final long FALLBACK_RETRY_TIME = 600000L;

    public static void forceImmediateRediscovery(String context) {
        forceImmediateRediscoveries.put(context, new Boolean(true));
    }

    public static Boolean getForceImmediateRediscovery(String context) {
        Boolean force = forceImmediateRediscoveries.get(context);
        if (force == null) {
            force = new Boolean(false);
        }
        return force;
    }

    public static void addRecordPackage(Package packageObject) {
        logger.trace("Package:{}", (Object)packageObject.toString());
        RecordUtility.addRecordPackage(packageObject);
    }

    private static File file(File file) throws IllegalArgumentException {
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static synchronized void setFallbackLocation(String path) {
        if (fallbackLocation == null) {
            if (path == null) {
                path = System.getProperty(HOME_SYSTEM_PROPERTY);
            }
            PersistenceBackendFactory.file(new File(path));
            fallbackLocation = path;
        }
    }

    protected static synchronized String getFallbackLocation() {
        if (fallbackLocation == null) {
            try {
                return System.getProperty(HOME_SYSTEM_PROPERTY);
            }
            catch (Exception e) {
                return ".";
            }
        }
        return fallbackLocation;
    }

    protected static String sanitizeContext(String context) {
        if (context == null || context.compareTo("") == 0) {
            return DEFAULT_CONTEXT;
        }
        return context;
    }

    protected static String removeSlashFromContext(String context) {
        return context.replace("/", "_");
    }

    public static File getFallbackFile(String context) {
        context = PersistenceBackendFactory.sanitizeContext(context);
        String slashLessContext = PersistenceBackendFactory.removeSlashFromContext(context);
        logger.trace("getFallbackFile location:" + PersistenceBackendFactory.getFallbackLocation() + " context:" + slashLessContext + "-" + FALLBACK_FILENAME);
        File fallbackFile = new File(PersistenceBackendFactory.getFallbackLocation(), String.format("%s.%s", slashLessContext, FALLBACK_FILENAME));
        return fallbackFile;
    }

    protected static FallbackPersistenceBackend createFallback(String context) {
        context = PersistenceBackendFactory.sanitizeContext(context);
        logger.debug("Creating {} for context {}", (Object)FallbackPersistenceBackend.class.getSimpleName(), (Object)context);
        File fallbackFile = PersistenceBackendFactory.getFallbackFile(context);
        logger.trace("{} for context {} is {}", new Object[]{FallbackPersistenceBackend.class.getSimpleName(), context, fallbackFile.getAbsolutePath()});
        FallbackPersistenceBackend fallbackPersistence = new FallbackPersistenceBackend(fallbackFile);
        return fallbackPersistence;
    }

    protected static PersistenceBackend discoverPersistenceBackend(String context, FallbackPersistenceBackend fallback) {
        context = PersistenceBackendFactory.sanitizeContext(context);
        logger.debug("Discovering {} for scope {}", (Object)PersistenceBackend.class.getSimpleName(), (Object)context);
        ServiceLoader<PersistenceBackend> serviceLoader = ServiceLoader.load(PersistenceBackend.class);
        logger.trace("discoverPersistenceBackend Found a service loader {}", (Object)serviceLoader.toString());
        logger.trace("discoverPersistenceBackend Found a service loader with {}", (Object)PersistenceBackend.class.toString());
        for (PersistenceBackend found : serviceLoader) {
            logger.trace("for PersistenceBackend");
            logger.trace("Testing before cast {}", (Object)found.toString());
            Class<?> foundClass = found.getClass();
            try {
                String foundClassName = foundClass.getSimpleName();
                logger.trace("Testing {}", (Object)foundClassName);
                PersistenceBackendConfiguration configuration = PersistenceBackendConfiguration.getInstance(foundClass);
                if (configuration == null) continue;
                found.prepareConnection(configuration);
                logger.trace("{} will be used.", (Object)foundClassName);
                found.setAggregationScheduler(AggregationScheduler.newInstance(new DefaultPersitenceExecutor(found)));
                if (fallback != null) {
                    found.setFallback(fallback);
                } else {
                    found.setFallback(PersistenceBackendFactory.createFallback(context));
                }
                return found;
            }
            catch (Exception e) {
                logger.error(String.format("%s not initialized correctly. It will not be used. Trying the next one if any.", foundClass.getSimpleName()), (Throwable)e);
            }
        }
        logger.trace("Not Found any service loader");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistenceBackend getPersistenceBackend(String context) {
        context = PersistenceBackendFactory.sanitizeContext(context);
        Boolean forceImmediateRediscovery = PersistenceBackendFactory.getForceImmediateRediscovery(context);
        PersistenceBackend persistence = null;
        logger.trace("Going to synchronized block in getPersistenceBackend");
        Map<String, PersistenceBackend> map = persistenceBackends;
        synchronized (map) {
            persistence = persistenceBackends.get(context);
            if (persistence == null) {
                logger.trace("[getPersistenceBackend]{} {} in context {}", new Object[]{PersistenceBackend.class.getSimpleName(), persistence, context});
                persistence = PersistenceBackendFactory.createFallback(context);
                persistenceBackends.put(context, persistence);
                if (forceImmediateRediscovery.booleanValue()) {
                    PersistenceBackend p = PersistenceBackendFactory.discoverPersistenceBackend(context, (FallbackPersistenceBackend)persistence);
                    if (p != null) {
                        persistence = p;
                        persistenceBackends.put(context, persistence);
                    }
                } else {
                    new PersistenceBackendRediscover(context, (FallbackPersistenceBackend)persistence, 1000L, 600000L, TimeUnit.MILLISECONDS);
                }
            }
        }
        return persistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PersistenceBackend switchPersistenceBackend(PersistenceBackend actual, PersistenceBackend target, String context) {
        Map<String, PersistenceBackend> map = persistenceBackends;
        synchronized (map) {
            persistenceBackends.put(context, target);
            try {
                actual.close();
            }
            catch (Exception e) {
                logger.error("Error closing {} for context {} which has been substituted reset to {}.", new Object[]{actual.getClass().getSimpleName(), context, target.getClass().getSimpleName(), e});
            }
            return target;
        }
    }

    protected static PersistenceBackend resetToFallbackPersistenceBackend(PersistenceBackend actual, String context) {
        context = PersistenceBackendFactory.sanitizeContext(context);
        logger.debug("The {} for context {} is {}. It will be switched to {}.", new Object[]{PersistenceBackend.class.getSimpleName(), context, actual.getClass().getSimpleName(), FallbackPersistenceBackend.class.getSimpleName()});
        if (actual != null && !(actual instanceof FallbackPersistenceBackend)) {
            FallbackPersistenceBackend fallbackPersistenceBackend = actual.getFallbackPersistence();
            PersistenceBackendFactory.switchPersistenceBackend(actual, fallbackPersistenceBackend, context);
        }
        return actual;
    }

    protected static PersistenceBackend rediscoverPersistenceBackend(FallbackPersistenceBackend actual, String context) {
        context = PersistenceBackendFactory.sanitizeContext(context);
        logger.debug("The {} for context {} is {}. Is time to rediscover if there is another possibility.", new Object[]{PersistenceBackend.class.getSimpleName(), context, actual.getClass().getSimpleName()});
        PersistenceBackend discoveredPersistenceBackend = PersistenceBackendFactory.discoverPersistenceBackend(context, actual);
        if (discoveredPersistenceBackend != null) {
            PersistenceBackendFactory.switchPersistenceBackend(actual, discoveredPersistenceBackend, context);
        }
        return actual;
    }

    @Deprecated
    public static void flush(String context, long timeout, TimeUnit timeUnit) {
        PersistenceBackendFactory.flush(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush(String context) {
        PersistenceBackend apb;
        context = PersistenceBackendFactory.sanitizeContext(context);
        Map<String, PersistenceBackend> map = persistenceBackends;
        synchronized (map) {
            apb = persistenceBackends.get(context);
        }
        try {
            logger.debug("Flushing records in context {}", (Object)context);
            apb.flush();
        }
        catch (Exception e) {
            logger.error("Unable to flush records in context {} with {}", new Object[]{context, apb, e});
        }
    }

    @Deprecated
    public static void flushAll(long timeout, TimeUnit timeUnit) {
        PersistenceBackendFactory.flushAll();
    }

    public static void flushAll() {
        for (String context : persistenceBackends.keySet()) {
            PersistenceBackendFactory.flush(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        for (String context : persistenceBackends.keySet()) {
            PersistenceBackend apb;
            context = PersistenceBackendFactory.sanitizeContext(context);
            Map<String, PersistenceBackend> map = persistenceBackends;
            synchronized (map) {
                apb = persistenceBackends.get(context);
            }
            try {
                logger.debug("Flushing records in context {}", (Object)context);
                apb.close();
            }
            catch (Exception e) {
                logger.error("Unable to flush records in context {} with {}", new Object[]{context, apb, e});
            }
        }
        ExecutorUtils.PERSISTENCE_BACKEND_REDISCOVERY_POOL.shutdown();
        try {
            ExecutorUtils.PERSISTENCE_BACKEND_REDISCOVERY_POOL.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Unable to shutdown the scheduler", (Throwable)e);
        }
        ExecutorUtils.CONFIGURATION_REDISCOVERY_POOL.shutdown();
        try {
            ExecutorUtils.CONFIGURATION_REDISCOVERY_POOL.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Unable to shutdown the threadPool", (Throwable)e);
        }
        ExecutorUtils.FUTURE_FLUSH_POOL.shutdown();
        try {
            ExecutorUtils.FUTURE_FLUSH_POOL.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Unable to shutdown the threadPool", (Throwable)e);
        }
        ExecutorUtils.FALLBACK_REDISCOVERY_POOL.shutdown();
        try {
            ExecutorUtils.FALLBACK_REDISCOVERY_POOL.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Unable to shutdown the threadPool", (Throwable)e);
        }
        ExecutorUtils.ASYNC_AGGREGATION_POOL.shutdown();
        try {
            ExecutorUtils.ASYNC_AGGREGATION_POOL.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Unable to shutdown the threadPool", (Throwable)e);
        }
    }

    static {
        persistenceBackends = new HashMap<String, PersistenceBackend>();
        forceImmediateRediscoveries = new HashMap<String, Boolean>();
    }
}

