/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.container.lifecycle;

import java.util.Collections;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.events.Observes;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.handlers.container.ContainerLifecycleEvent;
import org.gcube.smartgears.handlers.container.lifecycle.ProfileBuilder;
import org.gcube.smartgears.handlers.container.lifecycle.ProfilePublisher;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.lifecycle.container.ContainerState;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="profile-management")
public class ProfileManager
extends ContainerHandler {
    private static Logger log = LoggerFactory.getLogger(ProfileManager.class);
    private ContainerContext context;
    private ProfileBuilder builder;
    private ProfilePublisher publisher;
    private ScheduledFuture<?> periodicUpdates;

    @Override
    public void onStart(ContainerLifecycleEvent.Start e) {
        this.context = (ContainerContext)e.context();
        this.builder = new ProfileBuilder(this.context);
        this.activated();
    }

    private void activated() {
        HostingNode profile = this.loadOrCreateProfile();
        this.share(profile);
        this.publisher = new ProfilePublisher(this.context);
        this.registerObservers();
        this.schedulePeriodicUpdates();
    }

    private void registerObservers() {
        this.context.events().subscribe(new Object(){

            @Observes(value={"activation", "part_activation", "shutdown", "stop", "failure"})
            void onChanged(ContainerLifecycle lc) {
                HostingNode profile = ProfileManager.this.context.profile(HostingNode.class);
                profile.profile().description().status(((ContainerState)lc.state()).remoteForm());
                ProfileManager.this.context.events().fire((Object)profile, new String[]{"changed"});
            }

            @Observes(value={"published"})
            void shareAfterPublish(HostingNode profile) {
                ProfileManager.this.share(profile);
            }

            @Observes(value={"changed"}, kind=Observes.Kind.critical)
            void publishAfterChange(HostingNode profile) {
                log.info("Publish after profile Change event called");
                ProfileManager.this.publish(profile);
            }

            @Observes(value={"addToContext"})
            void addTo(String token) {
                try {
                    log.trace("publishing container with new token");
                    ProfileManager.this.publisher.addTo(Collections.singleton(token));
                    ProfileManager.this.publisher.update();
                }
                catch (Exception e) {
                    log.error("cannot add token {} (see details)", (Object)token, (Object)e);
                }
            }

            @Observes(value={"removeFromContext"})
            void removeFrom(String token) {
                try {
                    log.trace("unpublishing container with new token");
                    ProfileManager.this.publisher.removeFrom(Collections.singleton(token));
                    ProfileManager.this.publisher.update();
                }
                catch (Exception e) {
                    log.error("cannot remove token {} (see details)", (Object)token, (Object)e);
                }
            }
        });
    }

    private HostingNode loadOrCreateProfile() {
        return this.createProfile();
    }

    private void share(HostingNode profile) {
        log.trace("sharing container profile");
        this.context.properties().add(new Property("ghn-profile", profile));
    }

    private HostingNode createProfile() {
        log.info("creating container profile");
        try {
            HostingNode node = this.builder.create();
            node.setId(this.context.id());
            return node;
        }
        catch (Throwable e) {
            throw new RuntimeException("cannot create container profile", e);
        }
    }

    private void publish(HostingNode profile) {
        boolean firstPublication = profile.scopes().isEmpty();
        try {
            if (firstPublication) {
                this.publisher.addToAll();
            } else {
                this.publisher.update();
            }
        }
        catch (Exception e) {
            log.error("cannot publish container (see details)", (Throwable)e);
        }
    }

    private void schedulePeriodicUpdates() {
        this.context.events().subscribe(new Object(){

            @Observes(value={"activation", "part_activation"}, kind=Observes.Kind.resilient)
            synchronized void restartPeriodicUpdates(ContainerLifecycle lc) {
                if (ProfileManager.this.periodicUpdates != null) {
                    return;
                }
                if (lc.state() == ContainerState.active) {
                    log.info("scheduling periodic updates of container profile");
                } else {
                    log.info("resuming periodic updates of container profile");
                }
                Runnable updateTask = new Runnable(){

                    @Override
                    public void run() {
                        HostingNode profile = ProfileManager.this.context.profile(HostingNode.class);
                        try {
                            ProfileManager.this.builder.update(profile, false);
                        }
                        catch (Exception e) {
                            log.error("cannot complete periodic update of container profile", (Throwable)e);
                        }
                        log.trace("firing change event on container profile");
                        ProfileManager.this.context.events().fire((Object)profile, new String[]{"changed"});
                    }
                };
                ProfileManager.this.periodicUpdates = Utils.scheduledServicePool.scheduleAtFixedRate(updateTask, 3L, ProfileManager.this.context.configuration().publicationFrequency(), TimeUnit.SECONDS);
            }

            @Observes(value={"stop", "failure", "shutdown"}, kind=Observes.Kind.resilient)
            synchronized void cancelPeriodicUpdates(ContainerLifecycle ignore) {
                if (ProfileManager.this.periodicUpdates != null) {
                    log.trace("stopping periodic updates of container profile");
                    try {
                        ProfileManager.this.periodicUpdates.cancel(true);
                        ProfileManager.this.periodicUpdates = null;
                    }
                    catch (Exception e) {
                        log.warn("could not stop periodic updates of container profile", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public String toString() {
        return "profile-management";
    }
}

