/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.validations.validators;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import org.gcube.accounting.aggregator.RegexRulesAggregator;
import org.gcube.accounting.datamodel.basetypes.AbstractServiceUsageRecord;
import org.gcube.accounting.datamodel.validations.validators.RegexReplace;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.implementation.FieldAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalledMethodRegexReplaceValidator
implements FieldAction {
    private static Logger logger = LoggerFactory.getLogger(CalledMethodRegexReplaceValidator.class);

    public Serializable validate(String key, Serializable value, Record record) throws InvalidValueException {
        if (!(record instanceof AbstractServiceUsageRecord)) {
            throw new RuntimeException(record.toString() + "is not an instace of " + AbstractServiceUsageRecord.class.getSimpleName());
        }
        if (!(value instanceof String)) {
            throw new InvalidValueException(value.toString() + "is not a " + String.class.getSimpleName());
        }
        String stringValue = (String)((Object)value);
        AbstractServiceUsageRecord serviceUsageRecord = (AbstractServiceUsageRecord)record;
        String serviceClass = serviceUsageRecord.getServiceClass();
        if (serviceClass == null) {
            logger.debug("{} is not already set. The check will be postponed to validation phase", (Object)"serviceClass");
            return value;
        }
        String serviceName = serviceUsageRecord.getServiceName();
        if (serviceName == null) {
            logger.debug("{} is not already set. The check will be postponed to validation phase", (Object)"serviceName");
            return value;
        }
        List<RegexReplace> regexReplaceList = RegexRulesAggregator.getInstance().getRegexReplaceList();
        for (RegexReplace regexReplace : regexReplaceList) {
            Matcher matcher;
            if (serviceClass.compareTo(regexReplace.getServiceClass()) != 0 || serviceName.compareTo(regexReplace.getServiceName()) != 0 || !(matcher = regexReplace.regexPattern.matcher(stringValue)).matches()) continue;
            return regexReplace.getReplace();
        }
        return value;
    }
}

