/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.extensions;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.smartgears.configuration.application.Exclude;
import org.gcube.smartgears.extensions.ApiMethodSignature;
import org.gcube.smartgears.extensions.ApiSignature;
import org.gcube.smartgears.extensions.HttpExtension;

public abstract class ApiResource
extends HttpExtension {
    private static final long serialVersionUID = 1L;
    private final ApiSignature signature;

    public static ApiSignature handles(String mapping) {
        return new ApiSignature(mapping);
    }

    public static ApiMethodSignature method(HttpExtension.Method method) {
        return new ApiMethodSignature(method);
    }

    public ApiResource(ApiSignature signature) {
        super("extension-resource", signature.mapping());
        this.signature = signature;
    }

    @Override
    public Set<Exclude> excludes() {
        return Collections.singleton(new Exclude("/gcube/resource" + this.mapping()));
    }

    public boolean supports(HttpExtension.Method method) {
        return this.signature.methods().contains((Object)method);
    }

    public boolean accepts(HttpExtension.Method method, String type) {
        Set<String> requestTypes = this.signature.requestTypes().get((Object)method);
        return requestTypes.isEmpty() || requestTypes.contains(type);
    }

    public boolean produces(HttpExtension.Method method, String type) {
        if (type.contains("*")) {
            return true;
        }
        Set<String> contentTypes = this.signature.responseTypes().get((Object)method);
        return contentTypes.contains(type);
    }

    public ApiSignature signature() {
        return this.signature;
    }

    public void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }
}

