/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils.discovery;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.utils.discovery.ReflectionUtility;
import org.gcube.informationsystem.utils.discovery.SchemaAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementSpecilizationDiscovery<E extends Element> {
    private static Logger logger = LoggerFactory.getLogger(ElementSpecilizationDiscovery.class);
    protected final Class<E> root;
    protected final List<Package> packages;
    protected final List<Class<? extends E>> discovered;

    public List<Class<? extends E>> getDiscovered() {
        return this.discovered;
    }

    public ElementSpecilizationDiscovery(Class<E> root) {
        this.root = root;
        this.packages = new ArrayList<Package>();
        this.addPackage(root.getPackage());
        this.discovered = new ArrayList<Class<? extends E>>();
        this.add(root);
    }

    public void addPackage(Package p) {
        this.packages.add(p);
    }

    protected void add(Class<? extends E> clz) {
        if (!this.discovered.contains(clz)) {
            this.discovered.add(clz);
            logger.info("+ Added {}.", clz);
        }
    }

    protected void analizeISM(Class<? extends E> clz) {
        logger.trace("Analizyng {}", clz);
        if (!clz.isInterface()) {
            logger.trace("- Discarding {} that is not an interface", clz);
            return;
        }
        if (!this.root.isAssignableFrom(clz)) {
            logger.trace("- Discarding {} because is not a {}", clz, (Object)this.root.getSimpleName());
            return;
        }
        if (this.discovered.contains(clz)) {
            logger.trace("- Discarding {} because was already managed", clz);
            return;
        }
        Class<?>[] interfaces = clz.getInterfaces();
        GenericDeclaration[] genericDeclarationArray = interfaces;
        int n = genericDeclarationArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz;
            Class<?> parent = clazz = genericDeclarationArray[i];
            this.analizeISM(parent);
        }
        if (this.root == PropertyElement.class) {
            for (GenericDeclaration genericDeclaration : clz.getDeclaredMethods()) {
                ((Method)genericDeclaration).setAccessible(true);
                if (!((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(ISProperty.class)) continue;
                if (Map.class.isAssignableFrom(((Method)genericDeclaration).getReturnType()) || Set.class.isAssignableFrom(((Method)genericDeclaration).getReturnType()) || List.class.isAssignableFrom(((Method)genericDeclaration).getReturnType())) {
                    Type[] typeArguments;
                    for (Type t : typeArguments = ((ParameterizedType)((Method)genericDeclaration).getGenericReturnType()).getActualTypeArguments()) {
                        Class tClass = (Class)t;
                        if (!this.root.isAssignableFrom(tClass)) continue;
                        Class type = tClass;
                        this.analizeISM(type);
                    }
                    continue;
                }
                if (!this.root.isAssignableFrom(((Method)genericDeclaration).getReturnType())) continue;
                Class<?> type = ((Method)genericDeclaration).getReturnType();
                this.analizeISM(type);
            }
        }
        this.add(clz);
    }

    public void discover() throws Exception {
        for (Package p : this.packages) {
            List<Class<?>> classes = ReflectionUtility.getClassesForPackage(p);
            Iterator<Class<?>> iterator = classes.iterator();
            while (iterator.hasNext()) {
                Class<?> clz;
                Class<?> ism = clz = iterator.next();
                this.analizeISM(ism);
            }
        }
    }

    public static void manageISM(SchemaAction schemaAction, List<Package> packages) throws Exception {
        if (Objects.nonNull(packages) && packages.size() > 0) {
            ElementSpecilizationDiscovery.manageISM(schemaAction, (Package[])packages.stream().toArray(Package[]::new));
        } else {
            ElementSpecilizationDiscovery.manageISM(schemaAction, new Package[0]);
        }
    }

    public static void manageISM(SchemaAction schemaAction, Package ... packages) throws Exception {
        ElementSpecilizationDiscovery<PropertyElement> propertyDiscovery = new ElementSpecilizationDiscovery<PropertyElement>(PropertyElement.class);
        if (Objects.nonNull(packages)) {
            Arrays.stream(packages).forEach(p -> propertyDiscovery.addPackage((Package)p));
        }
        propertyDiscovery.discover();
        for (Class<PropertyElement> clazz : propertyDiscovery.getDiscovered()) {
            logger.trace("Going to manage : {}", clazz);
            schemaAction.managePropertyClass(clazz);
        }
        ElementSpecilizationDiscovery<EntityElement> entityDiscovery = new ElementSpecilizationDiscovery<EntityElement>(EntityElement.class);
        if (Objects.nonNull(packages)) {
            Arrays.stream(packages).forEach(p -> entityDiscovery.addPackage((Package)p));
        }
        entityDiscovery.discover();
        for (Class<EntityElement> clazz : entityDiscovery.getDiscovered()) {
            logger.trace("Going to manage : {}", clazz);
            schemaAction.manageEntityClass(clazz);
        }
        ElementSpecilizationDiscovery<RelationElement> elementSpecilizationDiscovery = new ElementSpecilizationDiscovery<RelationElement>(RelationElement.class);
        if (Objects.nonNull(packages)) {
            Arrays.stream(packages).forEach(p -> relationDiscovery.addPackage((Package)p));
        }
        elementSpecilizationDiscovery.discover();
        for (Class<RelationElement> relation : elementSpecilizationDiscovery.getDiscovered()) {
            logger.trace("Going to manage : {}", relation);
            schemaAction.manageRelationClass(relation);
        }
    }
}

