/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.queries.templates.reference.entities;

import java.io.IOException;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.queries.templates.impl.entities.QueryTemplateImpl;
import org.gcube.informationsystem.queries.templates.reference.properties.TemplateVariable;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(as=QueryTemplateImpl.class)
@TypeMetadata(name="QueryTemplate", description="The type used to store Query Templates", version="1.0.0")
@Change(version="1.0.0", description="First Version")
public interface QueryTemplate
extends EntityElement {
    public static final String NAME = "QueryTemplate";
    public static final String NAME_PROPERTY = "name";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String TEMPLATE_PROPERTY = "template";
    public static final String TEMPLATE_VARIABLES_PROPERTY = "templateVariables";

    @ISProperty(name="name", description="The name of the Query Template. Among UUID univocally identifiy the Query Template.", readonly=true, mandatory=true, nullable=false)
    public String getName();

    public void setName(String var1);

    @ISProperty(name="description", description="The description of the Query Template.", readonly=false, mandatory=true, nullable=false)
    public String getDescription();

    public void setDescription(String var1);

    @JsonIgnore
    @ISProperty(name="template", description="The Query Template. It can contains query variables to be replaced to obtain a runnable query.", readonly=false, mandatory=true, nullable=false)
    public String getTemplateAsString() throws JsonProcessingException;

    @JsonIgnore
    public void setTemplate(String var1) throws JsonProcessingException, IOException;

    @JsonSetter(value="template")
    public void setTemplate(JsonNode var1);

    @JsonGetter(value="template")
    public JsonNode getTemplate();

    @JsonGetter(value="templateVariables")
    @ISProperty(name="templateVariables", description="The Query Template Variables. It can contains Query Template Variable to be replaced to obtain a runnable query.", readonly=false, mandatory=true, nullable=false)
    public Map<String, TemplateVariable> getTemplateVariables();

    @JsonIgnore
    public void addTemplateVariable(TemplateVariable var1);

    @JsonIgnore
    public ObjectNode getParamsFromDefaultValues();

    @JsonIgnore
    public JsonNode getJsonQuery() throws Exception;

    @JsonIgnore
    public JsonNode getJsonQuery(JsonNode var1) throws Exception;
}

