/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.gcore;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.common.AnyWrapper;
import org.gcube.common.resources.gcore.common.DateWrapper;
import org.gcube.common.resources.gcore.common.GHNReference;
import org.gcube.common.resources.gcore.common.Identity;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.common.ServiceReference;
import org.gcube.common.resources.gcore.utils.Group;
import org.w3c.dom.Element;

@XmlRootElement(name="Resource")
@XmlType(propOrder={"profile"})
public class GCoreEndpoint
extends Resource {
    @XmlElementRef
    private Profile profile = new Profile();

    public GCoreEndpoint() {
        this.type(Resource.Type.GCOREENDPOINT);
    }

    @Override
    public Profile profile() {
        return this.profile;
    }

    @XmlType(propOrder={"description", "version", "ghn", "service", "serviceName", "serviceClass", "security", "platform", "deploymentData", "functions", "accessPoint", "specificData", "accountings"})
    @XmlRootElement(name="Profile")
    public static class Profile {
        @XmlElement(name="Description")
        private String description;
        @XmlElement(name="Version")
        private String version;
        @XmlElement(name="GHN")
        private GHNReference ghn;
        @XmlElement(name="Service")
        private ServiceReference service;
        @XmlElement(name="ServiceName")
        private String serviceName;
        @XmlElement(name="ServiceClass")
        private String serviceClass;
        @XmlElementRef
        @XmlElementWrapper(name="RunningInstanceSecurity")
        private List<Security> security = new ArrayList<Security>();
        @XmlElementRef
        private Platform platform;
        @XmlElementRef
        private DeploymentData deploymentData;
        @XmlElementWrapper(name="RIEquivalenceFunctions")
        @XmlElementRef
        private List<Function> functions = new ArrayList<Function>();
        @XmlElementRef
        private AccessPoint accessPoint = new AccessPoint();
        @XmlElementRef
        private SpecificData specificData = new SpecificData();
        @XmlElementWrapper(name="Accounting")
        @XmlElementRef
        private List<ScopedAccounting> accountings = new ArrayList<ScopedAccounting>();

        void beforeMarshal(Marshaller marshaller) {
            if (this.security != null && this.security.isEmpty()) {
                this.security = null;
            }
            if (this.functions != null && this.functions.isEmpty()) {
                this.functions = null;
            }
            if (this.accountings != null && this.accountings.isEmpty()) {
                this.accountings = null;
            }
            if (this.accessPoint != null && this.accessPoint.endpoints.isEmpty()) {
                this.accessPoint = null;
            }
            if (this.specificData != null && this.specificData().getChildNodes().getLength() == 0) {
                this.specificData = null;
            }
        }

        void afterMarshal(Marshaller marshaller) {
            if (this.security == null) {
                this.security = new ArrayList<Security>();
            }
            if (this.functions == null) {
                this.functions = new ArrayList<Function>();
            }
            if (this.accountings == null) {
                this.accountings = new ArrayList<ScopedAccounting>();
            }
            if (this.specificData == null) {
                this.specificData = new SpecificData();
            }
            if (this.accessPoint == null) {
                this.accessPoint = new AccessPoint();
            }
        }

        public String description() {
            return this.description;
        }

        public Profile description(String description) {
            this.description = description;
            return this;
        }

        public String version() {
            return this.version;
        }

        public Profile version(String version) {
            this.version = version;
            return this;
        }

        public String ghnId() {
            return this.ghn == null ? null : this.ghn.id;
        }

        public Profile ghnId(String id) {
            this.ghn = new GHNReference();
            this.ghn.id = id;
            return this;
        }

        public String serviceId() {
            return this.service == null ? null : this.service.id;
        }

        public Profile serviceId(String id) {
            this.service = new ServiceReference();
            this.service.id = id;
            return this;
        }

        public String serviceName() {
            return this.serviceName;
        }

        public Profile serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public String serviceClass() {
            return this.serviceClass;
        }

        public Profile serviceClass(String serviceClass) {
            this.serviceClass = serviceClass;
            return this;
        }

        public Group<Security> security() {
            return new Group<Security>(this.security, Security.class);
        }

        public Map<String, Security> securityMap() {
            HashMap<String, Security> map = new HashMap<String, Security>();
            for (Security s : this.security) {
                if (s.name() == null) continue;
                map.put(s.name(), s);
            }
            return map;
        }

        public DeploymentData deploymentData() {
            return this.deploymentData;
        }

        public DeploymentData newDeploymentData() {
            this.deploymentData = new DeploymentData();
            return this.deploymentData;
        }

        public Group<Function> functions() {
            return new Group<Function>(this.functions, Function.class);
        }

        public Map<String, Function> functionMap() {
            HashMap<String, Function> map = new HashMap<String, Function>();
            for (Function f : this.functions) {
                if (f.name() == null) continue;
                map.put(f.name(), f);
            }
            return map;
        }

        public Platform platform() {
            return this.platform;
        }

        public boolean hasPlatform() {
            return this.platform != null;
        }

        public Platform newPlatform() {
            this.platform = new Platform();
            return this.platform;
        }

        public Group<Endpoint> endpoints() {
            return new Group<Endpoint>(this.accessPoint.endpoints, Endpoint.class);
        }

        public Map<String, Endpoint> endpointMap() {
            HashMap<String, Endpoint> map = new HashMap<String, Endpoint>();
            for (Endpoint e : this.accessPoint.endpoints) {
                if (e.name() == null) continue;
                map.put(e.name(), e);
            }
            return map;
        }

        public Element specificData() {
            return this.specificData.root();
        }

        public Group<ScopedAccounting> accountings() {
            return new Group<ScopedAccounting>(this.accountings, ScopedAccounting.class);
        }

        public Map<String, ScopedAccounting> accountingsMap() {
            HashMap<String, ScopedAccounting> map = new HashMap<String, ScopedAccounting>();
            for (ScopedAccounting sa : this.accountings) {
                if (sa.scope() == null) continue;
                map.put(sa.scope(), sa);
            }
            return map;
        }

        public String toString() {
            return "[description=" + this.description + ", version=" + this.version + ", ghn=" + this.ghn + ", service=" + this.service + ", serviceName=" + this.serviceName + ", serviceClass=" + this.serviceClass + ", runningInstanceInterfaces=" + this.security + ", platform=" + this.platform + ", deploymentData=" + this.deploymentData + ", functions=" + this.functions + ", endpoints=" + this.accessPoint.endpoints + ", specificData=" + this.specificData() + ", accountings=" + this.accountings + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.accessPoint == null ? 0 : this.accessPoint.hashCode());
            result = 31 * result + (this.accountings == null ? 0 : this.accountings.hashCode());
            result = 31 * result + (this.deploymentData == null ? 0 : this.deploymentData.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.functions == null ? 0 : this.functions.hashCode());
            result = 31 * result + (this.ghn == null ? 0 : this.ghn.hashCode());
            result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
            result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
            result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
            result = 31 * result + (this.serviceClass == null ? 0 : this.serviceClass.hashCode());
            result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
            result = 31 * result + (this.specificData == null ? 0 : this.specificData.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Profile other = (Profile)obj;
            if (this.accessPoint == null ? other.accessPoint != null : !this.accessPoint.equals(other.accessPoint)) {
                return false;
            }
            if (this.accountings == null ? other.accountings != null : !this.accountings.equals(other.accountings)) {
                return false;
            }
            if (this.deploymentData == null ? other.deploymentData != null : !this.deploymentData.equals(other.deploymentData)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.functions == null ? other.functions != null : !this.functions.equals(other.functions)) {
                return false;
            }
            if (this.ghn == null ? other.ghn != null : !this.ghn.equals(other.ghn)) {
                return false;
            }
            if (this.platform == null ? other.platform != null : !this.platform.equals(other.platform)) {
                return false;
            }
            if (this.security == null ? other.security != null : !this.security.equals(other.security)) {
                return false;
            }
            if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
                return false;
            }
            if (this.serviceClass == null ? other.serviceClass != null : !this.serviceClass.equals(other.serviceClass)) {
                return false;
            }
            if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
                return false;
            }
            if (this.specificData == null ? other.specificData != null : !this.specificData.equals(other.specificData)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        @XmlType(propOrder={"incomingCalls", "averageIncomingCalls", "averageInvocationTime", "topCallerGHN"})
        @XmlRootElement(name="ScopedAccounting")
        public static class ScopedAccounting {
            @XmlAttribute
            private String scope;
            @XmlElement(name="TotalINCalls")
            private long incomingCalls;
            @XmlElement(name="AverageINCalls")
            private List<AverageType> averageIncomingCalls = new ArrayList<AverageType>();
            @XmlElement(name="AverageInvocationTime")
            private List<AverageType> averageInvocationTime = new ArrayList<AverageType>();
            @XmlElement(name="TopCallerGHN")
            private TopCaller topCallerGHN;

            public String scope() {
                return this.scope;
            }

            public ScopedAccounting scope(String scope) {
                this.scope = scope;
                return this;
            }

            public long incomingCalls() {
                return this.incomingCalls;
            }

            public ScopedAccounting incomingCalls(long incomingCalls) {
                this.incomingCalls = incomingCalls;
                return this;
            }

            public Group<AverageType> averageInCalls() {
                return new Group<AverageType>(this.averageIncomingCalls, AverageType.class);
            }

            public Group<AverageType> averageInvocationTime() {
                return new Group<AverageType>(this.averageInvocationTime, AverageType.class);
            }

            public TopCaller topCaller() {
                return this.topCallerGHN;
            }

            public TopCaller newTopCaller() {
                this.topCallerGHN = new TopCaller();
                return this.topCallerGHN;
            }

            public String toString() {
                return "ScopedAccounting [scope=" + this.scope + ", incomingCalls=" + this.incomingCalls + ", averageincomingCalls=" + this.averageIncomingCalls + ", averageInvocationTime=" + this.averageInvocationTime + ", topCaller=" + this.topCallerGHN + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.averageIncomingCalls == null ? 0 : this.averageIncomingCalls.hashCode());
                result = 31 * result + (this.averageInvocationTime == null ? 0 : this.averageInvocationTime.hashCode());
                result = 31 * result + (int)(this.incomingCalls ^ this.incomingCalls >>> 32);
                result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
                result = 31 * result + (this.topCallerGHN == null ? 0 : this.topCallerGHN.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ScopedAccounting other = (ScopedAccounting)obj;
                if (this.averageIncomingCalls == null ? other.averageIncomingCalls != null : !this.averageIncomingCalls.equals(other.averageIncomingCalls)) {
                    return false;
                }
                if (this.averageInvocationTime == null ? other.averageInvocationTime != null : !this.averageInvocationTime.equals(other.averageInvocationTime)) {
                    return false;
                }
                if (this.incomingCalls != other.incomingCalls) {
                    return false;
                }
                if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
                    return false;
                }
                return !(this.topCallerGHN == null ? other.topCallerGHN != null : !this.topCallerGHN.equals(other.topCallerGHN));
            }

            public static class TopCaller {
                @XmlElement(name="GHNName")
                private String name;
                @XmlAttribute(name="avgHourlyCalls")
                private Double avgHourlyCalls;
                @XmlAttribute(name="avgDailyCalls")
                private Double avgDailyCalls;
                @XmlAttribute(name="totalCalls")
                private Long totalCalls;

                public String name() {
                    return this.name;
                }

                public TopCaller name(String name) {
                    this.name = name;
                    return this;
                }

                public TopCaller calls(Double hourlyAverage, Double dailyAverage, Long total) {
                    this.totalCalls = total;
                    this.avgDailyCalls = dailyAverage;
                    this.avgHourlyCalls = hourlyAverage;
                    return this;
                }

                public Double avgHourlyCalls() {
                    return this.avgHourlyCalls;
                }

                public Double avgDailyCalls() {
                    return this.avgDailyCalls;
                }

                public Long totalCalls() {
                    return this.totalCalls;
                }

                public String toString() {
                    return "[ghnName=" + this.name + ", avgHourlyCalls=" + this.avgHourlyCalls + ", avgDailyCalls=" + this.avgDailyCalls + ", totalCalls=" + this.totalCalls + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.avgDailyCalls == null ? 0 : this.avgDailyCalls.hashCode());
                    result = 31 * result + (this.avgHourlyCalls == null ? 0 : this.avgHourlyCalls.hashCode());
                    result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                    result = 31 * result + (this.totalCalls == null ? 0 : this.totalCalls.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    TopCaller other = (TopCaller)obj;
                    if (this.avgDailyCalls == null ? other.avgDailyCalls != null : !this.avgDailyCalls.equals(other.avgDailyCalls)) {
                        return false;
                    }
                    if (this.avgHourlyCalls == null ? other.avgHourlyCalls != null : !this.avgHourlyCalls.equals(other.avgHourlyCalls)) {
                        return false;
                    }
                    if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                        return false;
                    }
                    return !(this.totalCalls == null ? other.totalCalls != null : !this.totalCalls.equals(other.totalCalls));
                }
            }

            public static class AverageType {
                @XmlAttribute(name="interval")
                private Long interval;
                @XmlAttribute(name="average")
                private Double average;

                public Long interval() {
                    return this.interval;
                }

                public Double average() {
                    return this.average;
                }

                public void intervalAndAverage(Long interval, Double average) {
                    this.interval = interval;
                    this.average = average;
                }

                public String toString() {
                    return "[interval=" + this.interval + ", average=" + this.average + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.average == null ? 0 : this.average.hashCode());
                    result = 31 * result + (this.interval == null ? 0 : this.interval.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    AverageType other = (AverageType)obj;
                    if (this.average == null ? other.average != null : !this.average.equals(other.average)) {
                        return false;
                    }
                    return !(this.interval == null ? other.interval != null : !this.interval.equals(other.interval));
                }
            }
        }

        public static class Endpoint {
            @XmlAttribute(name="EntryName")
            private String name;
            @XmlValue
            private URI uri;

            public String name() {
                return this.name;
            }

            public Endpoint nameAndAddress(String name, URI uri) {
                this.name = name;
                this.uri = uri;
                return this;
            }

            public URI uri() {
                return this.uri;
            }

            public String toString() {
                return "Endpoint [name=" + this.name + ", uri=" + this.uri + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Endpoint other = (Endpoint)obj;
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
            }
        }

        @XmlRootElement(name="AccessPoint")
        public static class AccessPoint {
            @XmlElementWrapper(name="RunningInstanceInterfaces")
            @XmlElement(name="Endpoint")
            private Set<Endpoint> endpoints = new LinkedHashSet<Endpoint>();

            public String toString() {
                return "[endpoints=" + this.endpoints + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.endpoints == null ? 0 : this.endpoints.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                AccessPoint other = (AccessPoint)obj;
                return !(this.endpoints == null ? other.endpoints != null : !this.endpoints.equals(other.endpoints));
            }
        }

        @XmlType(propOrder={"name", "parameters"})
        @XmlRootElement(name="Function")
        public static class Function {
            @XmlElement(name="Name")
            private String name;
            @XmlElementWrapper(name="ActualParameters")
            @XmlElement(name="Param")
            private List<Parameter> parameters = new ArrayList<Parameter>();

            public String name() {
                return this.name;
            }

            public Function name(String name) {
                this.name = name;
                return this;
            }

            public Group<Parameter> parameters() {
                return new Group<Parameter>(this.parameters, Parameter.class);
            }

            public Map<String, Parameter> parametersMap() {
                HashMap<String, Parameter> map = new HashMap<String, Parameter>();
                for (Parameter p : this.parameters) {
                    if (p.name() == null) continue;
                    map.put(p.name(), p);
                }
                return map;
            }

            public String toString() {
                return "[name=" + this.name + ", parameters=" + this.parameters + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Function other = (Function)obj;
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
            }

            @XmlType(propOrder={"name", "values"})
            public static class Parameter {
                @XmlElement(name="Name")
                String name;
                @XmlElement(name="Value")
                List<String> values = new ArrayList<String>();

                public String name() {
                    return this.name;
                }

                public List<String> values() {
                    return this.values;
                }

                public void nameAndValues(String name, String value, String ... values) {
                    this.name = name;
                    this.values.add(value);
                    this.values.addAll(Arrays.asList(values));
                }

                public String toString() {
                    return "[name=" + this.name + ", values=" + this.values + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                    result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Parameter other = (Parameter)obj;
                    if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                        return false;
                    }
                    return !(this.values == null ? other.values != null : !this.values.equals(other.values));
                }
            }
        }

        @XmlType(propOrder={"name", "path", "activationTime", "terminationTime", "status", "statusMsg", "plugins"})
        @XmlRootElement(name="DeploymentData")
        public static class DeploymentData {
            @XmlElement(name="InstanceName")
            private String name;
            @XmlElement(name="LocalPath")
            private String path;
            @XmlElement(name="ActivationTime")
            private DateWrapper activationTime = new DateWrapper();
            @XmlElement(name="TerminationTime")
            private DateWrapper terminationTime = new DateWrapper();
            @XmlElement(name="Status")
            private String status;
            @XmlElement(name="MessageState")
            private String statusMsg;
            @XmlElementWrapper(name="AvailablePlugins")
            @XmlElement(name="Plugin")
            private List<Plugin> plugins = new ArrayList<Plugin>();

            void beforeMarshal(Marshaller marshaller) {
                if (this.terminationTime != null && this.terminationTime.value == null) {
                    this.terminationTime = null;
                }
                if (this.plugins != null && this.plugins.isEmpty()) {
                    this.plugins = null;
                }
            }

            void afterMarshal(Marshaller marshaller) {
                if (this.terminationTime == null) {
                    this.terminationTime = new DateWrapper();
                }
                if (this.plugins == null) {
                    this.plugins = new ArrayList<Plugin>();
                }
            }

            public String name() {
                return this.name;
            }

            public DeploymentData name(String name) {
                this.name = name;
                return this;
            }

            public String path() {
                return this.path;
            }

            public DeploymentData path(String path) {
                this.path = path;
                return this;
            }

            public Calendar activationTime() {
                return this.activationTime.value;
            }

            public DeploymentData activationTime(Calendar activationTime) {
                this.activationTime.value = activationTime;
                return this;
            }

            public Calendar terminationTime() {
                return this.terminationTime.value;
            }

            public DeploymentData terminationTime(Calendar terminationTime) {
                this.terminationTime.value = terminationTime;
                return this;
            }

            public String status() {
                return this.status;
            }

            public DeploymentData status(String status) {
                this.status = status;
                return this;
            }

            public String statusMessage() {
                return this.statusMsg;
            }

            public DeploymentData statusMessage(String statusMsg) {
                this.statusMsg = statusMsg;
                return this;
            }

            public Group<Plugin> plugins() {
                return new Group<Plugin>(this.plugins, Plugin.class);
            }

            public String toString() {
                return "[instanceName=" + this.name + ", localPath=" + this.path + ", activationTime=" + this.activationTime + ", terminationTime=" + this.terminationTime + ", status=" + this.status + ", messageState=" + this.statusMsg + ", plugins=" + this.plugins + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.activationTime == null ? 0 : this.activationTime.hashCode());
                result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
                result = 31 * result + (this.plugins == null ? 0 : this.plugins.hashCode());
                result = 31 * result + (this.statusMsg == null ? 0 : this.statusMsg.hashCode());
                result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
                result = 31 * result + (this.terminationTime == null ? 0 : this.terminationTime.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                DeploymentData other = (DeploymentData)obj;
                if (this.activationTime == null ? other.activationTime != null : !this.activationTime.equals(other.activationTime)) {
                    return false;
                }
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                    return false;
                }
                if (this.plugins == null ? other.plugins != null : !this.plugins.equals(other.plugins)) {
                    return false;
                }
                if (this.statusMsg == null ? other.statusMsg != null : !this.statusMsg.equals(other.statusMsg)) {
                    return false;
                }
                if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
                    return false;
                }
                return !(this.terminationTime == null ? other.terminationTime != null : !this.terminationTime.equals(other.terminationTime));
            }

            @XmlType(propOrder={"service", "package_", "version"})
            public static class Plugin {
                @XmlElement(name="Service")
                private Service service = new Service();
                @XmlElement(name="Package")
                private String package_;
                @XmlElement(name="Version")
                private String version;

                public Service service() {
                    return this.service;
                }

                public Plugin service(Service service) {
                    this.service = service;
                    return this;
                }

                public Plugin service(String serviceClass, String serviceName, String version) {
                    this.service.clazz = serviceClass;
                    this.service.name = serviceName;
                    this.service.version = version;
                    return this;
                }

                public String pluginPackage() {
                    return this.package_;
                }

                public Plugin pluginPackage(String pluginPackage) {
                    this.package_ = pluginPackage;
                    return this;
                }

                public String version() {
                    return this.version;
                }

                public Plugin version(String version) {
                    this.version = version;
                    return this;
                }

                public String toString() {
                    return "[service=" + this.service + ", package_=" + this.package_ + ", version=" + this.version + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.package_ == null ? 0 : this.package_.hashCode());
                    result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
                    result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Plugin other = (Plugin)obj;
                    if (this.package_ == null ? other.package_ != null : !this.package_.equals(other.package_)) {
                        return false;
                    }
                    if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
                        return false;
                    }
                    return !(this.version == null ? other.version != null : !this.version.equals(other.version));
                }

                public static class Service {
                    @XmlElement(name="Class")
                    private String clazz;
                    @XmlElement(name="Name")
                    private String name;
                    @XmlElement(name="Version")
                    private String version;

                    public String serviceClass() {
                        return this.clazz;
                    }

                    public String serviceName() {
                        return this.name;
                    }

                    public String version() {
                        return this.version;
                    }

                    public String toString() {
                        return "[class=" + this.clazz + ", name=" + this.name + ", version=" + this.version + "]";
                    }

                    public int hashCode() {
                        int prime = 31;
                        int result = 1;
                        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
                        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
                        return result;
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        Service other = (Service)obj;
                        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                            return false;
                        }
                        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                            return false;
                        }
                        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
                    }
                }
            }
        }

        @XmlType(propOrder={"identity"})
        @XmlRootElement(name="RunningInstanceInterface")
        public static class Security {
            @XmlElementRef
            private Identity identity;
            @XmlAttribute(name="EntryName")
            private String name;

            public boolean hasIdentity() {
                return this.identity != null;
            }

            public Identity newIdentity() {
                this.identity = new Identity();
                return this.identity;
            }

            public String name() {
                return this.name;
            }

            public Security name(String name) {
                this.name = name;
                return this;
            }

            public String toString() {
                return "Security [identity=" + this.identity + ", name=" + this.name + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                result = 31 * result + (this.identity == null ? 0 : this.identity.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Security other = (Security)obj;
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                return !(this.identity == null ? other.identity != null : !this.identity.equals(other.identity));
            }
        }

        @XmlRootElement(name="SpecificData")
        public static class SpecificData
        extends AnyWrapper {
        }
    }
}

