/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.persistence;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.validator.annotations.NotEmpty;
import org.gcube.common.validator.annotations.NotNull;
import org.gcube.smartgears.persistence.PersistenceWriter;
import org.gcube.smartgears.utils.Utils;

@XmlRootElement(name="persistence")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LocalPersistence
implements PersistenceWriter {
    @XmlAttribute(name="location")
    @NotNull
    @NotEmpty
    private String location;

    protected LocalPersistence() {
    }

    public LocalPersistence(String location) {
        Utils.notNull("persistence location", location);
        this.location = location;
        this.validate();
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public File writefile(String path) {
        Utils.notNull("relative path", path);
        return Utils.fileAt(new File(this.location, path).getAbsolutePath()).toWrite();
    }

    @Override
    public File file(String path) {
        Utils.notNull("relative path", path);
        return Utils.fileAt(new File(this.location, path).getAbsolutePath()).toRead();
    }

    public void validate() {
        File locationDir = new File(this.location);
        if (!(locationDir.exists() && locationDir.isDirectory() && locationDir.canRead() && locationDir.canWrite())) {
            throw new IllegalStateException("invalid node configuration: home " + this.location + " does not exist or is not a directory or cannot be accessed in read/write mode");
        }
    }

    @Override
    public long getFreeSpace() {
        try {
            return Files.getFileStore(Paths.get(this.location, new String[0])).getUsableSpace();
        }
        catch (Exception e) {
            return -1L;
        }
    }
}

