/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.impl.entities;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.annotations.ResourceSchema;
import org.gcube.informationsystem.types.annotations.ResourceSchemaEntry;
import org.gcube.informationsystem.types.impl.entities.EntityTypeImpl;
import org.gcube.informationsystem.types.impl.properties.LinkedEntityImpl;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;

@JsonTypeName(value="ResourceType")
public class ResourceTypeImpl
extends EntityTypeImpl
implements ResourceType {
    private static final long serialVersionUID = -5964819173421808432L;
    protected List<LinkedEntity> facets;
    protected List<LinkedEntity> resources;

    protected ResourceTypeImpl() {
    }

    public ResourceTypeImpl(Class<? extends Resource> clz) {
        super((Class<? extends EntityElement>)clz);
        this.superClasses = this.retrieveSuperClasses(clz, Resource.class, "Entity");
        this.setResourceSchemaEntries(clz);
    }

    private void setResourceSchemaEntries(Class<? extends Resource> clz) {
        if (clz.isAnnotationPresent(ResourceSchema.class)) {
            LinkedEntityImpl linkedEntity;
            this.facets = new ArrayList<LinkedEntity>();
            this.resources = new ArrayList<LinkedEntity>();
            ResourceSchema[] resourceSchemaArray = (ResourceSchema[])clz.getAnnotationsByType(ResourceSchema.class);
            for (ResourceSchemaEntry resourceSchemaEntry : resourceSchemaArray[0].facets()) {
                linkedEntity = new LinkedEntityImpl();
                linkedEntity.setSource(TypeMapper.getType(clz));
                linkedEntity.setRelation(TypeMapper.getType(resourceSchemaEntry.relation()));
                linkedEntity.setTarget(TypeMapper.getType(resourceSchemaEntry.facet()));
                linkedEntity.setDescription(resourceSchemaEntry.description());
                linkedEntity.setMin(resourceSchemaEntry.min());
                linkedEntity.setMax(resourceSchemaEntry.max());
                this.facets.add(linkedEntity);
            }
            for (Annotation annotation : resourceSchemaArray[0].resources()) {
                linkedEntity = new LinkedEntityImpl();
                linkedEntity.setSource(TypeMapper.getType(annotation.source()));
                linkedEntity.setRelation(TypeMapper.getType(annotation.relation()));
                linkedEntity.setTarget(TypeMapper.getType(annotation.target()));
                linkedEntity.setDescription(annotation.description());
                linkedEntity.setMin(0);
                linkedEntity.setMax(-1);
                this.resources.add(linkedEntity);
            }
        }
    }

    @Override
    public List<LinkedEntity> getFacets() {
        return this.facets;
    }

    @Override
    public List<LinkedEntity> getResources() {
        return this.resources;
    }

    @Override
    @JsonIgnore
    public AccessType getAccessType() {
        return AccessType.RESOURCE;
    }
}

