/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.client;

import org.gcube.informationsystem.resourceregistry.api.rest.ServiceInstance;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryClientFactory.class);
    protected static boolean HIERARCHICAL_MODE;
    protected static boolean INCLUDE_CONTEXTS_IN_INSTANCES_HEADER;
    private static String FORCED_URL;

    protected static boolean isHierarchicalMode() {
        return HIERARCHICAL_MODE;
    }

    public static void setHierarchicalMode(boolean hierarchicalMode) {
        HIERARCHICAL_MODE = hierarchicalMode;
    }

    protected static boolean includeContextsInInstanceHeader() {
        return INCLUDE_CONTEXTS_IN_INSTANCES_HEADER;
    }

    public static void includeContextsInInstanceHeader(boolean includeContextsInInstancesHeader) {
        INCLUDE_CONTEXTS_IN_INSTANCES_HEADER = includeContextsInInstancesHeader;
    }

    protected static void forceToURL(String url) {
        FORCED_URL = url;
        HIERARCHICAL_MODE = false;
    }

    public static ResourceRegistryClient create() {
        String address = null;
        address = FORCED_URL != null ? FORCED_URL : String.format("%s/%s", ServiceInstance.getServiceURL(), "resource-registry");
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistryClientImpl(address);
    }

    static {
        FORCED_URL = null;
    }
}

